/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.scram;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Map;

class ScramUtil {
    ScramUtil() {
    }

    static int getIntProperty(Map<String, ?> props, String name, int defVal) {
        Object val = props.get(name);
        if (val == null) {
            return defVal;
        }
        return Integer.parseInt(val.toString());
    }

    static SecureRandom getSecureRandom(Map<String, ?> props) {
        Object propVal = props.get("wildfly.sasl.secure-rng");
        String rngName = propVal instanceof String ? (String)propVal : null;
        SecureRandom secureRandom = null;
        if (rngName != null) {
            try {
                secureRandom = SecureRandom.getInstance(rngName);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        return secureRandom;
    }
}

