/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.principal;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.wildfly.common.Assert;
import org.wildfly.security.util.ArrayIterator;

public final class CompositePrincipal
implements Principal,
Serializable,
Iterable<Principal> {
    private static final long serialVersionUID = -2610733957848661774L;
    private static final Principal[] NO_PRINCIPALS = new Principal[0];
    private final Principal[] p;

    public CompositePrincipal(Collection<Principal> principals) {
        this(principals.toArray(NO_PRINCIPALS), false);
    }

    public CompositePrincipal(Principal ... principals) {
        this(principals, true);
    }

    private CompositePrincipal(Principal[] principals, boolean clone) {
        this.p = principals.length == 0 ? NO_PRINCIPALS : (clone ? (Principal[])principals.clone() : principals);
        for (int i = 0; i < this.p.length; ++i) {
            Assert.checkNotNullArrayParam((String)"principals", (int)i, (Object)this.p[i]);
        }
    }

    @Override
    public String getName() {
        return Arrays.toString(this.p);
    }

    public boolean contains(Principal principal) {
        Assert.checkNotNullParam((String)"principal", (Object)principal);
        for (Principal test : this.p) {
            if (!test.equals(principal)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Class<? extends Principal> type) {
        Assert.checkNotNullParam((String)"type", type);
        for (Principal test : this.p) {
            if (!type.isInstance(test)) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.p.length;
    }

    public Principal get(int idx) {
        try {
            return this.p[idx];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException();
        }
    }

    public <P extends Principal> P get(int idx, Class<P> type) {
        Assert.checkNotNullParam((String)"type", type);
        Principal item = this.get(idx);
        return (P)(type.isInstance(item) ? (Principal)type.cast(item) : null);
    }

    public <P extends Principal> P get(Class<P> type) {
        Assert.checkNotNullParam((String)"type", type);
        for (Principal item : this.p) {
            if (!type.isInstance(item)) continue;
            type.cast(item);
        }
        return null;
    }

    @Override
    public Iterator<Principal> iterator() {
        return new ArrayIterator((Object[])this.p);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof CompositePrincipal && this.equals((CompositePrincipal)obj);
    }

    public boolean equals(CompositePrincipal obj) {
        return obj == this || obj != null && Arrays.deepEquals(this.p, obj.p);
    }

    @Override
    public int hashCode() {
        return Arrays.deepHashCode(this.p);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        if (this.p == null) {
            throw new InvalidObjectException("Null principals array");
        }
        for (Principal principal : this.p) {
            if (principal != null) continue;
            throw new InvalidObjectException("Null principal array element");
        }
    }
}

