/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.spec;

import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.Objects;
import org.wildfly.common.Assert;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.password.spec.PasswordSpec;

public final class EncryptablePasswordSpec
implements PasswordSpec {
    private final char[] password;
    private final AlgorithmParameterSpec algorithmParameterSpec;

    public EncryptablePasswordSpec(char[] password, AlgorithmParameterSpec algorithmParameterSpec) {
        Assert.checkNotNullParam((String)"password", (Object)password);
        this.password = password;
        this.algorithmParameterSpec = algorithmParameterSpec;
    }

    public char[] getPassword() {
        return this.password;
    }

    public AlgorithmParameterSpec getAlgorithmParameterSpec() {
        return this.algorithmParameterSpec;
    }

    public boolean equals(Object other) {
        if (!(other instanceof EncryptablePasswordSpec)) {
            return false;
        }
        EncryptablePasswordSpec o = (EncryptablePasswordSpec)other;
        return Arrays.equals(this.password, o.password) && Objects.equals(this.algorithmParameterSpec, o.algorithmParameterSpec);
    }

    public int hashCode() {
        return HashMath.multiHashOrdered((int)Arrays.hashCode(this.password), (int)Objects.hashCode(this.algorithmParameterSpec));
    }
}

