/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential.store;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.wildfly.common.Assert;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.credential.store.CredentialStoreException;
import org.wildfly.security.credential.store.CredentialStoreSpi;
import org.wildfly.security.credential.store.UnsupportedCredentialTypeException;
import org.wildfly.security.credential.store._private.ElytronMessages;
import org.wildfly.security.provider.util.ProviderUtil;

public final class CredentialStore {
    public static final String CREDENTIAL_STORE_TYPE = "CredentialStore";
    private final Provider provider;
    private final String type;
    private final CredentialStoreSpi spi;

    public static CredentialStore getInstance(String algorithm) throws NoSuchAlgorithmException {
        return CredentialStore.getInstance(algorithm, ProviderUtil.INSTALLED_PROVIDERS);
    }

    public static CredentialStore getInstance(String algorithm, Supplier<Provider[]> providers) throws NoSuchAlgorithmException {
        Assert.checkNotNullParam((String)"providers", providers);
        for (Provider provider : providers.get()) {
            Provider.Service service = provider.getService(CREDENTIAL_STORE_TYPE, algorithm);
            if (service == null) continue;
            return new CredentialStore(provider, (CredentialStoreSpi)service.newInstance(null), algorithm);
        }
        throw new NoSuchAlgorithmException();
    }

    public static CredentialStore getInstance(String algorithm, String providerName) throws NoSuchAlgorithmException, NoSuchProviderException {
        Provider provider = Security.getProvider(providerName);
        if (provider == null) {
            throw new NoSuchProviderException(providerName);
        }
        return CredentialStore.getInstance(algorithm, provider);
    }

    public static CredentialStore getInstance(String algorithm, String providerName, Supplier<Provider[]> providers) throws NoSuchAlgorithmException, NoSuchProviderException {
        Assert.checkNotNullParam((String)"algorithm", (Object)algorithm);
        Assert.checkNotNullParam((String)"providerName", (Object)providerName);
        Assert.checkNotNullParam((String)"providers", providers);
        Provider provider = null;
        for (Provider current : providers.get()) {
            if (!providerName.equals(current.getName())) continue;
            provider = current;
            break;
        }
        if (provider == null) {
            throw new NoSuchProviderException(providerName);
        }
        return CredentialStore.getInstance(algorithm, provider);
    }

    public static CredentialStore getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        Provider.Service service = provider.getService(CREDENTIAL_STORE_TYPE, algorithm);
        if (service == null) {
            throw new NoSuchAlgorithmException(algorithm);
        }
        return new CredentialStore(provider, (CredentialStoreSpi)service.newInstance(null), algorithm);
    }

    CredentialStore(Provider provider, CredentialStoreSpi spi, String type) {
        this.provider = provider;
        this.spi = spi;
        this.type = type;
    }

    public void initialize(Map<String, String> attributes, ProtectionParameter protectionParameter, Provider[] providers) throws CredentialStoreException {
        this.spi.initialize(attributes, protectionParameter, providers);
    }

    public void initialize(Map<String, String> attributes, ProtectionParameter protectionParameter) throws CredentialStoreException {
        this.initialize(attributes, protectionParameter, null);
    }

    public void initialize(Map<String, String> attributes) throws CredentialStoreException {
        this.initialize(attributes, null);
    }

    public boolean isInitialized() {
        return this.spi.isInitialized();
    }

    public boolean isModifiable() {
        return this.spi.isModifiable();
    }

    public <C extends Credential> boolean exists(String credentialAlias, Class<C> credentialType) throws CredentialStoreException, UnsupportedCredentialTypeException {
        return this.spi.exists(credentialAlias, credentialType);
    }

    public <C extends Credential> void store(String credentialAlias, C credential) throws CredentialStoreException, UnsupportedCredentialTypeException {
        this.store(credentialAlias, credential, null);
    }

    public <C extends Credential> void store(String credentialAlias, C credential, ProtectionParameter protectionParameter) throws CredentialStoreException, UnsupportedCredentialTypeException {
        if (!this.isModifiable()) {
            throw ElytronMessages.log.nonModifiableCredentialStore("store");
        }
        this.spi.store(credentialAlias, credential, protectionParameter);
    }

    public <C extends Credential> C retrieve(String credentialAlias, Class<C> credentialType) throws CredentialStoreException, UnsupportedCredentialTypeException {
        return this.retrieve(credentialAlias, credentialType, null, null, null);
    }

    public <C extends Credential> C retrieve(String credentialAlias, Class<C> credentialType, String credentialAlgorithm) throws CredentialStoreException {
        return this.retrieve(credentialAlias, credentialType, credentialAlgorithm, null, null);
    }

    public <C extends Credential> C retrieve(String credentialAlias, Class<C> credentialType, String credentialAlgorithm, AlgorithmParameterSpec parameterSpec) throws CredentialStoreException {
        return this.retrieve(credentialAlias, credentialType, credentialAlgorithm, parameterSpec, null);
    }

    public <C extends Credential> C retrieve(String credentialAlias, Class<C> credentialType, String credentialAlgorithm, AlgorithmParameterSpec parameterSpec, ProtectionParameter protectionParameter) throws CredentialStoreException {
        return this.spi.retrieve(credentialAlias, credentialType, credentialAlgorithm, parameterSpec, protectionParameter);
    }

    public void remove(String credentialAlias, Class<? extends Credential> credentialType) throws CredentialStoreException {
        this.remove(credentialAlias, credentialType, null, null);
    }

    public void remove(String credentialAlias, Class<? extends Credential> credentialType, String credentialAlgorithm) throws CredentialStoreException {
        this.remove(credentialAlias, credentialType, credentialAlgorithm, null);
    }

    public void remove(String credentialAlias, Class<? extends Credential> credentialType, String credentialAlgorithm, AlgorithmParameterSpec parameterSpec) throws CredentialStoreException {
        if (!this.isModifiable()) {
            throw ElytronMessages.log.nonModifiableCredentialStore("remove");
        }
        this.spi.remove(credentialAlias, credentialType, credentialAlgorithm, parameterSpec);
    }

    public Set<String> getAliases() throws UnsupportedOperationException, CredentialStoreException {
        return this.spi.getAliases();
    }

    public void flush() throws CredentialStoreException {
        if (!this.isModifiable()) {
            throw ElytronMessages.log.nonModifiableCredentialStore("flush");
        }
        this.spi.flush();
    }

    public Provider getProvider() {
        return this.provider;
    }

    public String getType() {
        return this.type;
    }

    public static final class CredentialSourceProtectionParameter
    implements ProtectionParameter {
        private final CredentialSource credentialSource;

        public CredentialSourceProtectionParameter(CredentialSource credentialSource) {
            Assert.checkNotNullParam((String)"credentialSource", (Object)credentialSource);
            this.credentialSource = credentialSource;
        }

        public CredentialSource getCredentialSource() {
            return this.credentialSource;
        }
    }

    public static interface ProtectionParameter {
    }
}

