/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.oidc;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.wildfly.common.array.Arrays2;
import org.wildfly.common.iteration.ByteIterator;
import org.wildfly.security.http.oidc.AccessAndIDTokenResponse;
import org.wildfly.security.http.oidc.AuthenticationError;
import org.wildfly.security.http.oidc.BearerTokenRequestAuthenticator;
import org.wildfly.security.http.oidc.ElytronMessages;
import org.wildfly.security.http.oidc.Oidc;
import org.wildfly.security.http.oidc.OidcClientConfiguration;
import org.wildfly.security.http.oidc.OidcHttpFacade;
import org.wildfly.security.http.oidc.ServerRequest;

class BasicAuthRequestAuthenticator
extends BearerTokenRequestAuthenticator {
    private static final String CHALLENGE_PREFIX = "Basic ";

    public BasicAuthRequestAuthenticator(OidcHttpFacade facade, OidcClientConfiguration oidcClientConfiguration) {
        super(facade, oidcClientConfiguration);
    }

    @Override
    public Oidc.AuthOutcome authenticate() {
        AccessAndIDTokenResponse tokenResponse;
        List<String> authorizationValues = this.facade.getRequest().getHeaders("Authorization");
        if (authorizationValues == null || authorizationValues.isEmpty()) {
            this.challenge = this.challengeResponse(AuthenticationError.Reason.NO_AUTHORIZATION_HEADER, null, null);
            return Oidc.AuthOutcome.NOT_ATTEMPTED;
        }
        String basicValue = null;
        for (String authorizationValue : authorizationValues) {
            if (!authorizationValue.regionMatches(true, 0, CHALLENGE_PREFIX, 0, CHALLENGE_PREFIX.length())) continue;
            basicValue = authorizationValue.substring(CHALLENGE_PREFIX.length());
            break;
        }
        if (basicValue == null) {
            this.challenge = this.challengeResponse(AuthenticationError.Reason.INVALID_TOKEN, null, null);
            return Oidc.AuthOutcome.NOT_ATTEMPTED;
        }
        byte[] decodedValue = ByteIterator.ofBytes((byte[])basicValue.getBytes(StandardCharsets.UTF_8)).asUtf8String().base64Decode().drain();
        int colonPos = Arrays2.indexOf((byte[])decodedValue, (int)58);
        if (colonPos <= 0) {
            ElytronMessages.log.debug("Failed to obtain token");
            this.challenge = this.challengeResponse(AuthenticationError.Reason.INVALID_TOKEN, "no_token", null);
            return Oidc.AuthOutcome.FAILED;
        }
        ByteBuffer usernameBytes = ByteBuffer.wrap(decodedValue, 0, colonPos);
        ByteBuffer passwordBytes = ByteBuffer.wrap(decodedValue, colonPos + 1, decodedValue.length - colonPos - 1);
        CharBuffer usernameChars = StandardCharsets.UTF_8.decode(usernameBytes);
        CharBuffer passwordChars = StandardCharsets.UTF_8.decode(passwordBytes);
        try {
            String username = usernameChars.toString();
            String password = passwordChars.toString();
            tokenResponse = ServerRequest.getBearerToken(this.oidcClientConfiguration, username, password);
        }
        catch (Exception e) {
            ElytronMessages.log.debug("Failed to obtain token");
            this.challenge = this.challengeResponse(AuthenticationError.Reason.INVALID_TOKEN, "no_token", e.getMessage());
            return Oidc.AuthOutcome.FAILED;
        }
        this.tokenString = tokenResponse.getAccessToken();
        return this.verifyToken(this.tokenString);
    }
}

