/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm;

import java.io.IOException;
import java.nio.file.Path;
import java.security.KeyStoreException;
import java.security.Principal;
import java.util.NoSuchElementException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;
import org.jboss.logging.annotations.ValidIdRange;
import org.jboss.logging.annotations.ValidIdRanges;
import org.wildfly.security.auth.realm.CacheableSecurityRealm;
import org.wildfly.security.auth.realm.IntegrityException;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;

@MessageLogger(projectCode="ELY", length=5)
@ValidIdRanges(value={@ValidIdRange(min=1006, max=1082), @ValidIdRange(min=1138, max=1154), @ValidIdRange(min=11005, max=11005), @ValidIdRange(min=13000, max=13999)})
interface ElytronMessages
extends BasicLogger {
    public static final ElytronMessages log = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security");

    @Message(id=1006, value="No realm name found in users property file - non-plain-text users file must contain \"#$REALM_NAME=RealmName$\" line")
    public RealmUnavailableException noRealmFoundInProperties();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=1007, value="JAAS authentication failed for principal %s")
    public void debugInfoJaasAuthenticationFailure(Principal var1, @Cause Throwable var2);

    @Message(id=1008, value="Failed to create login context")
    public RealmUnavailableException failedToCreateLoginContext(@Cause Throwable var1);

    @Message(id=1009, value="Failed to instantiate custom CallbackHandler")
    public RealmUnavailableException failedToInstantiateCustomHandler(@Cause Throwable var1);

    @Message(id=1012, value="Filesystem-backed realm unexpectedly failed to open path \"%s\" for identity name \"%s\"")
    public RealmUnavailableException fileSystemRealmFailedToOpen(Path var1, String var2, @Cause IOException var3);

    @Message(id=1013, value="Filesystem-backed realm unexpectedly failed to read path \"%s\" for identity name \"%s\"")
    public RealmUnavailableException fileSystemRealmFailedToRead(Path var1, String var2, @Cause Exception var3);

    @Message(id=1015, value="Filesystem-backed realm encountered invalid file content in path \"%s\" line %d for identity name \"%s\"")
    public RealmUnavailableException fileSystemRealmInvalidContent(Path var1, int var2, String var3);

    @Message(id=1016, value="Filesystem-backed realm encountered missing required attribute \"%s\" in path \"%s\" line %d for identity name \"%s\"")
    public RealmUnavailableException fileSystemRealmMissingAttribute(String var1, Path var2, int var3, String var4);

    @Message(id=1017, value="Filesystem-backed realm encountered invalid password format \"%s\" in path \"%s\" line %d for identity name \"%s\"")
    public RealmUnavailableException fileSystemRealmInvalidPasswordFormat(String var1, Path var2, int var3, String var4);

    @Message(id=1018, value="Filesystem-backed realm encountered invalid password algorithm \"%s\" in path \"%s\" line %d for identity name \"%s\"")
    public RealmUnavailableException fileSystemRealmInvalidPasswordAlgorithm(String var1, Path var2, int var3, String var4);

    @Message(id=1020, value="Filesystem-backed realm failed to update identity \"%s\"")
    public RealmUnavailableException fileSystemUpdatedFailed(String var1, @Cause Throwable var2);

    @Message(id=1021, value="Filesystem-backed realm failed to delete identity \"%s\"")
    public RealmUnavailableException fileSystemRealmDeleteFailed(String var1, @Cause IOException var2);

    @Message(id=1022, value="Filesystem-backed realm failed to find identity \"%s\"")
    public RealmUnavailableException fileSystemRealmNotFound(String var1);

    @Message(id=1023, value="Filesystem-backed realm failed to write to file \"%s\" for identity \"%s\"")
    public RealmUnavailableException fileSystemRealmFailedToWrite(Path var1, String var2, @Cause Exception var3);

    @Message(id=1024, value="Filesystem-backed realm cannot create duplicate identity for identity \"%s\"")
    public RealmUnavailableException fileSystemRealmAlreadyExists(String var1, @Cause Throwable var2);

    @Message(id=1025, value="Filesystem-backed realm encountered invalid certificate format \"%s\" in path \"%s\" line %d for identity name \"%s\"")
    public RealmUnavailableException fileSystemRealmCertificateReadError(String var1, Path var2, int var3, String var4);

    @Message(id=1026, value="Filesystem-backed realm encountered invalid key format \"%s\" in path \"%s\" line %d for identity name \"%s\"")
    public RealmUnavailableException fileSystemRealmUnsupportedKeyFormat(String var1, Path var2, int var3, String var4);

    @Message(id=1027, value="Filesystem-backed realm encountered invalid key algorithm for format \"%s\" in path \"%s\" line %d for identity name \"%s\"")
    public RealmUnavailableException fileSystemRealmUnsupportedKeyAlgorithm(String var1, Path var2, int var3, String var4, @Cause Exception var5);

    @Message(id=1064, value="Invalid identity name")
    public IllegalArgumentException invalidName();

    @Message(id=1081, value="Filesystem-backed realm encountered invalid OTP definition in path \"%s\" line %d for identity name \"%s\"")
    public RealmUnavailableException fileSystemRealmInvalidOtpDefinition(Path var1, int var2, String var3, @Cause Throwable var4);

    @Message(id=1082, value="Filesystem-backed realm encountered invalid OTP algorithm \"%s\" in path \"%s\" line %d for identity name \"%s\"")
    public RealmUnavailableException fileSystemRealmInvalidOtpAlgorithm(String var1, Path var2, int var3, String var4, @Cause Throwable var5);

    @Message(id=1138, value="Decoding hashed password from users property file failed - should not be set as plain-text property file?")
    public RealmUnavailableException decodingHashedPasswordFromPropertiesRealmFailed(@Cause Exception var1);

    @Message(id=1145, value="Security realm [%s] must implement [%s]")
    public IllegalArgumentException realmCacheUnexpectedType(SecurityRealm var1, Class<? extends CacheableSecurityRealm> var2);

    @Message(id=13000, value="Authorization principal cannot be null after transformation")
    public IllegalStateException transformedPrincipalCannotBeNull();

    @Message(id=1154, value="Failed to read key store")
    public RealmUnavailableException failedToReadKeyStore(@Cause KeyStoreException var1);

    @Message(id=11005, value="Invalid unicode endoding, offending sequence: %s.")
    public IOException invalidUnicodeSequence(String var1, @Cause NoSuchElementException var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=13001, value="Realm is failing over.")
    public void realmFailover(@Cause RealmUnavailableException var1);

    @Message(id=13002, value="%s does not handle a callback of type %s")
    public UnsupportedCallbackException unableToHandleCallback(@Param Callback var1, String var2, String var3);

    @Message(id=13003, value="Failed to load JAAS configuration file.")
    public RealmUnavailableException failedToLoadJaasConfigFile();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=13004, value="JAAS logout failed for principal %s")
    public void debugInfoJaasLogoutFailure(Principal var1, @Cause Throwable var2);

    @Message(id=13005, value="Filesystem-backed realm unable to decrypt identity")
    public RealmUnavailableException fileSystemRealmDecryptionFailed(@Cause Throwable var1);

    @Message(id=13006, value="Filesystem-backed realm unable to encrypt identity")
    public RealmUnavailableException fileSystemRealmEncryptionFailed(@Cause Throwable var1);

    @Message(id=13007, value="Signature for the following identity is invalid: %s.")
    public IntegrityException invalidIdentitySignature(String var1);

    @Message(id=13008, value="Unable to create a signature for the file: %s.")
    public RealmUnavailableException unableToGenerateSignature(String var1);

    @Message(id=13009, value="Unable to locate the signature element for the file: %s")
    public RealmUnavailableException cannotFindSignature(String var1);

    @Message(id=13010, value="Both PrivateKey and PublicKey must be defined for realm at: %s")
    public IllegalArgumentException invalidKeyPairArgument(String var1);

    @Message(id=13011, value="Integrity has not been enabled for the realm at: %s")
    public IllegalArgumentException integrityNotEnabled(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=13012, value="A realm within the distributed realm is unavailable. This realm will be ignored.")
    public void realmIsNotAvailable(@Cause Exception var1);
}

