/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.entity;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Random;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.x500.X500Principal;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import mockit.Mock;
import mockit.MockUp;
import mockit.integration.junit4.JMockit;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.common.iteration.CodePointIterator;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.ClientUtils;
import org.wildfly.security.auth.client.MatchRule;
import org.wildfly.security.auth.realm.KeyStoreBackedSecurityRealm;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.X509CertificateChainPrivateCredential;
import org.wildfly.security.sasl.SaslMechanismSelector;
import org.wildfly.security.sasl.entity.EntitySaslClient;
import org.wildfly.security.sasl.entity.EntitySaslClientFactory;
import org.wildfly.security.sasl.entity.EntitySaslServer;
import org.wildfly.security.sasl.entity.EntitySaslServerFactory;
import org.wildfly.security.sasl.entity.EntityUtil;
import org.wildfly.security.sasl.entity.WildFlyElytronSaslEntityProvider;
import org.wildfly.security.sasl.test.SaslServerBuilder;
import org.wildfly.security.sasl.test.SaslTestUtil;
import org.wildfly.security.x500.cert.BasicConstraintsExtension;
import org.wildfly.security.x500.cert.SelfSignedX509CertificateAndSigningKey;
import org.wildfly.security.x500.cert.X509CertificateBuilder;
import org.wildfly.security.x500.cert.X509CertificateExtension;

@RunWith(value=JMockit.class)
public class EntityTest {
    private static final String CLIENT_KEYSTORE_ALIAS = "testclient1";
    private static final String KEYSTORE_TYPE = "JKS";
    private static final char[] KEYSTORE_PASSWORD = "password".toCharArray();
    private static final Provider provider = WildFlyElytronSaslEntityProvider.getInstance();
    private KeyStore serverKeyStore = null;
    private KeyStore clientKeyStore = null;
    private KeyStore serverTrustStore = null;
    private KeyStore clientTrustStore = null;

    @BeforeClass
    public static void registerProvider() {
        Security.insertProviderAt(provider, 1);
    }

    @AfterClass
    public static void removeProvider() {
        Security.removeProvider(provider.getName());
    }

    private void createClientKeyStoreServerTrustStore(KeyStore clientKeyStore, KeyStore serverTrustStore) throws Exception {
        X500Principal DN = new X500Principal("CN=testclient2.example.com, OU=JBoss, O=Red Hat, L=Raleigh, ST=North Carolina, C=US");
        SelfSignedX509CertificateAndSigningKey selfSignedX509CertificateAndSigningKey = SelfSignedX509CertificateAndSigningKey.builder().setKeyAlgorithmName("DSA").setSignatureAlgorithmName("SHA1withDSA").setDn(DN).setKeySize(1024).build();
        X509Certificate certificate = selfSignedX509CertificateAndSigningKey.getSelfSignedCertificate();
        clientKeyStore.setKeyEntry("dnsincnclient", selfSignedX509CertificateAndSigningKey.getSigningKey(), KEYSTORE_PASSWORD, new X509Certificate[]{certificate});
        serverTrustStore.setCertificateEntry("cn=testclient2.example.com,ou=jboss,o=red hat,l=raleigh,st=north carolina,c=us", certificate);
        X500Principal CA_DN = new X500Principal("CN=Test Authority, OU=JBoss, O=Red Hat, L=Raleigh, ST=North Carolina, C=US");
        selfSignedX509CertificateAndSigningKey = SelfSignedX509CertificateAndSigningKey.builder().setDn(CA_DN).setKeyAlgorithmName("RSA").setSignatureAlgorithmName("SHA256withRSA").addExtension((X509CertificateExtension)new BasicConstraintsExtension(false, true, -1)).build();
        X509Certificate caCertificate = selfSignedX509CertificateAndSigningKey.getSelfSignedCertificate();
        PrivateKey caKey = selfSignedX509CertificateAndSigningKey.getSigningKey();
        DN = new X500Principal("CN=Test Client 1, OU=JBoss, O=Red Hat, L=Raleigh, ST=North Carolina, C=US");
        selfSignedX509CertificateAndSigningKey = SelfSignedX509CertificateAndSigningKey.builder().setDn(DN).setKeyAlgorithmName("RSA").setSignatureAlgorithmName("SHA256withRSA").addExtension(false, "SubjectAlternativeName", "DNS:testclient1.example.com").build();
        certificate = selfSignedX509CertificateAndSigningKey.getSelfSignedCertificate();
        clientKeyStore.setKeyEntry(CLIENT_KEYSTORE_ALIAS, selfSignedX509CertificateAndSigningKey.getSigningKey(), KEYSTORE_PASSWORD, new X509Certificate[]{certificate});
        serverTrustStore.setCertificateEntry("cn=test client 1,ou=jboss,o=red hat,l=raleigh,st=north carolina,c=us", certificate);
        X500Principal subjectDN = new X500Principal("CN=Signed Test Client, OU=JBoss, O=Red Hat, ST=North Carolina, C=US");
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        KeyPair generatedKeys = keyPairGenerator.generateKeyPair();
        PrivateKey privateKey = generatedKeys.getPrivate();
        PublicKey publicKey = generatedKeys.getPublic();
        serverTrustStore.setCertificateEntry("cn=signed test client,ou=jboss,o=red hat,st=north carolina,c=us", caCertificate);
        certificate = new X509CertificateBuilder().setIssuerDn(CA_DN).setSubjectDn(subjectDN).setSignatureAlgorithmName("SHA256withRSA").setSigningKey(caKey).setPublicKey(publicKey).build();
        clientKeyStore.setKeyEntry("testclientsignedbyca", privateKey, KEYSTORE_PASSWORD, new X509Certificate[]{certificate});
    }

    private void createServerKeyStoreClientTrustStore(KeyStore serverKeyStore, KeyStore clientTrustStore) throws Exception {
        X500Principal DN = new X500Principal("CN=testserver2.example.com, OU=JBoss, O=Red Hat, L=Raleigh, ST=North Carolina, C=US");
        SelfSignedX509CertificateAndSigningKey selfSignedX509CertificateAndSigningKey = SelfSignedX509CertificateAndSigningKey.builder().setKeyAlgorithmName("DSA").setSignatureAlgorithmName("SHA1withDSA").setDn(DN).setKeySize(1024).build();
        X509Certificate certificate = selfSignedX509CertificateAndSigningKey.getSelfSignedCertificate();
        serverKeyStore.setKeyEntry("dnsincnserver", selfSignedX509CertificateAndSigningKey.getSigningKey(), KEYSTORE_PASSWORD, new X509Certificate[]{certificate});
        clientTrustStore.setCertificateEntry("dnsincnserver", certificate);
        DN = new X500Principal("CN=Test Server 1, OU=JBoss, O=Red Hat, L=Raleigh, ST=North Carolina, C=US");
        selfSignedX509CertificateAndSigningKey = SelfSignedX509CertificateAndSigningKey.builder().setDn(DN).setKeyAlgorithmName("RSA").setSignatureAlgorithmName("SHA256withRSA").addExtension(false, "SubjectAlternativeName", "DNS:testserver1.example.com").build();
        certificate = selfSignedX509CertificateAndSigningKey.getSelfSignedCertificate();
        serverKeyStore.setKeyEntry("testserver1", selfSignedX509CertificateAndSigningKey.getSigningKey(), KEYSTORE_PASSWORD, new X509Certificate[]{certificate});
        clientTrustStore.setCertificateEntry("testserver1", certificate);
    }

    @Before
    public void beforeTest() throws Exception {
        this.clientKeyStore = KeyStore.getInstance(KEYSTORE_TYPE);
        this.clientKeyStore.load(null, null);
        this.serverTrustStore = KeyStore.getInstance(KEYSTORE_TYPE);
        this.serverTrustStore.load(null, null);
        this.serverKeyStore = KeyStore.getInstance(KEYSTORE_TYPE);
        this.serverKeyStore.load(null, null);
        this.clientTrustStore = KeyStore.getInstance(KEYSTORE_TYPE);
        this.clientTrustStore.load(null, null);
        this.createClientKeyStoreServerTrustStore(this.clientKeyStore, this.serverTrustStore);
        this.createServerKeyStoreClientTrustStore(this.serverKeyStore, this.clientTrustStore);
    }

    @After
    public void afterTest() {
        this.serverKeyStore = null;
        this.clientKeyStore = null;
        this.serverTrustStore = null;
        this.clientTrustStore = null;
    }

    @Test
    public void testServerAuthIndirect_Server() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        SaslServer server = Sasl.createSaslServer("9798-U-RSA-SHA1-ENC", "TestProtocol", "TestServer", props, null);
        Assert.assertEquals(EntitySaslServer.class, server.getClass());
        Assert.assertEquals((Object)"9798-U-RSA-SHA1-ENC", (Object)server.getMechanismName());
        props.put("javax.security.sasl.server.authentication", Boolean.toString(true));
        server = Sasl.createSaslServer("9798-U-RSA-SHA1-ENC", "TestProtocol", "TestServer", props, null);
        Assert.assertNull((Object)server);
    }

    @Test
    public void testServerAuthDirect_Server() {
        SaslServerFactory factory = SaslTestUtil.obtainSaslServerFactory(EntitySaslServerFactory.class);
        Assert.assertNotNull((String)"SaslServerFactory not registered", (Object)factory);
        HashMap<String, String> props = new HashMap<String, String>();
        String[] mechanisms = factory.getMechanismNames(props);
        SaslTestUtil.assertMechanisms((String[])new String[]{"9798-U-RSA-SHA1-ENC", "9798-M-RSA-SHA1-ENC", "9798-U-DSA-SHA1", "9798-M-DSA-SHA1", "9798-U-ECDSA-SHA1", "9798-M-ECDSA-SHA1"}, (String[])mechanisms);
        props.put("javax.security.sasl.server.authentication", Boolean.toString(true));
        mechanisms = factory.getMechanismNames(props);
        SaslTestUtil.assertMechanisms((String[])new String[]{"9798-M-RSA-SHA1-ENC", "9798-M-DSA-SHA1", "9798-M-ECDSA-SHA1"}, (String[])mechanisms);
    }

    @Test
    public void testServerAuthIndirect_Client() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        SaslClient client = Sasl.createSaslClient(new String[]{"9798-U-RSA-SHA1-ENC"}, "TestUser", "TestProtocol", "TestServer", props, null);
        Assert.assertEquals(EntitySaslClient.class, client.getClass());
        Assert.assertEquals((Object)"9798-U-RSA-SHA1-ENC", (Object)client.getMechanismName());
        props.put("javax.security.sasl.server.authentication", Boolean.toString(true));
        client = Sasl.createSaslClient(new String[]{"9798-U-RSA-SHA1-ENC", "9798-U-DSA-SHA1", "9798-U-ECDSA-SHA1"}, "TestUser", "TestProtocol", "TestServer", props, null);
        Assert.assertNull((Object)client);
        props.put("javax.security.sasl.server.authentication", Boolean.toString(true));
        client = Sasl.createSaslClient(new String[]{"9798-U-RSA-SHA1-ENC", "9798-U-DSA-SHA1", "9798-U-ECDSA-SHA1", "9798-M-RSA-SHA1-ENC", "9798-M-DSA-SHA1", "9798-M-ECDSA-SHA1"}, "TestUser", "TestProtocol", "TestServer", props, null);
        Assert.assertEquals(EntitySaslClient.class, client.getClass());
        Assert.assertEquals((Object)"9798-M-RSA-SHA1-ENC", (Object)client.getMechanismName());
    }

    @Test
    public void testServerAuthDirect_Client() {
        SaslClientFactory factory = SaslTestUtil.obtainSaslClientFactory(EntitySaslClientFactory.class);
        Assert.assertNotNull((String)"SaslClientFactory not registered", (Object)factory);
        HashMap<String, String> props = new HashMap<String, String>();
        String[] mechanisms = factory.getMechanismNames(props);
        SaslTestUtil.assertMechanisms((String[])new String[]{"9798-U-RSA-SHA1-ENC", "9798-M-RSA-SHA1-ENC", "9798-U-DSA-SHA1", "9798-M-DSA-SHA1", "9798-U-ECDSA-SHA1", "9798-M-ECDSA-SHA1"}, (String[])mechanisms);
        props.put("javax.security.sasl.server.authentication", Boolean.toString(true));
        mechanisms = factory.getMechanismNames(props);
        SaslTestUtil.assertMechanisms((String[])new String[]{"9798-M-RSA-SHA1-ENC", "9798-M-DSA-SHA1", "9798-M-ECDSA-SHA1"}, (String[])mechanisms);
    }

    @Test
    public void testSimpleUnilateralSha1WithRsaAuthentication() throws Exception {
        SaslClientFactory clientFactory = SaslTestUtil.obtainSaslClientFactory(EntitySaslClientFactory.class);
        Assert.assertNotNull((Object)clientFactory);
        SaslServer saslServer = this.createSaslServer("9798-U-RSA-SHA1-ENC", "testserver1.example.com", this.getX509KeyManager(this.serverKeyStore, KEYSTORE_PASSWORD), this.serverTrustStore);
        Assert.assertNotNull((Object)saslServer);
        Assert.assertFalse((boolean)saslServer.isComplete());
        String[] mechanisms = new String[]{"9798-U-RSA-SHA1-ENC"};
        CallbackHandler cbh = this.createClientCallbackHandler(mechanisms, this.clientKeyStore, CLIENT_KEYSTORE_ALIAS, KEYSTORE_PASSWORD, null);
        SaslClient saslClient = clientFactory.createSaslClient(mechanisms, null, "test", "testserver1.example.com", Collections.emptyMap(), cbh);
        Assert.assertNotNull((Object)saslClient);
        Assert.assertTrue((boolean)(saslClient instanceof EntitySaslClient));
        Assert.assertFalse((boolean)saslClient.hasInitialResponse());
        Assert.assertFalse((boolean)saslClient.isComplete());
        byte[] message = saslServer.evaluateResponse(new byte[0]);
        Assert.assertFalse((boolean)saslServer.isComplete());
        Assert.assertFalse((boolean)saslClient.isComplete());
        message = saslClient.evaluateChallenge(message);
        Assert.assertFalse((boolean)saslServer.isComplete());
        Assert.assertFalse((boolean)saslClient.isComplete());
        message = saslServer.evaluateResponse(message);
        Assert.assertTrue((boolean)saslServer.isComplete());
        Assert.assertNull((Object)message);
        Assert.assertNull((Object)saslClient.evaluateChallenge(message));
        Assert.assertTrue((boolean)saslClient.isComplete());
        Assert.assertEquals((Object)"cn=test client 1,ou=jboss,o=red hat,l=raleigh,st=north carolina,c=us", (Object)saslServer.getAuthorizationID());
    }

    @Test
    public void testUnilateralSha1WithRsaAuthenticationWithTrustedAuthorities() throws Exception {
        SaslClientFactory clientFactory = SaslTestUtil.obtainSaslClientFactory(EntitySaslClientFactory.class);
        Assert.assertNotNull((Object)clientFactory);
        SaslServer saslServer = this.createSaslServer("9798-U-RSA-SHA1-ENC", "testserver1.example.com", this.getX509KeyManager(this.serverKeyStore, KEYSTORE_PASSWORD), this.serverTrustStore);
        Assert.assertNotNull((Object)saslServer);
        Assert.assertFalse((boolean)saslServer.isComplete());
        String[] mechanisms = new String[]{"9798-U-RSA-SHA1-ENC"};
        CallbackHandler cbh = this.createClientCallbackHandler(mechanisms, this.getX509KeyManager(this.clientKeyStore, KEYSTORE_PASSWORD), null);
        SaslClient saslClient = clientFactory.createSaslClient(mechanisms, null, "test", "testserver1.example.com", Collections.emptyMap(), cbh);
        Assert.assertNotNull((Object)saslClient);
        Assert.assertTrue((boolean)(saslClient instanceof EntitySaslClient));
        Assert.assertFalse((boolean)saslClient.hasInitialResponse());
        Assert.assertFalse((boolean)saslClient.isComplete());
        byte[] message = saslServer.evaluateResponse(new byte[0]);
        Assert.assertFalse((boolean)saslServer.isComplete());
        Assert.assertFalse((boolean)saslClient.isComplete());
        message = saslClient.evaluateChallenge(message);
        Assert.assertFalse((boolean)saslServer.isComplete());
        Assert.assertFalse((boolean)saslClient.isComplete());
        message = saslServer.evaluateResponse(message);
        Assert.assertTrue((boolean)saslServer.isComplete());
        Assert.assertNull((Object)message);
        Assert.assertNull((Object)saslClient.evaluateChallenge(message));
        Assert.assertTrue((boolean)saslClient.isComplete());
        Assert.assertEquals((Object)"cn=signed test client,ou=jboss,o=red hat,st=north carolina,c=us", (Object)saslServer.getAuthorizationID());
    }

    @Test
    public void testUnilateralSha1WithRsaAuthenticationWithAuthorizationId() throws Exception {
        SaslClientFactory clientFactory = SaslTestUtil.obtainSaslClientFactory(EntitySaslClientFactory.class);
        Assert.assertNotNull((Object)clientFactory);
        SaslServer saslServer = this.createSaslServer("9798-U-RSA-SHA1-ENC", "testserver1.example.com", this.getX509KeyManager(this.serverKeyStore, KEYSTORE_PASSWORD), this.serverTrustStore);
        String[] mechanisms = new String[]{"9798-U-RSA-SHA1-ENC"};
        CallbackHandler cbh = this.createClientCallbackHandler(mechanisms, this.clientKeyStore, CLIENT_KEYSTORE_ALIAS, KEYSTORE_PASSWORD, null);
        SaslClient saslClient = clientFactory.createSaslClient(mechanisms, "cn=test client 1,ou=jboss,o=red hat,l=raleigh,st=north carolina,c=us", "test", "testserver1.example.com", Collections.emptyMap(), cbh);
        Assert.assertFalse((boolean)saslServer.isComplete());
        Assert.assertFalse((boolean)saslClient.isComplete());
        byte[] message = saslServer.evaluateResponse(new byte[0]);
        Assert.assertFalse((boolean)saslServer.isComplete());
        Assert.assertFalse((boolean)saslClient.isComplete());
        message = saslClient.evaluateChallenge(message);
        Assert.assertFalse((boolean)saslServer.isComplete());
        Assert.assertFalse((boolean)saslClient.isComplete());
        message = saslServer.evaluateResponse(message);
        Assert.assertTrue((boolean)saslServer.isComplete());
        Assert.assertNull((Object)message);
        Assert.assertNull((Object)saslClient.evaluateChallenge(message));
        Assert.assertTrue((boolean)saslClient.isComplete());
        Assert.assertEquals((Object)"cn=test client 1,ou=jboss,o=red hat,l=raleigh,st=north carolina,c=us", (Object)saslServer.getAuthorizationID());
    }

    @Test
    public void testSimpleMutualSha1WithRsaAuthentication() throws Exception {
        SaslClientFactory clientFactory = SaslTestUtil.obtainSaslClientFactory(EntitySaslClientFactory.class);
        Assert.assertNotNull((Object)clientFactory);
        SaslServer saslServer = this.createSaslServer("9798-M-RSA-SHA1-ENC", "testserver1.example.com", this.getX509KeyManager(this.serverKeyStore, KEYSTORE_PASSWORD), this.serverTrustStore);
        String[] mechanisms = new String[]{"9798-M-RSA-SHA1-ENC"};
        CallbackHandler cbh = this.createClientCallbackHandler(mechanisms, this.clientKeyStore, CLIENT_KEYSTORE_ALIAS, KEYSTORE_PASSWORD, this.getX509TrustManager(this.clientTrustStore));
        SaslClient saslClient = clientFactory.createSaslClient(mechanisms, null, "test", "testserver1.example.com", Collections.emptyMap(), cbh);
        Assert.assertFalse((boolean)saslServer.isComplete());
        Assert.assertFalse((boolean)saslClient.isComplete());
        byte[] message = saslServer.evaluateResponse(new byte[0]);
        Assert.assertFalse((boolean)saslServer.isComplete());
        Assert.assertFalse((boolean)saslClient.isComplete());
        message = saslClient.evaluateChallenge(message);
        Assert.assertFalse((boolean)saslServer.isComplete());
        Assert.assertFalse((boolean)saslClient.isComplete());
        message = saslServer.evaluateResponse(message);
        Assert.assertNotNull((Object)message);
        message = saslClient.evaluateChallenge(message);
        Assert.assertNull((Object)message);
        Assert.assertTrue((boolean)saslClient.isComplete());
        Assert.assertTrue((boolean)saslServer.isComplete());
        Assert.assertEquals((Object)"cn=test client 1,ou=jboss,o=red hat,l=raleigh,st=north carolina,c=us", (Object)saslServer.getAuthorizationID());
    }

    @Test
    public void testMutualAuthenticationWithDNSInCNField() throws Exception {
        SaslClientFactory clientFactory = SaslTestUtil.obtainSaslClientFactory(EntitySaslClientFactory.class);
        Assert.assertNotNull((Object)clientFactory);
        KeyStore keyStore = this.serverKeyStore;
        Certificate[] certificateChain = keyStore.getCertificateChain("dnsInCNServer");
        SaslServer saslServer = this.createSaslServer("9798-M-DSA-SHA1", "testserver2.example.com", this.serverTrustStore, (PrivateKey)keyStore.getKey("dnsInCNServer", KEYSTORE_PASSWORD), (X509Certificate[])Arrays.copyOf(certificateChain, certificateChain.length, X509Certificate[].class));
        String[] mechanisms = new String[]{"9798-M-DSA-SHA1"};
        CallbackHandler cbh = this.createClientCallbackHandler(mechanisms, this.clientKeyStore, "dnsInCNClient", KEYSTORE_PASSWORD, this.getX509TrustManager(this.clientTrustStore));
        SaslClient saslClient = clientFactory.createSaslClient(mechanisms, null, "test", "testserver2.example.com", Collections.emptyMap(), cbh);
        Assert.assertFalse((boolean)saslServer.isComplete());
        Assert.assertFalse((boolean)saslClient.isComplete());
        byte[] message = saslServer.evaluateResponse(new byte[0]);
        Assert.assertFalse((boolean)saslServer.isComplete());
        Assert.assertFalse((boolean)saslClient.isComplete());
        message = saslClient.evaluateChallenge(message);
        Assert.assertFalse((boolean)saslServer.isComplete());
        Assert.assertFalse((boolean)saslClient.isComplete());
        message = saslServer.evaluateResponse(message);
        Assert.assertNotNull((Object)message);
        message = saslClient.evaluateChallenge(message);
        Assert.assertNull((Object)message);
        Assert.assertTrue((boolean)saslClient.isComplete());
        Assert.assertTrue((boolean)saslServer.isComplete());
        Assert.assertEquals((Object)"cn=testclient2.example.com,ou=jboss,o=red hat,l=raleigh,st=north carolina,c=us", (Object)saslServer.getAuthorizationID());
    }

    @Test
    public void testServerNameMismatch() throws Exception {
        SaslClientFactory clientFactory = SaslTestUtil.obtainSaslClientFactory(EntitySaslClientFactory.class);
        Assert.assertNotNull((Object)clientFactory);
        SaslServer saslServer = this.createSaslServer("9798-M-RSA-SHA1-ENC", "testserver1.example.com", this.getX509KeyManager(this.serverKeyStore, KEYSTORE_PASSWORD), this.serverTrustStore);
        String[] mechanisms = new String[]{"9798-M-RSA-SHA1-ENC"};
        CallbackHandler cbh = this.createClientCallbackHandler(mechanisms, this.clientKeyStore, CLIENT_KEYSTORE_ALIAS, KEYSTORE_PASSWORD, this.getX509TrustManager(this.clientTrustStore));
        SaslClient saslClient = clientFactory.createSaslClient(mechanisms, null, "test", "anotherserver.example.com", Collections.emptyMap(), cbh);
        byte[] message = saslServer.evaluateResponse(new byte[0]);
        try {
            saslClient.evaluateChallenge(message);
            Assert.fail((String)"Expected SaslException not thrown");
        }
        catch (SaslException saslException) {
            // empty catch block
        }
    }

    @Test
    public void testClientNotTrustedByServer() throws Exception {
        SaslClientFactory clientFactory = SaslTestUtil.obtainSaslClientFactory(EntitySaslClientFactory.class);
        Assert.assertNotNull((Object)clientFactory);
        SaslServer saslServer = this.createSaslServer("9798-M-RSA-SHA1-ENC", "testserver1.example.com", this.getX509KeyManager(this.serverKeyStore, KEYSTORE_PASSWORD), KeyStore.getInstance(KEYSTORE_TYPE));
        String[] mechanisms = new String[]{"9798-M-RSA-SHA1-ENC"};
        CallbackHandler cbh = this.createClientCallbackHandler(mechanisms, this.clientKeyStore, CLIENT_KEYSTORE_ALIAS, KEYSTORE_PASSWORD, this.getX509TrustManager(this.clientTrustStore));
        SaslClient saslClient = clientFactory.createSaslClient(mechanisms, null, "test", "testserver1.example.com", Collections.emptyMap(), cbh);
        byte[] message = saslServer.evaluateResponse(new byte[0]);
        message = saslClient.evaluateChallenge(message);
        try {
            saslServer.evaluateResponse(message);
            Assert.fail((String)"Expected SaslException not thrown");
        }
        catch (SaslException saslException) {
            // empty catch block
        }
    }

    @Test
    public void testServerNotTrustedByClient() throws Exception {
        SaslClientFactory clientFactory = SaslTestUtil.obtainSaslClientFactory(EntitySaslClientFactory.class);
        Assert.assertNotNull((Object)clientFactory);
        SaslServer saslServer = this.createSaslServer("9798-M-RSA-SHA1-ENC", "testserver1.example.com", this.getX509KeyManager(this.serverKeyStore, KEYSTORE_PASSWORD), this.serverTrustStore);
        String[] mechanisms = new String[]{"9798-M-RSA-SHA1-ENC"};
        CallbackHandler cbh = this.createClientCallbackHandler(mechanisms, this.clientKeyStore, CLIENT_KEYSTORE_ALIAS, KEYSTORE_PASSWORD, null);
        SaslClient saslClient = clientFactory.createSaslClient(mechanisms, null, "test", "testserver1.example.com", Collections.emptyMap(), cbh);
        byte[] message = saslServer.evaluateResponse(new byte[0]);
        message = saslClient.evaluateChallenge(message);
        message = saslServer.evaluateResponse(message);
        try {
            saslClient.evaluateChallenge(message);
            Assert.fail((String)"Expected SaslException not thrown");
        }
        catch (SaslException saslException) {
            // empty catch block
        }
    }

    @Test
    public void testRfc3163Example() throws Exception {
        this.mockRandom(new byte[]{18, 56, -105, 88, 121, -121, 71, -104});
        KeyStore emptyTrustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        emptyTrustStore.load(null, null);
        SaslServer saslServer = this.createSaslServer("9798-U-RSA-SHA1-ENC", "", this.getX509KeyManager(this.serverKeyStore, KEYSTORE_PASSWORD), emptyTrustStore);
        Assert.assertNotNull((Object)saslServer);
        Assert.assertFalse((boolean)saslServer.isComplete());
        byte[] tokenBA1 = saslServer.evaluateResponse(new byte[0]);
        byte[] expectedTokenBA1 = CodePointIterator.ofString((String)"MAoECBI4l1h5h0eY").base64Decode().drain();
        Assert.assertArrayEquals((byte[])expectedTokenBA1, (byte[])tokenBA1);
        Assert.assertFalse((boolean)saslServer.isComplete());
        byte[] tokenAB = CodePointIterator.ofString((String)"MIIBAgQIIxh5I0h5RYegD4INc2FzbC1yLXVzLmNvbaFPFk1odHRwOi8vY2VydHMtci11cy5jb20vY2VydD9paD1odmNOQVFFRkJRQURnWUVBZ2hBR2hZVFJna0ZqJnNuPUVQOXVFbFkzS0RlZ2pscjCBkzANBgkqhkiG9w0BAQUFAAOBgQCkuC2GgtYcxGG1NEzLA4bh5lqJGOZySACMmc+mDrV7A7KAgbpO2OuZpMCl7zvNt/L3OjQZatiX8d1XbuQ40l+g2TJzJt06o7ogomxdDwqlA/3zp2WMohlI0MotHmfDSWEDZmEYDEA3/eGgkWyi1v1lEVdFuYmrTr8E4wE9hxdQrA==").base64Decode().drain();
        try {
            saslServer.evaluateResponse(tokenAB);
            Assert.fail((String)"Expected SaslException not thrown");
        }
        catch (SaslException expected) {
            Assert.assertTrue((boolean)expected.getCause().getMessage().contains("Unexpected ASN.1 tag encountered"));
        }
        Assert.assertFalse((boolean)saslServer.isComplete());
    }

    private void safeClose(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void mockRandom(final byte[] randomStr) {
        new MockUp<EntityUtil>(){

            @Mock
            byte[] generateRandomString(int length, Random random) {
                return randomStr;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore loadKeyStore(File keyStore) throws IOException, GeneralSecurityException {
        if (keyStore == null) {
            return null;
        }
        KeyStore ks = KeyStore.getInstance(KEYSTORE_TYPE);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(keyStore);
            ks.load(fis, KEYSTORE_PASSWORD);
        }
        finally {
            this.safeClose(fis);
        }
        return ks;
    }

    private SaslServer createSaslServer(String mechanism, String serverName, X509KeyManager keyManager, File trustStore) throws Exception {
        return this.createSaslServer(mechanism, serverName, keyManager, this.loadKeyStore(trustStore));
    }

    private SaslServer createSaslServer(String mechanism, String serverName, X509KeyManager keyManager, KeyStore trustStore) throws Exception {
        String realmName = "keyStoreRealm";
        return new SaslServerBuilder(EntitySaslServerFactory.class, mechanism).setProtocol("test").setServerName(serverName).addRealm("keyStoreRealm", (SecurityRealm)new KeyStoreBackedSecurityRealm(trustStore)).setDefaultRealmName("keyStoreRealm").setKeyManager(keyManager).setTrustManager(this.getX509TrustManager(trustStore)).build();
    }

    private SaslServer createSaslServer(String mechanism, String serverName, KeyStore trustStore, PrivateKey privateKey, X509Certificate ... certificateChain) throws Exception {
        String realmName = "keyStoreRealm";
        KeyStore ts = trustStore;
        return new SaslServerBuilder(EntitySaslServerFactory.class, mechanism).setProtocol("test").setServerName(serverName).addRealm("keyStoreRealm", (SecurityRealm)new KeyStoreBackedSecurityRealm(ts)).setDefaultRealmName("keyStoreRealm").setCredential((Credential)new X509CertificateChainPrivateCredential(privateKey, certificateChain)).setTrustManager(this.getX509TrustManager(ts)).build();
    }

    private CallbackHandler createClientCallbackHandler(String[] mechanisms, KeyStore keyStore, String keyStoreAlias, char[] keyStorePassword, X509TrustManager trustManager) throws Exception {
        AuthenticationContext context = AuthenticationContext.empty().with(MatchRule.ALL, AuthenticationConfiguration.empty().useKeyStoreCredential(keyStore, keyStoreAlias, (KeyStore.ProtectionParameter)new KeyStore.PasswordProtection(keyStorePassword)).useTrustManager(trustManager).setSaslMechanismSelector(SaslMechanismSelector.NONE.addMechanisms(mechanisms)));
        return ClientUtils.getCallbackHandler(new URI("remote://localhost"), context);
    }

    private CallbackHandler createClientCallbackHandler(String[] mechanisms, X509KeyManager keyManager, X509TrustManager trustManager) throws Exception {
        AuthenticationContext context = AuthenticationContext.empty().with(MatchRule.ALL, AuthenticationConfiguration.empty().useKeyManagerCredential(keyManager).useTrustManager(trustManager).setSaslMechanismSelector(SaslMechanismSelector.NONE.addMechanisms(mechanisms)));
        return ClientUtils.getCallbackHandler(new URI("remote://localhost"), context);
    }

    private CallbackHandler createClientCallbackHandler(String[] mechanisms, PrivateKey privateKey, X509Certificate[] certificateChain, X509TrustManager trustManager) throws Exception {
        AuthenticationContext context = AuthenticationContext.empty().with(MatchRule.ALL, AuthenticationConfiguration.empty().useCertificateCredential(privateKey, certificateChain).useTrustManager(trustManager).setSaslMechanismSelector(SaslMechanismSelector.NONE.addMechanisms(mechanisms)));
        return ClientUtils.getCallbackHandler(new URI("remote://localhost"), context);
    }

    private X509KeyManager getX509KeyManager(KeyStore keyStore, char[] keyStorePassword) throws GeneralSecurityException, IOException {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, keyStorePassword);
        for (KeyManager keyManager : keyManagerFactory.getKeyManagers()) {
            if (!(keyManager instanceof X509KeyManager)) continue;
            return (X509KeyManager)keyManager;
        }
        return null;
    }

    private X509TrustManager getX509TrustManager(File trustStore) throws GeneralSecurityException, IOException {
        return this.getX509TrustManager(this.loadKeyStore(trustStore));
    }

    private X509TrustManager getX509TrustManager(KeyStore trustStore) throws GeneralSecurityException, IOException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(trustStore);
        for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            return (X509TrustManager)trustManager;
        }
        return null;
    }
}

