/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.gssapi;

import org.jboss.logging.Logger;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;
import org.wildfly.security.sasl.gs2.Gs2SuiteChild;
import org.wildfly.security.sasl.gssapi.CommunicationSuiteChild;
import org.wildfly.security.sasl.gssapi.GSSSecurityFactorySuiteChild;
import org.wildfly.security.sasl.gssapi.TestKDC;

@RunWith(value=Suite.class)
@Suite.SuiteClasses(value={GSSSecurityFactorySuiteChild.class, CommunicationSuiteChild.class, Gs2SuiteChild.class})
public class GssapiTestSuite {
    private static Logger log = Logger.getLogger(GssapiTestSuite.class);
    public static TestKDC testKdc;
    public static String serverKeyTab;
    public static String serverUnboundKeyTab;

    @BeforeClass
    public static void startServers() {
        log.debug((Object)"Starting KDC...");
        testKdc = new TestKDC(true);
        testKdc.startDirectoryService();
        testKdc.startKDC();
        serverKeyTab = testKdc.generateKeyTab("serverKeyTab", "sasl/test_server_1@WILDFLY.ORG", "servicepwd");
        log.debug((Object)("serverKeyTab written to:" + serverKeyTab));
        serverUnboundKeyTab = testKdc.generateKeyTab("serverUnboundKeyTab", "sasl/test_server_1@WILDFLY.ORG", "servicepwd", "*@WILDFLY.ORG", "dummy");
        log.debug((Object)("serverUnboundKeyTab written to:" + serverUnboundKeyTab));
    }

    @AfterClass
    public static void stopServers() {
        if (testKdc != null) {
            testKdc.stopAll();
            testKdc = null;
        }
    }
}

