/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.scram;

import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.Security;
import java.util.Collections;
import java.util.HashMap;
import java.util.Random;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import mockit.Mock;
import mockit.MockUp;
import mockit.integration.junit4.JMockit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.security.mechanism.scram.ScramClient;
import org.wildfly.security.sasl.scram.ScramCallbackHandlerUtils;
import org.wildfly.security.sasl.scram.ScramSaslClient;
import org.wildfly.security.sasl.scram.ScramSaslClientFactory;
import org.wildfly.security.sasl.scram.WildFlyElytronSaslScramProvider;
import org.wildfly.security.sasl.test.SaslTestUtil;
import org.wildfly.security.sasl.util.AbstractSaslParticipant;
import org.wildfly.security.sasl.util.ChannelBindingSaslClientFactory;

@RunWith(value=JMockit.class)
public class ScramClientCompatibilityTest {
    private static final Provider provider = WildFlyElytronSaslScramProvider.getInstance();

    @BeforeClass
    public static void registerPasswordProvider() {
        Security.insertProviderAt(provider, 1);
    }

    @AfterClass
    public static void removePasswordProvider() {
        Security.removeProvider(provider.getName());
    }

    private void mockNonce(final String nonce) {
        Class<?> classToMock;
        try {
            classToMock = Class.forName("org.wildfly.security.mechanism.scram.ScramUtil", true, ScramClient.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        new MockUp<Object>(classToMock){

            @Mock
            public byte[] generateNonce(int length, Random random) {
                return nonce.getBytes(StandardCharsets.UTF_8);
            }
        };
    }

    @Test
    public void testRfc5802example() throws Exception {
        this.mockNonce("fyko+d2lbbFgONRv9qkxdawL");
        SaslClientFactory clientFactory = SaslTestUtil.obtainSaslClientFactory(ScramSaslClientFactory.class);
        Assert.assertNotNull((Object)clientFactory);
        CallbackHandler cbh = ScramCallbackHandlerUtils.createClientCallbackHandler("user", "pencil".toCharArray());
        SaslClient saslClient = clientFactory.createSaslClient(new String[]{"SCRAM-SHA-1"}, null, "protocol", "localhost", Collections.emptyMap(), cbh);
        Assert.assertNotNull((Object)saslClient);
        Assert.assertTrue((boolean)(saslClient instanceof ScramSaslClient));
        byte[] message = AbstractSaslParticipant.NO_BYTES;
        message = saslClient.evaluateChallenge(message);
        Assert.assertEquals((Object)"n,,n=user,r=fyko+d2lbbFgONRv9qkxdawL", (Object)new String(message, StandardCharsets.UTF_8));
        message = "r=fyko+d2lbbFgONRv9qkxdawL3rfcNHYJY1ZVvWVs7j,s=QSXCR+Q6sek8bf92,i=4096".getBytes(StandardCharsets.UTF_8);
        message = saslClient.evaluateChallenge(message);
        Assert.assertEquals((Object)"c=biws,r=fyko+d2lbbFgONRv9qkxdawL3rfcNHYJY1ZVvWVs7j,p=v0X8v3Bz2T0CJGbJQyF0X+HI4Ts=", (Object)new String(message, StandardCharsets.UTF_8));
        message = "v=rmF9pqV8S7suAoZWja4dJRkFsKQ=".getBytes(StandardCharsets.UTF_8);
        message = saslClient.evaluateChallenge(message);
        Assert.assertTrue((boolean)saslClient.isComplete());
    }

    @Test
    public void testAuthorizationId() throws Exception {
        this.mockNonce("fyko+d2lbbFgONRv9qkxdawL");
        SaslClientFactory clientFactory = SaslTestUtil.obtainSaslClientFactory(ScramSaslClientFactory.class);
        Assert.assertNotNull((Object)clientFactory);
        CallbackHandler cbh = ScramCallbackHandlerUtils.createClientCallbackHandler("admin", "secret".toCharArray());
        SaslClient saslClient = clientFactory.createSaslClient(new String[]{"SCRAM-SHA-1"}, "user", "protocol", "localhost", Collections.emptyMap(), cbh);
        Assert.assertNotNull((Object)saslClient);
        Assert.assertTrue((boolean)(saslClient instanceof ScramSaslClient));
        byte[] message = AbstractSaslParticipant.NO_BYTES;
        message = saslClient.evaluateChallenge(message);
        Assert.assertEquals((Object)"n,a=user,n=admin,r=fyko+d2lbbFgONRv9qkxdawL", (Object)new String(message, StandardCharsets.UTF_8));
        message = "r=fyko+d2lbbFgONRv9qkxdawL3rfcNHYJY1ZVvWVs7j,s=QSXCR+Q6sek8bf92,i=4096".getBytes(StandardCharsets.UTF_8);
        message = saslClient.evaluateChallenge(message);
        Assert.assertEquals((Object)"c=bixhPXVzZXIs,r=fyko+d2lbbFgONRv9qkxdawL3rfcNHYJY1ZVvWVs7j,p=JFcfWujky5ZULVQwDmB5aHMkoME=", (Object)new String(message, StandardCharsets.UTF_8));
        message = "v=EFUP6P+SBB3T4rZgjRz28Z1FqCg=".getBytes(StandardCharsets.UTF_8);
        message = saslClient.evaluateChallenge(message);
        Assert.assertTrue((boolean)saslClient.isComplete());
    }

    @Test
    public void testBadNonce() throws Exception {
        this.mockNonce("fyko+d2lbbFgONRv9qkxdawL");
        SaslClientFactory clientFactory = SaslTestUtil.obtainSaslClientFactory(ScramSaslClientFactory.class);
        Assert.assertNotNull((Object)clientFactory);
        CallbackHandler cbh = ScramCallbackHandlerUtils.createClientCallbackHandler("admin", "secret".toCharArray());
        SaslClient saslClient = clientFactory.createSaslClient(new String[]{"SCRAM-SHA-1"}, "user", "protocol", "localhost", Collections.emptyMap(), cbh);
        Assert.assertNotNull((Object)saslClient);
        Assert.assertTrue((boolean)(saslClient instanceof ScramSaslClient));
        byte[] message = AbstractSaslParticipant.NO_BYTES;
        message = saslClient.evaluateChallenge(message);
        Assert.assertEquals((Object)"n,a=user,n=admin,r=fyko+d2lbbFgONRv9qkxdawL", (Object)new String(message, StandardCharsets.UTF_8));
        message = "r=BADo+d2lbbFgONRv9qkxdawL3rfcNHYJY1ZVvWVs7j,s=QSXCR+Q6sek8bf92,i=4096".getBytes(StandardCharsets.UTF_8);
        try {
            message = saslClient.evaluateChallenge(message);
            Assert.fail((String)"SaslException not throwed");
        }
        catch (SaslException saslException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)saslClient.isComplete());
    }

    @Test
    public void testBadVerifier() throws Exception {
        this.mockNonce("fyko+d2lbbFgONRv9qkxdawL");
        SaslClientFactory clientFactory = SaslTestUtil.obtainSaslClientFactory(ScramSaslClientFactory.class);
        Assert.assertNotNull((Object)clientFactory);
        CallbackHandler cbh = ScramCallbackHandlerUtils.createClientCallbackHandler("admin", "secret".toCharArray());
        SaslClient saslClient = clientFactory.createSaslClient(new String[]{"SCRAM-SHA-1"}, "user", "protocol", "localhost", Collections.emptyMap(), cbh);
        Assert.assertNotNull((Object)saslClient);
        Assert.assertTrue((boolean)(saslClient instanceof ScramSaslClient));
        byte[] message = AbstractSaslParticipant.NO_BYTES;
        message = saslClient.evaluateChallenge(message);
        Assert.assertEquals((Object)"n,a=user,n=admin,r=fyko+d2lbbFgONRv9qkxdawL", (Object)new String(message, StandardCharsets.UTF_8));
        message = "r=fyko+d2lbbFgONRv9qkxdawL3rfcNHYJY1ZVvWVs7j,s=QSXCR+Q6sek8bf92,i=4096".getBytes(StandardCharsets.UTF_8);
        message = saslClient.evaluateChallenge(message);
        Assert.assertEquals((Object)"c=bixhPXVzZXIs,r=fyko+d2lbbFgONRv9qkxdawL3rfcNHYJY1ZVvWVs7j,p=JFcfWujky5ZULVQwDmB5aHMkoME=", (Object)new String(message, StandardCharsets.UTF_8));
        message = "v=badP6P+SBB3T4rZgjRz28Z1FqCg=".getBytes(StandardCharsets.UTF_8);
        try {
            message = saslClient.evaluateChallenge(message);
            Assert.fail((String)"SaslException not throwed");
        }
        catch (SaslException saslException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)saslClient.isComplete());
    }

    @Test
    public void testStrangeCredentials() throws Exception {
        this.mockNonce("fyko+d2lbbFgONRv9qkxdawL");
        SaslClientFactory clientFactory = SaslTestUtil.obtainSaslClientFactory(ScramSaslClientFactory.class);
        Assert.assertNotNull((Object)clientFactory);
        CallbackHandler cbh = ScramCallbackHandlerUtils.createClientCallbackHandler("strange=user, \\\u0438\u4f60\ud83c\udca1\u00bd\u00b4", "strange=password, \\\u0438\u4f60\ud83c\udca1\u00bd\u00b4".toCharArray());
        SaslClient saslClient = clientFactory.createSaslClient(new String[]{"SCRAM-SHA-1"}, "strange=admin, \\\u0438\u4f60\ud83c\udca1\u00bd\u00b4", "protocol", "localhost", Collections.emptyMap(), cbh);
        Assert.assertNotNull((Object)saslClient);
        Assert.assertTrue((boolean)(saslClient instanceof ScramSaslClient));
        byte[] message = AbstractSaslParticipant.NO_BYTES;
        message = saslClient.evaluateChallenge(message);
        Assert.assertEquals((Object)"n,a=strange=3Dadmin=2C \\\u0438\u4f60\ud83c\udca11\u20442 \u0301,n=strange=3Duser=2C \\\u0438\u4f60\ud83c\udca11\u20442 \u0301,r=fyko+d2lbbFgONRv9qkxdawL", (Object)new String(message, StandardCharsets.UTF_8));
        message = "r=fyko+d2lbbFgONRv9qkxdawL3rfcNHYJY1ZVvWVs7j,s=QSXCR+Q6sek8bf92,i=4096".getBytes(StandardCharsets.UTF_8);
        message = saslClient.evaluateChallenge(message);
        Assert.assertEquals((Object)"c=bixhPXN0cmFuZ2U9M0RhZG1pbj0yQyBc0LjkvaDwn4KhMeKBhDIgzIEs,r=fyko+d2lbbFgONRv9qkxdawL3rfcNHYJY1ZVvWVs7j,p=5Drqrw2srEQfQ84h8Okz6eV091w=", (Object)new String(message, StandardCharsets.UTF_8));
        message = "v=7xo0Rb9jQts952duIEz4oaIfD/c=".getBytes(StandardCharsets.UTF_8);
        message = saslClient.evaluateChallenge(message);
        Assert.assertTrue((boolean)saslClient.isComplete());
    }

    @Test
    public void testBindingCorrectY() throws Exception {
        this.mockNonce("fyko+d2lbbFgONRv9qkxdawL");
        CallbackHandler cbh = ScramCallbackHandlerUtils.createClientCallbackHandler("user", "pencil".toCharArray());
        SaslClientFactory clientFactory = SaslTestUtil.obtainSaslClientFactory(ScramSaslClientFactory.class);
        Assert.assertNotNull((Object)clientFactory);
        clientFactory = new ChannelBindingSaslClientFactory(clientFactory, "same-type", new byte[]{18, 44, 0});
        Assert.assertNotNull((Object)clientFactory);
        SaslClient saslClient = clientFactory.createSaslClient(new String[]{"SCRAM-SHA-1"}, null, "protocol", "localhost", Collections.emptyMap(), cbh);
        Assert.assertNotNull((Object)saslClient);
        Assert.assertTrue((boolean)(saslClient instanceof ScramSaslClient));
        byte[] message = AbstractSaslParticipant.NO_BYTES;
        message = saslClient.evaluateChallenge(message);
        Assert.assertEquals((Object)"y,,n=user,r=fyko+d2lbbFgONRv9qkxdawL", (Object)new String(message, StandardCharsets.UTF_8));
        message = "r=fyko+d2lbbFgONRv9qkxdawL3rfcNHYJY1ZVvWVs7j,s=QSXCR+Q6sek8bf92,i=4096".getBytes(StandardCharsets.UTF_8);
        message = saslClient.evaluateChallenge(message);
        Assert.assertEquals((Object)"c=eSws,r=fyko+d2lbbFgONRv9qkxdawL3rfcNHYJY1ZVvWVs7j,p=BjZF5dV+EkD3YCb3pH3IP8riMGw=", (Object)new String(message, StandardCharsets.UTF_8));
        message = "v=dsprQ5R2AGYt1kn4bQRwTAE0PTU=".getBytes(StandardCharsets.UTF_8);
        message = saslClient.evaluateChallenge(message);
        Assert.assertTrue((boolean)saslClient.isComplete());
    }

    @Test
    public void testBindingCorrectP() throws Exception {
        this.mockNonce("fyko+d2lbbFgONRv9qkxdawL");
        CallbackHandler cbh = ScramCallbackHandlerUtils.createClientCallbackHandler("user", "pencil".toCharArray());
        SaslClientFactory clientFactory = SaslTestUtil.obtainSaslClientFactory(ScramSaslClientFactory.class);
        Assert.assertNotNull((Object)clientFactory);
        clientFactory = new ChannelBindingSaslClientFactory(clientFactory, "same-type", new byte[]{18, 44, 0});
        Assert.assertNotNull((Object)clientFactory);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("wildfly.sasl.channel-binding-required", "true");
        SaslClient saslClient = clientFactory.createSaslClient(new String[]{"SCRAM-SHA-1-PLUS"}, null, "protocol", "localhost", props, cbh);
        Assert.assertNotNull((Object)saslClient);
        Assert.assertTrue((boolean)(saslClient instanceof ScramSaslClient));
        byte[] message = AbstractSaslParticipant.NO_BYTES;
        message = saslClient.evaluateChallenge(message);
        Assert.assertEquals((Object)"p=same-type,,n=user,r=fyko+d2lbbFgONRv9qkxdawL", (Object)new String(message, StandardCharsets.UTF_8));
        message = "r=fyko+d2lbbFgONRv9qkxdawL3rfcNHYJY1ZVvWVs7j,s=QSXCR+Q6sek8bf92,i=4096".getBytes(StandardCharsets.UTF_8);
        message = saslClient.evaluateChallenge(message);
        Assert.assertEquals((Object)"c=cD1zYW1lLXR5cGUsLBIsAA==,r=fyko+d2lbbFgONRv9qkxdawL3rfcNHYJY1ZVvWVs7j,p=0xrnDt+5S5sPyZE7IiTMKHbuZGQ=", (Object)new String(message, StandardCharsets.UTF_8));
        message = "v=ooHARfuURZosAZ4dAMTwrFBGBFc=".getBytes(StandardCharsets.UTF_8);
        message = saslClient.evaluateChallenge(message);
        Assert.assertTrue((boolean)saslClient.isComplete());
    }

    @Test
    public void testServerError() throws Exception {
        SaslClient saslClient;
        block2: {
            this.mockNonce("fyko+d2lbbFgONRv9qkxdawL");
            SaslClientFactory clientFactory = SaslTestUtil.obtainSaslClientFactory(ScramSaslClientFactory.class);
            Assert.assertNotNull((Object)clientFactory);
            CallbackHandler cbh = ScramCallbackHandlerUtils.createClientCallbackHandler("admin", "secret".toCharArray());
            saslClient = clientFactory.createSaslClient(new String[]{"SCRAM-SHA-1"}, "user", "protocol", "localhost", Collections.emptyMap(), cbh);
            Assert.assertNotNull((Object)saslClient);
            Assert.assertTrue((boolean)(saslClient instanceof ScramSaslClient));
            byte[] message = AbstractSaslParticipant.NO_BYTES;
            message = saslClient.evaluateChallenge(message);
            Assert.assertEquals((Object)"n,a=user,n=admin,r=fyko+d2lbbFgONRv9qkxdawL", (Object)new String(message, StandardCharsets.UTF_8));
            message = "r=fyko+d2lbbFgONRv9qkxdawL3rfcNHYJY1ZVvWVs7j,s=QSXCR+Q6sek8bf92,i=4096".getBytes(StandardCharsets.UTF_8);
            message = saslClient.evaluateChallenge(message);
            Assert.assertEquals((Object)"c=bixhPXVzZXIs,r=fyko+d2lbbFgONRv9qkxdawL3rfcNHYJY1ZVvWVs7j,p=JFcfWujky5ZULVQwDmB5aHMkoME=", (Object)new String(message, StandardCharsets.UTF_8));
            message = "e=invalid-proof".getBytes(StandardCharsets.UTF_8);
            try {
                message = saslClient.evaluateChallenge(message);
                Assert.fail((String)"SaslException not thrown");
            }
            catch (SaslException e) {
                if (e.getMessage().contains("invalid-proof")) break block2;
                Assert.fail((String)("SaslException not contain error message (" + e.getMessage() + ")"));
            }
        }
        Assert.assertFalse((boolean)saslClient.isComplete());
    }
}

