/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import java.io.IOException;
import java.security.AlgorithmConstraints;
import java.security.AlgorithmParameters;
import java.security.CryptoPrimitive;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIMatcher;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.security.ssl.JDKSpecific;
import org.wildfly.security.ssl.SSLContextBuilder;

public class SSLConfiguratorImplTest {
    @Test
    public void testRejectNonExistentCipherSuite() throws GeneralSecurityException, IOException {
        SSLContext sslContext = (SSLContext)new SSLContextBuilder().build().create();
        SSLSocket socket = (SSLSocket)sslContext.getSocketFactory().createSocket();
        SSLParameters params = socket.getSSLParameters();
        params.setCipherSuites(new String[]{"invalidCipherSuite", "TLS_RSA_WITH_AES_128_CBC_SHA"});
        socket.setSSLParameters(params);
        Assert.assertTrue((socket.getSSLParameters().getCipherSuites().length == 1 && socket.getSSLParameters().getCipherSuites()[0].equals("TLS_RSA_WITH_AES_128_CBC_SHA") ? 1 : 0) != 0);
    }

    @Test
    public void testRejectNonExistentProtocol() throws GeneralSecurityException, IOException {
        SSLContext sslContext = (SSLContext)new SSLContextBuilder().build().create();
        SSLSocket socket = (SSLSocket)sslContext.getSocketFactory().createSocket();
        SSLParameters params = socket.getSSLParameters();
        List<String> protocols = Arrays.asList(params.getProtocols());
        Assert.assertTrue((protocols.contains("TLSv1.2") && protocols.contains("TLSv1.1") ? 1 : 0) != 0);
        params.setProtocols(new String[]{"invalidProtocol", "TLSv1.1"});
        socket.setSSLParameters(params);
        Assert.assertTrue((socket.getSSLParameters().getProtocols().length == 1 && socket.getSSLParameters().getProtocols()[0].equals("TLSv1.1") ? 1 : 0) != 0);
    }

    @Test
    public void testSetSSLParameters() {
        SSLParameters params = new SSLParameters();
        Object[] cipherSuites = new String[]{"TLS_RSA_WITH_AES_128_CBC_SHA256", "TLS_DHE_DSS_WITH_AES_256_CBC_SHA256"};
        Object[] protocols = new String[]{"TLSv1.2"};
        String[] passedCipherSuites = (String[])cipherSuites.clone();
        String[] passedProtocols = (String[])protocols.clone();
        List<SNIServerName> serverNames = Collections.unmodifiableList(Arrays.asList(new SNIHostName("localhost")));
        List<SNIMatcher> sniMatchers = Collections.unmodifiableList(Arrays.asList(SNIHostName.createSNIMatcher("www\\.example\\.com")));
        AlgorithmConstraints algorithmConstraints = new AlgorithmConstraints(){

            @Override
            public boolean permits(Set<CryptoPrimitive> set, String s, AlgorithmParameters algorithmParameters) {
                return false;
            }

            @Override
            public boolean permits(Set<CryptoPrimitive> set, Key key) {
                return false;
            }

            @Override
            public boolean permits(Set<CryptoPrimitive> set, String s, Key key, AlgorithmParameters algorithmParameters) {
                return false;
            }
        };
        params.setServerNames(serverNames);
        params.setCipherSuites(passedCipherSuites);
        params.setProtocols(passedProtocols);
        params.setSNIMatchers(sniMatchers);
        params.setAlgorithmConstraints(algorithmConstraints);
        params.setWantClientAuth(false);
        params.setNeedClientAuth(true);
        params.setUseCipherSuitesOrder(true);
        params.setEndpointIdentificationAlgorithm("HTTPS");
        SSLParameters copiedSSLParams = JDKSpecific.setSSLParameters((SSLParameters)params);
        Assert.assertNotSame((Object)copiedSSLParams, (Object)params);
        Assert.assertTrue((copiedSSLParams.getServerNames() != serverNames && copiedSSLParams.getServerNames().equals(serverNames) ? 1 : 0) != 0);
        Assert.assertTrue((copiedSSLParams.getCipherSuites() != passedCipherSuites && Arrays.equals(copiedSSLParams.getCipherSuites(), cipherSuites) ? 1 : 0) != 0);
        Assert.assertTrue((copiedSSLParams.getProtocols() != passedProtocols && Arrays.equals(copiedSSLParams.getProtocols(), protocols) ? 1 : 0) != 0);
        Assert.assertTrue((copiedSSLParams.getSNIMatchers() != sniMatchers && copiedSSLParams.getSNIMatchers().equals(sniMatchers) ? 1 : 0) != 0);
        Assert.assertSame((Object)copiedSSLParams.getAlgorithmConstraints(), (Object)algorithmConstraints);
        Assert.assertFalse((boolean)copiedSSLParams.getWantClientAuth());
        Assert.assertTrue((boolean)copiedSSLParams.getNeedClientAuth());
        Assert.assertTrue((boolean)copiedSSLParams.getUseCipherSuitesOrder());
        Assert.assertEquals((Object)"HTTPS", (Object)copiedSSLParams.getEndpointIdentificationAlgorithm());
    }
}

