/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.util;

import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.common.codec.Alphabet;
import org.wildfly.common.codec.Base32Alphabet;
import org.wildfly.common.codec.Base64Alphabet;
import org.wildfly.security.util.PasswordBasedEncryptionUtil;

public class PasswordBasedEncryptionUtilTest {
    private static final String clearText = "\u010cervenav\u00fd st\u0159izl\u00ed\u010dek a \u0161tebotav\u00e1 \u017el\u016fva \u010fobali ve s\u0165avnat\u00fdch oc\u00fanech.";
    private static final String DEFAULT_PICKETBOX_ALGORITHM = "PBEWithMD5AndDES";
    private static final String DEFAULT_PICKETBOX_INITIAL_KEY_MATERIAL = "somearbitrarycrazystringthatdoesnotmatter";

    @Test
    public void testEncryptEncode() throws GeneralSecurityException {
        String[] algorithms = new String[]{"PBEWithHmacSHA1andAES_128", "PBEWithHmacSHA256AndAES_128", DEFAULT_PICKETBOX_ALGORITHM};
        Alphabet[] alphabets = new Alphabet[]{Base64Alphabet.STANDARD, PasswordBasedEncryptionUtil.PICKETBOX_COMPATIBILITY, Base32Alphabet.STANDARD};
        for (String algorithm : algorithms) {
            for (Alphabet alphabet : alphabets) {
                this.doEncryptEncode(algorithm, "WHOLE", alphabet);
                this.doEncryptEncode(algorithm, "IV", alphabet);
            }
        }
    }

    private void doEncryptEncode(String algorithm, String transferAlgParams, Alphabet alphabet) throws GeneralSecurityException {
        String params = String.format("[algorithm=%s, transferAlgParams=%s]", algorithm, transferAlgParams);
        PasswordBasedEncryptionUtil pbeUtil1 = new PasswordBasedEncryptionUtil.Builder().alphabet(alphabet).password("ThisIsStrangeInitialKey").salt("SALTsalt").iteration(234).keyAlgorithm(algorithm).encryptMode().build();
        PasswordBasedEncryptionUtil.Builder builder2 = new PasswordBasedEncryptionUtil.Builder().password("ThisIsStrangeInitialKey").salt("SALTsalt").iteration(234).alphabet(alphabet).keyAlgorithm(algorithm).decryptMode();
        if ("WHOLE".equals(transferAlgParams)) {
            builder2.algorithmParameters(pbeUtil1.getAlgorithmParameters());
        } else if ("IV".equals(transferAlgParams)) {
            builder2.iv(pbeUtil1.getEncodedIV());
        }
        PasswordBasedEncryptionUtil pbeUtil2 = builder2.build();
        String encodedSecret = pbeUtil1.encryptAndEncode(clearText.toCharArray());
        Assert.assertNotNull((String)("encodedSecret is supposed to be not null (" + params + ")"), (Object)encodedSecret);
        char[] decrypted = pbeUtil2.decodeAndDecrypt(encodedSecret);
        Assert.assertNotNull((String)("decrypted is supposed to be not null (" + params + ")"), (Object)decrypted);
        Assert.assertArrayEquals((String)("clearText should be equal decrypted (" + params + ")"), (char[])clearText.toCharArray(), (char[])decrypted);
    }

    @Test
    public void testPBKDF() throws GeneralSecurityException {
        String transformation;
        String keyAlgorithm = "PBKDF2WithHmacSHA1";
        String parameters = transformation = "PBEWithHmacSHA256AndAES_128";
        PasswordBasedEncryptionUtil pbeUtil1 = new PasswordBasedEncryptionUtil.Builder().password("ThisIsStrangeInitialKey").salt("SALTsalt".getBytes(StandardCharsets.UTF_8)).iteration(234).keyAlgorithm(keyAlgorithm).keyLength(256).transformation(transformation).parametersAlgorithm(parameters).cipherIteration(516).cipherSalt("frosty11".getBytes(StandardCharsets.UTF_8)).encryptMode().build();
        PasswordBasedEncryptionUtil.Builder builder2 = new PasswordBasedEncryptionUtil.Builder().password("ThisIsStrangeInitialKey".toCharArray()).salt("SALTsalt").iteration(234).keyAlgorithm(keyAlgorithm).keyLength(256).transformation(transformation).parametersAlgorithm(parameters).cipherIteration(516).cipherSalt("frosty11").decryptMode();
        builder2.iv(pbeUtil1.getEncodedIV());
        PasswordBasedEncryptionUtil pbeUtil2 = builder2.build();
        String encodedSecret = pbeUtil1.encryptAndEncode(clearText.toCharArray());
        Assert.assertNotNull((String)"encodedSecret is supposed to be not null", (Object)encodedSecret);
        char[] decrypted = pbeUtil2.decodeAndDecrypt(encodedSecret);
        Assert.assertNotNull((String)"decrypted is supposed to be not null", (Object)decrypted);
        Assert.assertArrayEquals((String)"clearText should be equal decrypted", (char[])clearText.toCharArray(), (char[])decrypted);
    }

    @Test
    public void testPicketBoxCompatibility() throws Exception {
        String secret1 = "secret_password";
        String pbGenerated1 = "1GhfMaq4jSY0.kFFU3QG4T";
        this.checkPb("secret_password", "12345678", 230, "1GhfMaq4jSY0.kFFU3QG4T");
        String secret2 = "super_secret";
        String pbGenerated2 = "088WUKotOwu7VOS8xRj.Rr";
        this.checkPb("super_secret", "ASDF1234", 123, "088WUKotOwu7VOS8xRj.Rr");
    }

    private void checkPb(String secret, String salt, int iteration, String pbGenerated) throws GeneralSecurityException {
        PasswordBasedEncryptionUtil encryptUtil = new PasswordBasedEncryptionUtil.Builder().picketBoxCompatibility().salt(salt).iteration(iteration).encryptMode().build();
        PasswordBasedEncryptionUtil decryptUtil = new PasswordBasedEncryptionUtil.Builder().picketBoxCompatibility().salt(salt).iteration(iteration).decryptMode().build();
        String encrypted = encryptUtil.encryptAndEncode(secret.toCharArray());
        String crossDecrypted = new String(decryptUtil.decodeAndDecrypt(pbGenerated));
        String decrypted = new String(decryptUtil.decodeAndDecrypt(encrypted));
        Assert.assertTrue((String)"Elytron in PB compatible mode failed", (boolean)decrypted.equals(secret));
        Assert.assertTrue((String)"PicketBox encrypted, Elytron decrypted in compatible mode, failed", (boolean)crossDecrypted.equals(secret));
        Assert.assertTrue((String)"Elytron in compatible mode encrypted, PicketBox encrypted must be the same", (boolean)pbGenerated.equals(encrypted));
    }
}

