/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.x500;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import javax.security.auth.x500.X500Principal;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.security.asn1.ASN1Encodable;
import org.wildfly.security.x500.X500;
import org.wildfly.security.x500.X500AttributeTypeAndValue;
import org.wildfly.security.x500.X500PrincipalBuilder;
import org.wildfly.security.x500.cert.X509CertificateBuilder;

public class X500Test {
    private static X509Certificate[] populateCertificateChain() throws Exception {
        KeyPairGenerator keyPairGenerator;
        try {
            keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error(e);
        }
        KeyPair[] keyPairs = new KeyPair[5];
        for (int i = 0; i < keyPairs.length; ++i) {
            keyPairs[i] = keyPairGenerator.generateKeyPair();
        }
        X509Certificate[] orderedCertificates = new X509Certificate[5];
        for (int i = 0; i < orderedCertificates.length; ++i) {
            X509CertificateBuilder builder = new X509CertificateBuilder();
            X500PrincipalBuilder principalBuilder = new X500PrincipalBuilder();
            principalBuilder.addItem(X500AttributeTypeAndValue.create((String)"2.5.4.3", (ASN1Encodable)ASN1Encodable.ofUtf8String((String)("bob" + i))));
            X500Principal dn = principalBuilder.build();
            builder.setSubjectDn(dn);
            if (i == orderedCertificates.length - 1) {
                builder.setIssuerDn(dn);
                builder.setSigningKey(keyPairs[i].getPrivate());
            } else {
                principalBuilder = new X500PrincipalBuilder();
                principalBuilder.addItem(X500AttributeTypeAndValue.create((String)"2.5.4.3", (ASN1Encodable)ASN1Encodable.ofUtf8String((String)("bob" + (i + 1)))));
                X500Principal issuerDn = principalBuilder.build();
                builder.setIssuerDn(issuerDn);
                builder.setSigningKey(keyPairs[i + 1].getPrivate());
            }
            builder.setSignatureAlgorithmName("SHA256withRSA");
            builder.setPublicKey(keyPairs[i].getPublic());
            orderedCertificates[i] = builder.build();
        }
        return orderedCertificates;
    }

    @Test
    public void testAsOrderedX509CertificateChain() throws Exception {
        Object[] orderedCertificates = X500Test.populateCertificateChain();
        Certificate[] unorderedCertificates = new X509Certificate[]{orderedCertificates[4]};
        Assert.assertArrayEquals((Object[])new X509Certificate[]{orderedCertificates[4]}, (Object[])X500.asOrderedX509CertificateChain((PublicKey)orderedCertificates[4].getPublicKey(), (Certificate[])unorderedCertificates));
        unorderedCertificates = new X509Certificate[]{orderedCertificates[3], orderedCertificates[0], orderedCertificates[4], orderedCertificates[1], orderedCertificates[2]};
        Assert.assertArrayEquals((Object[])orderedCertificates, (Object[])X500.asOrderedX509CertificateChain((PublicKey)orderedCertificates[0].getPublicKey(), (Certificate[])unorderedCertificates));
    }

    @Test
    public void testAsOrderedX509CertificateChainInvalidValues() throws Exception {
        X509Certificate[] orderedCertificates = X500Test.populateCertificateChain();
        try {
            X500.asOrderedX509CertificateChain((PublicKey)orderedCertificates[0].getPublicKey(), (Certificate[])new X509Certificate[]{orderedCertificates[3], orderedCertificates[1], orderedCertificates[2]});
            Assert.fail((String)"Expected IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            X500.asOrderedX509CertificateChain((PublicKey)orderedCertificates[0].getPublicKey(), (Certificate[])new X509Certificate[]{orderedCertificates[4], orderedCertificates[0], orderedCertificates[3], orderedCertificates[1]});
            Assert.fail((String)"Expected IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateX509CertificateChain() throws Exception {
        Object[] orderedCertificates = X500Test.populateCertificateChain();
        HashMap<Principal, HashSet<X509Certificate>> certificatesMap = new HashMap<Principal, HashSet<X509Certificate>>();
        certificatesMap = new HashMap();
        certificatesMap.put(orderedCertificates[4].getSubjectDN(), new HashSet<X509Certificate>(Arrays.asList(orderedCertificates[4])));
        Assert.assertArrayEquals((Object[])new X509Certificate[]{orderedCertificates[4]}, (Object[])X500.createX509CertificateChain((X509Certificate)orderedCertificates[4], certificatesMap));
        certificatesMap = new HashMap();
        for (int i = 0; i < orderedCertificates.length; ++i) {
            certificatesMap.put(orderedCertificates[i].getSubjectDN(), new HashSet<X509Certificate>(Arrays.asList(orderedCertificates[i])));
        }
        Assert.assertArrayEquals((Object[])orderedCertificates, (Object[])X500.createX509CertificateChain((X509Certificate)orderedCertificates[0], certificatesMap));
    }

    @Test
    public void testCreateX509CertificateChainInvalidValues() throws Exception {
        X509Certificate[] orderedCertificates = X500Test.populateCertificateChain();
        HashMap<Principal, HashSet<X509Certificate>> certificatesMap = new HashMap<Principal, HashSet<X509Certificate>>();
        for (int i = 0; i < orderedCertificates.length; i += 2) {
            certificatesMap.put(orderedCertificates[i].getSubjectDN(), new HashSet<X509Certificate>(Arrays.asList(orderedCertificates[i])));
        }
        try {
            X500.createX509CertificateChain((X509Certificate)orderedCertificates[0], certificatesMap);
            Assert.fail((String)"Expected IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException i) {
            // empty catch block
        }
        for (int i = 2; i < orderedCertificates.length; ++i) {
            certificatesMap.put(orderedCertificates[i].getSubjectDN(), new HashSet<X509Certificate>(Arrays.asList(orderedCertificates[i])));
        }
        try {
            X500.createX509CertificateChain((X509Certificate)orderedCertificates[0], certificatesMap);
            Assert.fail((String)"Expected IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

