/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.manager;

import java.security.AccessController;
import java.security.Principal;
import javax.security.auth.Subject;

public final class SubjectUtils {
    public static Subject getCurrent() {
        return Subject.getSubject(AccessController.getContext());
    }

    public static <P extends Principal> P getPrincipal(Class<P> type, Subject subject) {
        for (Principal principal : subject.getPrincipals()) {
            if (!type.isInstance(principal)) continue;
            return (P)((Principal)type.cast(principal));
        }
        return null;
    }

    public static <C> C getPublicCredential(Class<C> type, Subject subject) {
        for (Object cred : subject.getPublicCredentials()) {
            if (!type.isInstance(cred)) continue;
            return type.cast(cred);
        }
        return null;
    }

    public static <C> C getPrivateCredential(Class<C> type, Subject subject) {
        for (Object cred : subject.getPrivateCredentials()) {
            if (!type.isInstance(cred)) continue;
            return type.cast(cred);
        }
        return null;
    }
}

