/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.manager;

import java.io.FileDescriptor;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyPermission;
import org.wildfly.security.manager.GetAccessibleDeclaredFieldAction;
import org.wildfly.security.manager._private.SecurityMessages;
import org.wildfly.security.manager.action.ClearPropertyAction;
import org.wildfly.security.manager.action.GetClassLoaderAction;
import org.wildfly.security.manager.action.GetContextClassLoaderAction;
import org.wildfly.security.manager.action.GetEnvironmentAction;
import org.wildfly.security.manager.action.GetProtectionDomainAction;
import org.wildfly.security.manager.action.GetSystemPropertiesAction;
import org.wildfly.security.manager.action.ReadEnvironmentPropertyAction;
import org.wildfly.security.manager.action.ReadPropertyAction;
import org.wildfly.security.manager.action.SetContextClassLoaderAction;
import org.wildfly.security.manager.action.WritePropertyAction;
import sun.reflect.Reflection;

public final class WildFlySecurityManager
extends SecurityManager {
    private static final Permission SECURITY_MANAGER_PERMISSION = new RuntimePermission("setSecurityManager");
    private static final Permission UNCHECKED_PERMISSION = new RuntimePermission("doUnchecked");
    private static final Permission PROPERTIES_PERMISSION = new PropertyPermission("*", "read,write");
    private static final Permission ENVIRONMENT_PERMISSION = new RuntimePermission("getenv.*");
    private static final Permission GET_CLASS_LOADER_PERMISSION = new RuntimePermission("getClassLoader");
    private static final Permission SET_CLASS_LOADER_PERMISSION = new RuntimePermission("setClassLoader");
    private static final InheritableThreadLocal<Boolean> CHECKING = new InheritableThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.TRUE;
        }
    };
    private static final ThreadLocal<Boolean> ENTERED = new ThreadLocal();
    private static final Field PD_STACK = AccessController.doPrivileged(new GetAccessibleDeclaredFieldAction(AccessControlContext.class, "context"));
    private static final WildFlySecurityManager INSTANCE = AccessController.doPrivileged(new PrivilegedAction<WildFlySecurityManager>(){

        @Override
        public WildFlySecurityManager run() {
            return new WildFlySecurityManager();
        }
    });
    private static final boolean hasGetCallerClass;
    private static final int callerOffset;

    private WildFlySecurityManager() {
    }

    public static void install() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != INSTANCE) {
            System.setSecurityManager(INSTANCE);
        }
    }

    static Class<?> getCallerClass(int n) {
        if (hasGetCallerClass) {
            return Reflection.getCallerClass((int)(n + callerOffset));
        }
        return WildFlySecurityManager.getCallStack()[n + callerOffset];
    }

    static Class<?>[] getCallStack() {
        return INSTANCE.getClassContext();
    }

    public static boolean isChecking() {
        SecurityManager sm = System.getSecurityManager();
        return sm instanceof WildFlySecurityManager ? CHECKING.get() == Boolean.TRUE : sm != null;
    }

    @Override
    public void checkPermission(Permission perm) throws SecurityException {
        this.checkPermission(perm, AccessController.getContext());
    }

    @Override
    public void checkPermission(Permission perm, Object context) throws SecurityException {
        if (!(context instanceof AccessControlContext)) {
            throw SecurityMessages.access.unknownContext();
        }
        this.checkPermission(perm, (AccessControlContext)context);
    }

    public static ProtectionDomain findAccessDenial(Permission permission, ProtectionDomain ... domains) {
        if (domains != null) {
            for (ProtectionDomain domain : domains) {
                if (domain.implies(permission)) continue;
                return domain;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tryCheckPermission(Permission permission, ProtectionDomain ... domains) {
        ProtectionDomain protectionDomain = WildFlySecurityManager.findAccessDenial(permission, domains);
        if (protectionDomain != null) {
            if (ENTERED.get() != Boolean.TRUE) {
                ENTERED.set(Boolean.TRUE);
                try {
                    CodeSource codeSource = protectionDomain.getCodeSource();
                    ClassLoader classLoader = protectionDomain.getClassLoader();
                    Object[] principals = protectionDomain.getPrincipals();
                    if (principals == null || principals.length == 0) {
                        SecurityMessages.access.accessCheckFailed(permission, codeSource, classLoader);
                    } else {
                        SecurityMessages.access.accessCheckFailed(permission, codeSource, classLoader, Arrays.toString(principals));
                    }
                }
                finally {
                    ENTERED.set(Boolean.FALSE);
                }
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkPermission(Permission perm, AccessControlContext context) throws SecurityException {
        if (perm.implies(SECURITY_MANAGER_PERMISSION)) {
            throw SecurityMessages.access.secMgrChange();
        }
        if (CHECKING.get() == Boolean.TRUE) {
            if (ENTERED.get() == Boolean.TRUE) {
                return;
            }
            ENTERED.set(Boolean.TRUE);
            try {
                ProtectionDomain deniedDomain;
                ProtectionDomain[] stack;
                try {
                    stack = (ProtectionDomain[])PD_STACK.get(context);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalAccessError(e.getMessage());
                }
                if (stack != null && (deniedDomain = WildFlySecurityManager.findAccessDenial(perm, stack)) != null) {
                    CodeSource codeSource = deniedDomain.getCodeSource();
                    ClassLoader classLoader = deniedDomain.getClassLoader();
                    throw SecurityMessages.access.accessControlException(perm, perm, codeSource, classLoader);
                }
            }
            finally {
                ENTERED.set(Boolean.FALSE);
            }
        }
    }

    @Override
    public void checkCreateClassLoader() {
        if (CHECKING.get() == Boolean.TRUE) {
            super.checkCreateClassLoader();
        }
    }

    @Override
    public void checkAccess(Thread t) {
        if (CHECKING.get() == Boolean.TRUE) {
            super.checkAccess(t);
        }
    }

    @Override
    public void checkAccess(ThreadGroup g) {
        if (CHECKING.get() == Boolean.TRUE) {
            super.checkAccess(g);
        }
    }

    @Override
    public void checkExit(int status) {
        if (CHECKING.get() == Boolean.TRUE) {
            super.checkExit(status);
        }
    }

    @Override
    public void checkExec(String cmd) {
        if (CHECKING.get() == Boolean.TRUE) {
            super.checkExec(cmd);
        }
    }

    @Override
    public void checkLink(String lib) {
        if (CHECKING.get() == Boolean.TRUE) {
            super.checkLink(lib);
        }
    }

    @Override
    public void checkRead(FileDescriptor fd) {
        if (CHECKING.get() == Boolean.TRUE) {
            super.checkRead(fd);
        }
    }

    @Override
    public void checkRead(String file) {
        if (CHECKING.get() == Boolean.TRUE) {
            super.checkRead(file);
        }
    }

    @Override
    public void checkRead(String file, Object context) {
        if (CHECKING.get() == Boolean.TRUE) {
            super.checkRead(file, context);
        }
    }

    @Override
    public void checkWrite(FileDescriptor fd) {
        if (CHECKING.get() == Boolean.TRUE) {
            super.checkWrite(fd);
        }
    }

    @Override
    public void checkWrite(String file) {
        if (CHECKING.get() == Boolean.TRUE) {
            super.checkWrite(file);
        }
    }

    @Override
    public void checkDelete(String file) {
        if (CHECKING.get() == Boolean.TRUE) {
            super.checkDelete(file);
        }
    }

    @Override
    public void checkConnect(String host, int port) {
        if (CHECKING.get() == Boolean.TRUE) {
            super.checkConnect(host, port);
        }
    }

    @Override
    public void checkConnect(String host, int port, Object context) {
        if (CHECKING.get() == Boolean.TRUE) {
            super.checkConnect(host, port, context);
        }
    }

    @Override
    public void checkListen(int port) {
        if (CHECKING.get() == Boolean.TRUE) {
            super.checkListen(port);
        }
    }

    @Override
    public void checkAccept(String host, int port) {
        if (CHECKING.get() == Boolean.TRUE) {
            super.checkAccept(host, port);
        }
    }

    @Override
    public void checkMulticast(InetAddress maddr) {
        if (CHECKING.get() == Boolean.TRUE) {
            super.checkMulticast(maddr);
        }
    }

    @Override
    @Deprecated
    public void checkMulticast(InetAddress maddr, byte ttl) {
        if (CHECKING.get() == Boolean.TRUE) {
            super.checkMulticast(maddr, ttl);
        }
    }

    @Override
    public void checkPropertiesAccess() {
        if (CHECKING.get() == Boolean.TRUE) {
            super.checkPropertiesAccess();
        }
    }

    @Override
    public void checkPropertyAccess(String key) {
        if (CHECKING.get() == Boolean.TRUE) {
            super.checkPropertyAccess(key);
        }
    }

    @Override
    public void checkPrintJobAccess() {
        if (CHECKING.get() == Boolean.TRUE) {
            super.checkPrintJobAccess();
        }
    }

    @Override
    public void checkPackageAccess(String pkg) {
        if (CHECKING.get() == Boolean.TRUE) {
            super.checkPackageAccess(pkg);
        }
    }

    @Override
    public void checkPackageDefinition(String pkg) {
        if (CHECKING.get() == Boolean.TRUE) {
            super.checkPackageDefinition(pkg);
        }
    }

    @Override
    public void checkSetFactory() {
        if (CHECKING.get() == Boolean.TRUE) {
            super.checkSetFactory();
        }
    }

    public void checkMemberAccess(Class<?> clazz, int which) {
        if (CHECKING.get() == Boolean.TRUE) {
            super.checkMemberAccess(clazz, which);
        }
    }

    @Override
    public void checkSecurityAccess(String target) {
        if (CHECKING.get() == Boolean.TRUE) {
            super.checkSecurityAccess(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T doChecked(PrivilegedAction<T> action) {
        InheritableThreadLocal<Boolean> checking = CHECKING;
        if (checking.get() == Boolean.TRUE) {
            return action.run();
        }
        checking.set(Boolean.TRUE);
        try {
            T t = action.run();
            return t;
        }
        finally {
            checking.set(Boolean.FALSE);
        }
    }

    public static <T> T doChecked(PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        InheritableThreadLocal<Boolean> checking = CHECKING;
        if (checking.get() == Boolean.TRUE) {
            try {
                return action.run();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PrivilegedActionException(e);
            }
        }
        checking.set(Boolean.TRUE);
        try {
            T e = action.run();
            return e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PrivilegedActionException(e);
        }
        finally {
            checking.set(Boolean.FALSE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T doChecked(PrivilegedAction<T> action, AccessControlContext context) {
        InheritableThreadLocal<Boolean> checking = CHECKING;
        if (checking.get() == Boolean.TRUE) {
            return action.run();
        }
        checking.set(Boolean.TRUE);
        try {
            T t = AccessController.doPrivileged(action, context);
            return t;
        }
        finally {
            checking.set(Boolean.FALSE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T doChecked(PrivilegedExceptionAction<T> action, AccessControlContext context) throws PrivilegedActionException {
        InheritableThreadLocal<Boolean> checking = CHECKING;
        if (checking.get() == Boolean.TRUE) {
            try {
                return action.run();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PrivilegedActionException(e);
            }
        }
        checking.set(Boolean.TRUE);
        try {
            T t = AccessController.doPrivileged(action, context);
            return t;
        }
        finally {
            checking.set(Boolean.FALSE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T doUnchecked(PrivilegedAction<T> action) {
        InheritableThreadLocal<Boolean> checking = CHECKING;
        if (checking.get() != Boolean.TRUE) {
            return action.run();
        }
        checking.set(Boolean.FALSE);
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                WildFlySecurityManager.checkPDPermission(WildFlySecurityManager.getCallerClass(2), UNCHECKED_PERMISSION);
            }
            T t = action.run();
            return t;
        }
        finally {
            checking.set(Boolean.TRUE);
        }
    }

    public static <T> T doUnchecked(PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        InheritableThreadLocal<Boolean> checking = CHECKING;
        if (checking.get() != Boolean.TRUE) {
            try {
                return action.run();
            }
            catch (Exception e) {
                throw new PrivilegedActionException(e);
            }
        }
        checking.set(Boolean.FALSE);
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                WildFlySecurityManager.checkPDPermission(WildFlySecurityManager.getCallerClass(2), UNCHECKED_PERMISSION);
            }
            T t = action.run();
            return t;
        }
        catch (Exception e) {
            throw new PrivilegedActionException(e);
        }
        finally {
            checking.set(Boolean.TRUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T doUnchecked(PrivilegedAction<T> action, AccessControlContext context) {
        InheritableThreadLocal<Boolean> checking = CHECKING;
        if (checking.get() != Boolean.TRUE) {
            return AccessController.doPrivileged(action, context);
        }
        checking.set(Boolean.FALSE);
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                WildFlySecurityManager.checkPDPermission(WildFlySecurityManager.getCallerClass(2), UNCHECKED_PERMISSION);
            }
            T t = AccessController.doPrivileged(action, context);
            return t;
        }
        finally {
            checking.set(Boolean.TRUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T doUnchecked(PrivilegedExceptionAction<T> action, AccessControlContext context) throws PrivilegedActionException {
        InheritableThreadLocal<Boolean> checking = CHECKING;
        if (checking.get() != Boolean.TRUE) {
            return AccessController.doPrivileged(action, context);
        }
        checking.set(Boolean.FALSE);
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                WildFlySecurityManager.checkPDPermission(WildFlySecurityManager.getCallerClass(2), UNCHECKED_PERMISSION);
            }
            T t = AccessController.doPrivileged(action, context);
            return t;
        }
        finally {
            checking.set(Boolean.TRUE);
        }
    }

    private static void checkPropertyReadPermission(Class<?> clazz, String propertyName) {
        ClassLoader classLoader;
        ProtectionDomain protectionDomain;
        if (System.getSecurityManager() instanceof WildFlySecurityManager) {
            protectionDomain = clazz.getProtectionDomain();
            classLoader = clazz.getClassLoader();
        } else {
            protectionDomain = AccessController.doPrivileged(new GetProtectionDomainAction(clazz));
            classLoader = AccessController.doPrivileged(new GetClassLoaderAction(clazz));
        }
        if (protectionDomain.implies(PROPERTIES_PERMISSION)) {
            return;
        }
        PropertyPermission permission = new PropertyPermission(propertyName, "read");
        if (protectionDomain.implies(permission)) {
            return;
        }
        throw SecurityMessages.access.accessControlException(permission, permission, protectionDomain.getCodeSource(), classLoader);
    }

    private static void checkEnvPropertyReadPermission(Class<?> clazz, String propertyName) {
        ClassLoader classLoader;
        ProtectionDomain protectionDomain;
        if (System.getSecurityManager() instanceof WildFlySecurityManager) {
            protectionDomain = clazz.getProtectionDomain();
            classLoader = clazz.getClassLoader();
        } else {
            protectionDomain = AccessController.doPrivileged(new GetProtectionDomainAction(clazz));
            classLoader = AccessController.doPrivileged(new GetClassLoaderAction(clazz));
        }
        if (protectionDomain.implies(ENVIRONMENT_PERMISSION)) {
            return;
        }
        RuntimePermission permission = new RuntimePermission("getenv." + propertyName);
        if (protectionDomain.implies(permission)) {
            return;
        }
        throw SecurityMessages.access.accessControlException(permission, permission, protectionDomain.getCodeSource(), classLoader);
    }

    private static void checkPropertyWritePermission(Class<?> clazz, String propertyName) {
        ClassLoader classLoader;
        ProtectionDomain protectionDomain;
        if (System.getSecurityManager() instanceof WildFlySecurityManager) {
            protectionDomain = clazz.getProtectionDomain();
            classLoader = clazz.getClassLoader();
        } else {
            protectionDomain = AccessController.doPrivileged(new GetProtectionDomainAction(clazz));
            classLoader = AccessController.doPrivileged(new GetClassLoaderAction(clazz));
        }
        if (protectionDomain.implies(PROPERTIES_PERMISSION)) {
            return;
        }
        PropertyPermission permission = new PropertyPermission(propertyName, "write");
        if (protectionDomain.implies(permission)) {
            return;
        }
        throw SecurityMessages.access.accessControlException(permission, permission, protectionDomain.getCodeSource(), classLoader);
    }

    private static void checkPDPermission(Class<?> clazz, Permission permission) {
        ClassLoader classLoader;
        ProtectionDomain protectionDomain;
        if (System.getSecurityManager() instanceof WildFlySecurityManager) {
            protectionDomain = clazz.getProtectionDomain();
            classLoader = clazz.getClassLoader();
        } else {
            protectionDomain = AccessController.doPrivileged(new GetProtectionDomainAction(clazz));
            classLoader = AccessController.doPrivileged(new GetClassLoaderAction(clazz));
        }
        if (protectionDomain.implies(permission)) {
            return;
        }
        throw SecurityMessages.access.accessControlException(permission, permission, protectionDomain.getCodeSource(), classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPropertyPrivileged(String name, String def) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return System.getProperty(name, def);
        }
        if (sm instanceof WildFlySecurityManager) {
            InheritableThreadLocal<Boolean> checking = CHECKING;
            if (checking.get() != Boolean.TRUE) {
                return System.getProperty(name, def);
            }
            WildFlySecurityManager.checkPropertyReadPermission(WildFlySecurityManager.getCallerClass(2), name);
            checking.set(Boolean.FALSE);
            try {
                String string = System.getProperty(name, def);
                return string;
            }
            finally {
                checking.set(Boolean.TRUE);
            }
        }
        WildFlySecurityManager.checkPropertyReadPermission(WildFlySecurityManager.getCallerClass(2), name);
        return AccessController.doPrivileged(new ReadPropertyAction(name, def));
    }

    private static <T> T def(T test, T def) {
        return test == null ? def : test;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getEnvPropertyPrivileged(String name, String def) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return System.getenv(name);
        }
        if (sm instanceof WildFlySecurityManager) {
            InheritableThreadLocal<Boolean> checking = CHECKING;
            if (checking.get() != Boolean.TRUE) {
                return WildFlySecurityManager.def(System.getenv(name), def);
            }
            WildFlySecurityManager.checkEnvPropertyReadPermission(WildFlySecurityManager.getCallerClass(2), name);
            checking.set(Boolean.FALSE);
            try {
                String string = WildFlySecurityManager.def(System.getenv(name), def);
                return string;
            }
            finally {
                checking.set(Boolean.TRUE);
            }
        }
        WildFlySecurityManager.checkEnvPropertyReadPermission(WildFlySecurityManager.getCallerClass(2), name);
        return AccessController.doPrivileged(new ReadEnvironmentPropertyAction(name, def));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String setPropertyPrivileged(String name, String value) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return System.setProperty(name, value);
        }
        if (sm instanceof WildFlySecurityManager) {
            InheritableThreadLocal<Boolean> checking = CHECKING;
            if (checking.get() != Boolean.TRUE) {
                return System.setProperty(name, value);
            }
            WildFlySecurityManager.checkPropertyWritePermission(WildFlySecurityManager.getCallerClass(2), name);
            checking.set(Boolean.FALSE);
            try {
                String string = System.setProperty(name, value);
                return string;
            }
            finally {
                checking.set(Boolean.TRUE);
            }
        }
        WildFlySecurityManager.checkPropertyWritePermission(WildFlySecurityManager.getCallerClass(2), name);
        return AccessController.doPrivileged(new WritePropertyAction(name, value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String clearPropertyPrivileged(String name) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return System.clearProperty(name);
        }
        if (sm instanceof WildFlySecurityManager) {
            InheritableThreadLocal<Boolean> checking = CHECKING;
            if (checking.get() != Boolean.TRUE) {
                return System.clearProperty(name);
            }
            WildFlySecurityManager.checkPropertyWritePermission(WildFlySecurityManager.getCallerClass(2), name);
            checking.set(Boolean.FALSE);
            try {
                String string = System.clearProperty(name);
                return string;
            }
            finally {
                checking.set(Boolean.TRUE);
            }
        }
        WildFlySecurityManager.checkPropertyWritePermission(WildFlySecurityManager.getCallerClass(2), name);
        return AccessController.doPrivileged(new ClearPropertyAction(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassLoader getCurrentContextClassLoaderPrivileged() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        if (sm instanceof WildFlySecurityManager) {
            InheritableThreadLocal<Boolean> checking = CHECKING;
            if (checking.get() != Boolean.TRUE) {
                return Thread.currentThread().getContextClassLoader();
            }
            checking.set(Boolean.FALSE);
            try {
                WildFlySecurityManager.checkPDPermission(WildFlySecurityManager.getCallerClass(2), GET_CLASS_LOADER_PERMISSION);
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                return classLoader;
            }
            finally {
                checking.set(Boolean.TRUE);
            }
        }
        WildFlySecurityManager.checkPDPermission(WildFlySecurityManager.getCallerClass(2), GET_CLASS_LOADER_PERMISSION);
        return AccessController.doPrivileged(GetContextClassLoaderAction.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassLoader setCurrentContextClassLoaderPrivileged(ClassLoader newClassLoader) {
        SecurityManager sm = System.getSecurityManager();
        Thread thread = Thread.currentThread();
        if (sm == null) {
            try {
                ClassLoader classLoader = thread.getContextClassLoader();
                return classLoader;
            }
            finally {
                thread.setContextClassLoader(newClassLoader);
            }
        }
        if (sm instanceof WildFlySecurityManager) {
            InheritableThreadLocal<Boolean> checking = CHECKING;
            if (checking.get() != Boolean.TRUE) {
                try {
                    ClassLoader classLoader = thread.getContextClassLoader();
                    return classLoader;
                }
                finally {
                    thread.setContextClassLoader(newClassLoader);
                }
            }
            checking.set(Boolean.FALSE);
            try {
                WildFlySecurityManager.checkPDPermission(WildFlySecurityManager.getCallerClass(2), SET_CLASS_LOADER_PERMISSION);
                try {
                    ClassLoader classLoader = thread.getContextClassLoader();
                    thread.setContextClassLoader(newClassLoader);
                    return classLoader;
                }
                catch (Throwable throwable) {
                    thread.setContextClassLoader(newClassLoader);
                    throw throwable;
                }
            }
            finally {
                checking.set(Boolean.TRUE);
            }
        }
        WildFlySecurityManager.checkPDPermission(WildFlySecurityManager.getCallerClass(2), SET_CLASS_LOADER_PERMISSION);
        return AccessController.doPrivileged(new SetContextClassLoaderAction(newClassLoader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassLoader setCurrentContextClassLoaderPrivileged(Class<?> clazz) {
        SecurityManager sm = System.getSecurityManager();
        Thread thread = Thread.currentThread();
        if (sm == null) {
            try {
                ClassLoader classLoader = thread.getContextClassLoader();
                return classLoader;
            }
            finally {
                thread.setContextClassLoader(clazz.getClassLoader());
            }
        }
        if (sm instanceof WildFlySecurityManager) {
            InheritableThreadLocal<Boolean> checking = CHECKING;
            if (checking.get() != Boolean.TRUE) {
                try {
                    ClassLoader classLoader = thread.getContextClassLoader();
                    return classLoader;
                }
                finally {
                    thread.setContextClassLoader(clazz.getClassLoader());
                }
            }
            checking.set(Boolean.FALSE);
            try {
                Class<?> caller = WildFlySecurityManager.getCallerClass(2);
                WildFlySecurityManager.checkPDPermission(caller, SET_CLASS_LOADER_PERMISSION);
                WildFlySecurityManager.checkPDPermission(caller, GET_CLASS_LOADER_PERMISSION);
                try {
                    ClassLoader classLoader = thread.getContextClassLoader();
                    thread.setContextClassLoader(clazz.getClassLoader());
                    return classLoader;
                }
                catch (Throwable throwable) {
                    thread.setContextClassLoader(clazz.getClassLoader());
                    throw throwable;
                }
            }
            finally {
                checking.set(Boolean.TRUE);
            }
        }
        Class<?> caller = WildFlySecurityManager.getCallerClass(2);
        WildFlySecurityManager.checkPDPermission(caller, SET_CLASS_LOADER_PERMISSION);
        WildFlySecurityManager.checkPDPermission(caller, GET_CLASS_LOADER_PERMISSION);
        return AccessController.doPrivileged(new SetContextClassLoaderAction(clazz.getClassLoader()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getSystemPropertiesPrivileged() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return System.getProperties();
        }
        if (sm instanceof WildFlySecurityManager) {
            InheritableThreadLocal<Boolean> checking = CHECKING;
            if (checking.get() != Boolean.TRUE) {
                return System.getProperties();
            }
            checking.set(Boolean.FALSE);
            try {
                WildFlySecurityManager.checkPDPermission(WildFlySecurityManager.getCallerClass(2), PROPERTIES_PERMISSION);
                Properties properties = System.getProperties();
                return properties;
            }
            finally {
                checking.set(Boolean.TRUE);
            }
        }
        WildFlySecurityManager.checkPDPermission(WildFlySecurityManager.getCallerClass(2), PROPERTIES_PERMISSION);
        return AccessController.doPrivileged(GetSystemPropertiesAction.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getSystemEnvironmentPrivileged() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return System.getenv();
        }
        if (sm instanceof WildFlySecurityManager) {
            InheritableThreadLocal<Boolean> checking = CHECKING;
            if (checking.get() != Boolean.TRUE) {
                return System.getenv();
            }
            checking.set(Boolean.FALSE);
            try {
                WildFlySecurityManager.checkPDPermission(WildFlySecurityManager.getCallerClass(2), ENVIRONMENT_PERMISSION);
                Map<String, String> map = System.getenv();
                return map;
            }
            finally {
                checking.set(Boolean.TRUE);
            }
        }
        WildFlySecurityManager.checkPDPermission(WildFlySecurityManager.getCallerClass(2), ENVIRONMENT_PERMISSION);
        return AccessController.doPrivileged(GetEnvironmentAction.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassLoader getClassLoaderPrivileged(Class<?> clazz) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return clazz.getClassLoader();
        }
        if (sm instanceof WildFlySecurityManager) {
            InheritableThreadLocal<Boolean> checking = CHECKING;
            if (checking.get() != Boolean.TRUE) {
                return clazz.getClassLoader();
            }
            checking.set(Boolean.FALSE);
            try {
                WildFlySecurityManager.checkPDPermission(WildFlySecurityManager.getCallerClass(2), GET_CLASS_LOADER_PERMISSION);
                ClassLoader classLoader = clazz.getClassLoader();
                return classLoader;
            }
            finally {
                checking.set(Boolean.TRUE);
            }
        }
        WildFlySecurityManager.checkPDPermission(WildFlySecurityManager.getCallerClass(2), GET_CLASS_LOADER_PERMISSION);
        return AccessController.doPrivileged(new GetClassLoaderAction(clazz));
    }

    static {
        boolean result = false;
        int offset = 0;
        try {
            result = Reflection.getCallerClass((int)1) == WildFlySecurityManager.class || Reflection.getCallerClass((int)2) == WildFlySecurityManager.class;
            offset = Reflection.getCallerClass((int)1) == Reflection.class ? 2 : 1;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        hasGetCallerClass = result;
        callerOffset = offset;
    }
}

