/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.manager;

import java.io.FileDescriptor;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyPermission;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.wildfly.security.ParametricPrivilegedAction;
import org.wildfly.security.ParametricPrivilegedExceptionAction;
import org.wildfly.security.manager.GetAccessibleDeclaredFieldAction;
import org.wildfly.security.manager.WildFlySecurityManagerPermission;
import org.wildfly.security.manager._private.SecurityMessages;
import org.wildfly.security.manager.action.ClearPropertyAction;
import org.wildfly.security.manager.action.GetClassLoaderAction;
import org.wildfly.security.manager.action.GetContextClassLoaderAction;
import org.wildfly.security.manager.action.GetEnvironmentAction;
import org.wildfly.security.manager.action.GetProtectionDomainAction;
import org.wildfly.security.manager.action.GetSystemPropertiesAction;
import org.wildfly.security.manager.action.ReadEnvironmentPropertyAction;
import org.wildfly.security.manager.action.ReadPropertyAction;
import org.wildfly.security.manager.action.SetContextClassLoaderAction;
import org.wildfly.security.manager.action.WritePropertyAction;
import sun.reflect.Reflection;

public final class WildFlySecurityManager
extends SecurityManager {
    private static final Permission SECURITY_MANAGER_PERMISSION = new RuntimePermission("setSecurityManager");
    private static final Permission PROPERTIES_PERMISSION = new PropertyPermission("*", "read,write");
    private static final Permission ENVIRONMENT_PERMISSION = new RuntimePermission("getenv.*");
    private static final Permission GET_CLASS_LOADER_PERMISSION = new RuntimePermission("getClassLoader");
    private static final Permission SET_CLASS_LOADER_PERMISSION = new RuntimePermission("setClassLoader");
    private static final ThreadLocal<Context> CTX = new ThreadLocal<Context>(){

        @Override
        protected Context initialValue() {
            return new Context();
        }
    };
    private static final Field PD_STACK = AccessController.doPrivileged(new GetAccessibleDeclaredFieldAction(AccessControlContext.class, "context"));
    private static final WildFlySecurityManager INSTANCE = AccessController.doPrivileged(new PrivilegedAction<WildFlySecurityManager>(){

        @Override
        public WildFlySecurityManager run() {
            return new WildFlySecurityManager();
        }
    });
    private static final boolean hasGetCallerClass;
    private static final int callerOffset;
    private static final RuntimePermission ACCESS_DECLARED_MEMBERS_PERMISSION;
    private static final Class<?>[] ATOMIC_FIELD_UPDATER_TYPES;
    private static final ClassValue<AccessControlContext> ACC_CACHE;
    private static final PrivilegedAction<Object> PA_TRAMPOLINE1;
    private static final PrivilegedExceptionAction<Object> PA_TRAMPOLINE2;

    @Deprecated
    public static void install() throws SecurityException {
        if (System.getSecurityManager() instanceof WildFlySecurityManager) {
            return;
        }
        System.setSecurityManager(new WildFlySecurityManager());
    }

    static Class<?> getCallerClass(int n) {
        if (hasGetCallerClass) {
            return Reflection.getCallerClass((int)(n + callerOffset));
        }
        return WildFlySecurityManager.getCallStack()[n + callerOffset];
    }

    static Class<?>[] getCallStack() {
        return INSTANCE.getClassContext();
    }

    public static boolean isChecking() {
        SecurityManager sm = System.getSecurityManager();
        return sm instanceof WildFlySecurityManager ? WildFlySecurityManager.doCheck() : sm != null;
    }

    @Override
    public void checkPermission(Permission perm) throws SecurityException {
        this.checkPermission(perm, AccessController.getContext());
    }

    @Override
    public void checkPermission(Permission perm, Object context) throws SecurityException {
        if (!(context instanceof AccessControlContext)) {
            throw SecurityMessages.access.unknownContext();
        }
        this.checkPermission(perm, (AccessControlContext)context);
    }

    public static ProtectionDomain findAccessDenial(Permission permission, ProtectionDomain ... domains) {
        if (domains != null) {
            for (ProtectionDomain domain : domains) {
                if (domain.implies(permission)) continue;
                return domain;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tryCheckPermission(Permission permission, ProtectionDomain ... domains) {
        ProtectionDomain protectionDomain = WildFlySecurityManager.findAccessDenial(permission, domains);
        if (protectionDomain != null) {
            Context ctx = CTX.get();
            if (!ctx.entered) {
                ctx.entered = true;
                try {
                    CodeSource codeSource = protectionDomain.getCodeSource();
                    ClassLoader classLoader = protectionDomain.getClassLoader();
                    Object[] principals = protectionDomain.getPrincipals();
                    if (principals == null || principals.length == 0) {
                        SecurityMessages.access.accessCheckFailed(permission, codeSource, classLoader);
                    } else {
                        SecurityMessages.access.accessCheckFailed(permission, codeSource, classLoader, Arrays.toString(principals));
                    }
                }
                finally {
                    ctx.entered = true;
                }
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkPermission(Permission perm, AccessControlContext context) throws SecurityException {
        if (perm.implies(SECURITY_MANAGER_PERMISSION)) {
            throw SecurityMessages.access.secMgrChange();
        }
        Context ctx = CTX.get();
        if (ctx.checking) {
            if (ctx.entered) {
                return;
            }
            ctx.entered = true;
            try {
                ProtectionDomain deniedDomain;
                ProtectionDomain[] stack = WildFlySecurityManager.getProtectionDomainStack(context);
                if (stack != null && (deniedDomain = WildFlySecurityManager.findAccessDenial(perm, stack)) != null) {
                    CodeSource codeSource = deniedDomain.getCodeSource();
                    ClassLoader classLoader = deniedDomain.getClassLoader();
                    Object[] principals = deniedDomain.getPrincipals();
                    if (principals == null || principals.length == 0) {
                        SecurityMessages.access.accessCheckFailed(perm, codeSource, classLoader);
                    } else {
                        SecurityMessages.access.accessCheckFailed(perm, codeSource, classLoader, Arrays.toString(principals));
                    }
                    throw SecurityMessages.access.accessControlException(perm, perm, codeSource, classLoader);
                }
            }
            finally {
                ctx.entered = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkPermission(Permission perm, Class<?> clazz) throws SecurityException {
        if (perm.implies(SECURITY_MANAGER_PERMISSION)) {
            throw SecurityMessages.access.secMgrChange();
        }
        Context ctx = CTX.get();
        if (ctx.checking) {
            if (ctx.entered) {
                return;
            }
            ctx.entered = true;
            try {
                ProtectionDomain protectionDomain = clazz.getProtectionDomain();
                if (protectionDomain != null && !protectionDomain.implies(perm)) {
                    CodeSource codeSource = protectionDomain.getCodeSource();
                    ClassLoader classLoader = protectionDomain.getClassLoader();
                    Object[] principals = protectionDomain.getPrincipals();
                    if (principals == null || principals.length == 0) {
                        SecurityMessages.access.accessCheckFailed(perm, codeSource, classLoader);
                    } else {
                        SecurityMessages.access.accessCheckFailed(perm, codeSource, classLoader, Arrays.toString(principals));
                    }
                    throw SecurityMessages.access.accessControlException(perm, perm, codeSource, classLoader);
                }
            }
            finally {
                ctx.entered = false;
            }
        }
    }

    private static ProtectionDomain[] getProtectionDomainStack(AccessControlContext context) {
        ProtectionDomain[] stack;
        try {
            stack = (ProtectionDomain[])PD_STACK.get(context);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
        return stack;
    }

    private static boolean doCheck() {
        return WildFlySecurityManager.doCheck(CTX.get());
    }

    private static boolean doCheck(Context ctx) {
        return ctx.checking && !ctx.entered;
    }

    @Override
    public void checkCreateClassLoader() {
        if (WildFlySecurityManager.doCheck()) {
            super.checkCreateClassLoader();
        }
    }

    @Override
    public void checkAccess(Thread t) {
        if (WildFlySecurityManager.doCheck()) {
            super.checkAccess(t);
        }
    }

    @Override
    public void checkAccess(ThreadGroup g) {
        if (WildFlySecurityManager.doCheck()) {
            super.checkAccess(g);
        }
    }

    @Override
    public void checkExit(int status) {
        if (WildFlySecurityManager.doCheck()) {
            super.checkExit(status);
        }
    }

    @Override
    public void checkExec(String cmd) {
        if (WildFlySecurityManager.doCheck()) {
            super.checkExec(cmd);
        }
    }

    @Override
    public void checkLink(String lib) {
        if (WildFlySecurityManager.doCheck()) {
            super.checkLink(lib);
        }
    }

    @Override
    public void checkRead(FileDescriptor fd) {
        if (WildFlySecurityManager.doCheck()) {
            super.checkRead(fd);
        }
    }

    @Override
    public void checkRead(String file) {
        if (WildFlySecurityManager.doCheck()) {
            super.checkRead(file);
        }
    }

    @Override
    public void checkRead(String file, Object context) {
        if (WildFlySecurityManager.doCheck()) {
            super.checkRead(file, context);
        }
    }

    @Override
    public void checkWrite(FileDescriptor fd) {
        if (WildFlySecurityManager.doCheck()) {
            super.checkWrite(fd);
        }
    }

    @Override
    public void checkWrite(String file) {
        if (WildFlySecurityManager.doCheck()) {
            super.checkWrite(file);
        }
    }

    @Override
    public void checkDelete(String file) {
        if (WildFlySecurityManager.doCheck()) {
            super.checkDelete(file);
        }
    }

    @Override
    public void checkConnect(String host, int port) {
        if (WildFlySecurityManager.doCheck()) {
            super.checkConnect(host, port);
        }
    }

    @Override
    public void checkConnect(String host, int port, Object context) {
        if (WildFlySecurityManager.doCheck()) {
            super.checkConnect(host, port, context);
        }
    }

    @Override
    public void checkListen(int port) {
        if (WildFlySecurityManager.doCheck()) {
            super.checkListen(port);
        }
    }

    @Override
    public void checkAccept(String host, int port) {
        if (WildFlySecurityManager.doCheck()) {
            super.checkAccept(host, port);
        }
    }

    @Override
    public void checkMulticast(InetAddress maddr) {
        if (WildFlySecurityManager.doCheck()) {
            super.checkMulticast(maddr);
        }
    }

    @Override
    @Deprecated
    public void checkMulticast(InetAddress maddr, byte ttl) {
        if (WildFlySecurityManager.doCheck()) {
            super.checkMulticast(maddr, ttl);
        }
    }

    @Override
    public void checkPropertiesAccess() {
        if (WildFlySecurityManager.doCheck()) {
            super.checkPropertiesAccess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkPropertyAccess(String key) {
        Context ctx = CTX.get();
        if (WildFlySecurityManager.doCheck(ctx)) {
            ClassLoader objectClassLoader;
            ClassLoader classLoader;
            ProtectionDomain protectionDomain;
            Class<?>[] context = this.getClassContext();
            if (context.length < 3) {
                super.checkPropertyAccess(key);
                return;
            }
            if (context[1] != System.class) {
                super.checkPropertyAccess(key);
                return;
            }
            Class<?> testClass = context[2];
            if (context.length >= 4) {
                for (int i = 2; i < context.length && (context[i] == Boolean.class || context[i] == Integer.class || context[i] == Long.class); ++i) {
                    testClass = context[i + 1];
                }
            }
            ctx.entered = true;
            try {
                protectionDomain = testClass.getProtectionDomain();
                classLoader = testClass.getClassLoader();
                objectClassLoader = Object.class.getClassLoader();
            }
            finally {
                ctx.entered = false;
            }
            if (classLoader == objectClassLoader) {
                super.checkPropertyAccess(key);
                return;
            }
            PropertyPermission permission = new PropertyPermission(key, "read");
            if (protectionDomain.implies(permission)) {
                return;
            }
            this.checkPermission((Permission)permission, AccessController.getContext());
        }
    }

    @Override
    public void checkPrintJobAccess() {
        if (WildFlySecurityManager.doCheck()) {
            super.checkPrintJobAccess();
        }
    }

    @Override
    public void checkPackageAccess(String pkg) {
        if (WildFlySecurityManager.doCheck()) {
            super.checkPackageAccess(pkg);
        }
    }

    @Override
    public void checkPackageDefinition(String pkg) {
        if (WildFlySecurityManager.doCheck()) {
            super.checkPackageDefinition(pkg);
        }
    }

    @Override
    public void checkSetFactory() {
        if (WildFlySecurityManager.doCheck()) {
            super.checkSetFactory();
        }
    }

    private static boolean isAssignableToOneOf(Class<?> test, Class<?> ... expect) {
        for (Class<?> clazz : expect) {
            if (!clazz.isAssignableFrom(test)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkMemberAccess(Class<?> clazz, int which) {
        Context ctx = CTX.get();
        if (WildFlySecurityManager.doCheck(ctx)) {
            if (clazz == null) {
                throw new NullPointerException("class can't be null");
            }
            if (which != 0) {
                Class<?>[] context = this.getClassContext();
                int depth = context.length;
                if (depth >= 4 && context[1] == Class.class && context[2] == Class.class) {
                    ctx.entered = true;
                    try {
                        ClassLoader objectClassLoader = Object.class.getClassLoader();
                        ClassLoader clazzClassLoader = clazz.getClassLoader();
                        for (int i = 3; i < depth; ++i) {
                            ClassLoader classLoader = context[i].getClassLoader();
                            if (classLoader == objectClassLoader) {
                                if (WildFlySecurityManager.isAssignableToOneOf(context[i], ATOMIC_FIELD_UPDATER_TYPES)) continue;
                                this.checkPermission(ACCESS_DECLARED_MEMBERS_PERMISSION);
                                return;
                            }
                            if (clazzClassLoader == classLoader) {
                                return;
                            }
                            this.checkPermission(ACCESS_DECLARED_MEMBERS_PERMISSION);
                            return;
                        }
                    }
                    finally {
                        ctx.entered = false;
                    }
                }
                this.checkPermission(ACCESS_DECLARED_MEMBERS_PERMISSION);
            }
        }
    }

    @Override
    public void checkSecurityAccess(String target) {
        if (WildFlySecurityManager.doCheck()) {
            super.checkSecurityAccess(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T doChecked(PrivilegedAction<T> action) {
        Context ctx = CTX.get();
        if (ctx.checking) {
            return action.run();
        }
        ctx.checking = true;
        try {
            T t = action.run();
            return t;
        }
        finally {
            ctx.checking = false;
        }
    }

    public static <T> T doChecked(PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        Context ctx = CTX.get();
        if (ctx.checking) {
            try {
                return action.run();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PrivilegedActionException(e);
            }
        }
        ctx.checking = true;
        try {
            T e = action.run();
            return e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PrivilegedActionException(e);
        }
        finally {
            ctx.checking = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T doChecked(PrivilegedAction<T> action, AccessControlContext context) {
        Context ctx = CTX.get();
        if (ctx.checking) {
            return action.run();
        }
        ctx.checking = true;
        try {
            T t = AccessController.doPrivileged(action, context);
            return t;
        }
        finally {
            ctx.checking = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T doChecked(PrivilegedExceptionAction<T> action, AccessControlContext context) throws PrivilegedActionException {
        Context ctx = CTX.get();
        if (ctx.checking) {
            try {
                return action.run();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PrivilegedActionException(e);
            }
        }
        ctx.checking = true;
        try {
            T t = AccessController.doPrivileged(action, context);
            return t;
        }
        finally {
            ctx.checking = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, P> T doChecked(P parameter, ParametricPrivilegedAction<T, P> action) {
        Context ctx = CTX.get();
        if (ctx.checking) {
            return action.run(parameter);
        }
        ctx.checking = true;
        try {
            T t = action.run(parameter);
            return t;
        }
        finally {
            ctx.checking = false;
        }
    }

    public static <T, P> T doChecked(P parameter, ParametricPrivilegedExceptionAction<T, P> action) throws PrivilegedActionException {
        Context ctx = CTX.get();
        if (ctx.checking) {
            try {
                return action.run(parameter);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PrivilegedActionException(e);
            }
        }
        ctx.checking = true;
        try {
            T e = action.run(parameter);
            return e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PrivilegedActionException(e);
        }
        finally {
            ctx.checking = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, P> T doChecked(P parameter, ParametricPrivilegedAction<T, P> action, AccessControlContext context) {
        Context ctx = CTX.get();
        if (ctx.checking) {
            return action.run(parameter);
        }
        ctx.checking = true;
        try {
            T t = WildFlySecurityManager.doPrivilegedWithParameter(parameter, action, context);
            return t;
        }
        finally {
            ctx.checking = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, P> T doChecked(P parameter, ParametricPrivilegedExceptionAction<T, P> action, AccessControlContext context) throws PrivilegedActionException {
        Context ctx = CTX.get();
        if (ctx.checking) {
            try {
                return action.run(parameter);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PrivilegedActionException(e);
            }
        }
        ctx.checking = true;
        try {
            T t = WildFlySecurityManager.doPrivilegedWithParameter(parameter, action, context);
            return t;
        }
        finally {
            ctx.checking = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T doUnchecked(PrivilegedAction<T> action) {
        Context ctx = CTX.get();
        if (!ctx.checking) {
            return action.run();
        }
        ctx.checking = false;
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                WildFlySecurityManager.checkPDPermission(WildFlySecurityManager.getCallerClass(2), WildFlySecurityManagerPermission.DO_UNCHECKED_PERMISSION);
            }
            T t = action.run();
            return t;
        }
        finally {
            ctx.checking = true;
        }
    }

    public static <T> T doUnchecked(PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        Context ctx = CTX.get();
        if (!ctx.checking) {
            try {
                return action.run();
            }
            catch (Exception e) {
                throw new PrivilegedActionException(e);
            }
        }
        ctx.checking = false;
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                WildFlySecurityManager.checkPDPermission(WildFlySecurityManager.getCallerClass(2), WildFlySecurityManagerPermission.DO_UNCHECKED_PERMISSION);
            }
            T t = action.run();
            return t;
        }
        catch (Exception e) {
            throw new PrivilegedActionException(e);
        }
        finally {
            ctx.checking = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T doUnchecked(PrivilegedAction<T> action, AccessControlContext context) {
        Context ctx = CTX.get();
        if (!ctx.checking) {
            return AccessController.doPrivileged(action, context);
        }
        ctx.checking = false;
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                WildFlySecurityManager.checkPDPermission(WildFlySecurityManager.getCallerClass(2), WildFlySecurityManagerPermission.DO_UNCHECKED_PERMISSION);
            }
            T t = AccessController.doPrivileged(action, context);
            return t;
        }
        finally {
            ctx.checking = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T doUnchecked(PrivilegedExceptionAction<T> action, AccessControlContext context) throws PrivilegedActionException {
        Context ctx = CTX.get();
        if (!ctx.checking) {
            return AccessController.doPrivileged(action, context);
        }
        ctx.checking = false;
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                WildFlySecurityManager.checkPDPermission(WildFlySecurityManager.getCallerClass(2), WildFlySecurityManagerPermission.DO_UNCHECKED_PERMISSION);
            }
            T t = AccessController.doPrivileged(action, context);
            return t;
        }
        finally {
            ctx.checking = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, P> T doUnchecked(P parameter, ParametricPrivilegedAction<T, P> action) {
        Context ctx = CTX.get();
        if (!ctx.checking) {
            return action.run(parameter);
        }
        ctx.checking = false;
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                WildFlySecurityManager.checkPDPermission(WildFlySecurityManager.getCallerClass(2), WildFlySecurityManagerPermission.DO_UNCHECKED_PERMISSION);
            }
            T t = action.run(parameter);
            return t;
        }
        finally {
            ctx.checking = true;
        }
    }

    public static <T, P> T doUnchecked(P parameter, ParametricPrivilegedExceptionAction<T, P> action) throws PrivilegedActionException {
        Context ctx = CTX.get();
        if (!ctx.checking) {
            try {
                return action.run(parameter);
            }
            catch (Exception e) {
                throw new PrivilegedActionException(e);
            }
        }
        ctx.checking = false;
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                WildFlySecurityManager.checkPDPermission(WildFlySecurityManager.getCallerClass(2), WildFlySecurityManagerPermission.DO_UNCHECKED_PERMISSION);
            }
            T t = action.run(parameter);
            return t;
        }
        catch (Exception e) {
            throw new PrivilegedActionException(e);
        }
        finally {
            ctx.checking = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, P> T doUnchecked(P parameter, ParametricPrivilegedAction<T, P> action, AccessControlContext context) {
        Context ctx = CTX.get();
        if (!ctx.checking) {
            return WildFlySecurityManager.doPrivilegedWithParameter(parameter, action, context);
        }
        ctx.checking = false;
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                WildFlySecurityManager.checkPDPermission(WildFlySecurityManager.getCallerClass(2), WildFlySecurityManagerPermission.DO_UNCHECKED_PERMISSION);
            }
            T t = WildFlySecurityManager.doPrivilegedWithParameter(parameter, action, context);
            return t;
        }
        finally {
            ctx.checking = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, P> T doUnchecked(P parameter, ParametricPrivilegedExceptionAction<T, P> action, AccessControlContext context) throws PrivilegedActionException {
        Context ctx = CTX.get();
        if (!ctx.checking) {
            return WildFlySecurityManager.doPrivilegedWithParameter(parameter, action, context);
        }
        ctx.checking = false;
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                WildFlySecurityManager.checkPDPermission(WildFlySecurityManager.getCallerClass(2), WildFlySecurityManagerPermission.DO_UNCHECKED_PERMISSION);
            }
            T t = WildFlySecurityManager.doPrivilegedWithParameter(parameter, action, context);
            return t;
        }
        finally {
            ctx.checking = true;
        }
    }

    private static void checkPropertyReadPermission(Class<?> clazz, String propertyName) {
        ClassLoader classLoader;
        ProtectionDomain protectionDomain;
        if (System.getSecurityManager() instanceof WildFlySecurityManager) {
            protectionDomain = clazz.getProtectionDomain();
            classLoader = clazz.getClassLoader();
        } else {
            protectionDomain = AccessController.doPrivileged(new GetProtectionDomainAction(clazz));
            classLoader = AccessController.doPrivileged(new GetClassLoaderAction(clazz));
        }
        if (protectionDomain.implies(PROPERTIES_PERMISSION)) {
            return;
        }
        PropertyPermission permission = new PropertyPermission(propertyName, "read");
        if (protectionDomain.implies(permission)) {
            return;
        }
        SecurityMessages.access.accessCheckFailed(permission, protectionDomain.getCodeSource(), classLoader);
        throw SecurityMessages.access.accessControlException(permission, permission, protectionDomain.getCodeSource(), classLoader);
    }

    private static void checkEnvPropertyReadPermission(Class<?> clazz, String propertyName) {
        ClassLoader classLoader;
        ProtectionDomain protectionDomain;
        if (System.getSecurityManager() instanceof WildFlySecurityManager) {
            protectionDomain = clazz.getProtectionDomain();
            classLoader = clazz.getClassLoader();
        } else {
            protectionDomain = AccessController.doPrivileged(new GetProtectionDomainAction(clazz));
            classLoader = AccessController.doPrivileged(new GetClassLoaderAction(clazz));
        }
        if (protectionDomain.implies(ENVIRONMENT_PERMISSION)) {
            return;
        }
        RuntimePermission permission = new RuntimePermission("getenv." + propertyName);
        if (protectionDomain.implies(permission)) {
            return;
        }
        SecurityMessages.access.accessCheckFailed(permission, protectionDomain.getCodeSource(), classLoader);
        throw SecurityMessages.access.accessControlException(permission, permission, protectionDomain.getCodeSource(), classLoader);
    }

    private static void checkPropertyWritePermission(Class<?> clazz, String propertyName) {
        ClassLoader classLoader;
        ProtectionDomain protectionDomain;
        if (System.getSecurityManager() instanceof WildFlySecurityManager) {
            protectionDomain = clazz.getProtectionDomain();
            classLoader = clazz.getClassLoader();
        } else {
            protectionDomain = AccessController.doPrivileged(new GetProtectionDomainAction(clazz));
            classLoader = AccessController.doPrivileged(new GetClassLoaderAction(clazz));
        }
        if (protectionDomain.implies(PROPERTIES_PERMISSION)) {
            return;
        }
        PropertyPermission permission = new PropertyPermission(propertyName, "write");
        if (protectionDomain.implies(permission)) {
            return;
        }
        SecurityMessages.access.accessCheckFailed(permission, protectionDomain.getCodeSource(), classLoader);
        throw SecurityMessages.access.accessControlException(permission, permission, protectionDomain.getCodeSource(), classLoader);
    }

    private static void checkPDPermission(Class<?> clazz, Permission permission) {
        ClassLoader classLoader;
        ProtectionDomain protectionDomain;
        if (System.getSecurityManager() instanceof WildFlySecurityManager) {
            protectionDomain = clazz.getProtectionDomain();
            classLoader = clazz.getClassLoader();
        } else {
            protectionDomain = AccessController.doPrivileged(new GetProtectionDomainAction(clazz));
            classLoader = AccessController.doPrivileged(new GetClassLoaderAction(clazz));
        }
        if (protectionDomain.implies(permission)) {
            return;
        }
        SecurityMessages.access.accessCheckFailed(permission, protectionDomain.getCodeSource(), classLoader);
        throw SecurityMessages.access.accessControlException(permission, permission, protectionDomain.getCodeSource(), classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPropertyPrivileged(String name, String def) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return System.getProperty(name, def);
        }
        if (sm instanceof WildFlySecurityManager) {
            Context ctx = CTX.get();
            if (!ctx.checking) {
                return System.getProperty(name, def);
            }
            ctx.checking = false;
            try {
                WildFlySecurityManager.checkPropertyReadPermission(WildFlySecurityManager.getCallerClass(2), name);
                String string = System.getProperty(name, def);
                return string;
            }
            finally {
                ctx.checking = true;
            }
        }
        WildFlySecurityManager.checkPropertyReadPermission(WildFlySecurityManager.getCallerClass(2), name);
        return AccessController.doPrivileged(new ReadPropertyAction(name, def));
    }

    private static <T> T def(T test, T def) {
        return test == null ? def : test;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getEnvPropertyPrivileged(String name, String def) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return System.getenv(name);
        }
        if (sm instanceof WildFlySecurityManager) {
            Context ctx = CTX.get();
            if (!ctx.checking) {
                return WildFlySecurityManager.def(System.getenv(name), def);
            }
            ctx.checking = false;
            try {
                WildFlySecurityManager.checkEnvPropertyReadPermission(WildFlySecurityManager.getCallerClass(2), name);
                String string = WildFlySecurityManager.def(System.getenv(name), def);
                return string;
            }
            finally {
                ctx.checking = true;
            }
        }
        WildFlySecurityManager.checkEnvPropertyReadPermission(WildFlySecurityManager.getCallerClass(2), name);
        return AccessController.doPrivileged(new ReadEnvironmentPropertyAction(name, def));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String setPropertyPrivileged(String name, String value) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return System.setProperty(name, value);
        }
        if (sm instanceof WildFlySecurityManager) {
            Context ctx = CTX.get();
            if (!ctx.checking) {
                return System.setProperty(name, value);
            }
            ctx.checking = false;
            try {
                WildFlySecurityManager.checkPropertyWritePermission(WildFlySecurityManager.getCallerClass(2), name);
                String string = System.setProperty(name, value);
                return string;
            }
            finally {
                ctx.checking = true;
            }
        }
        WildFlySecurityManager.checkPropertyWritePermission(WildFlySecurityManager.getCallerClass(2), name);
        return AccessController.doPrivileged(new WritePropertyAction(name, value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String clearPropertyPrivileged(String name) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return System.clearProperty(name);
        }
        if (sm instanceof WildFlySecurityManager) {
            Context ctx = CTX.get();
            if (!ctx.checking) {
                return System.clearProperty(name);
            }
            ctx.checking = false;
            try {
                WildFlySecurityManager.checkPropertyWritePermission(WildFlySecurityManager.getCallerClass(2), name);
                String string = System.clearProperty(name);
                return string;
            }
            finally {
                ctx.checking = true;
            }
        }
        WildFlySecurityManager.checkPropertyWritePermission(WildFlySecurityManager.getCallerClass(2), name);
        return AccessController.doPrivileged(new ClearPropertyAction(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassLoader getCurrentContextClassLoaderPrivileged() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        if (sm instanceof WildFlySecurityManager) {
            Context ctx = CTX.get();
            if (!ctx.checking) {
                return Thread.currentThread().getContextClassLoader();
            }
            ctx.checking = false;
            try {
                WildFlySecurityManager.checkPDPermission(WildFlySecurityManager.getCallerClass(2), GET_CLASS_LOADER_PERMISSION);
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                return classLoader;
            }
            finally {
                ctx.checking = true;
            }
        }
        WildFlySecurityManager.checkPDPermission(WildFlySecurityManager.getCallerClass(2), GET_CLASS_LOADER_PERMISSION);
        return AccessController.doPrivileged(GetContextClassLoaderAction.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassLoader setCurrentContextClassLoaderPrivileged(ClassLoader newClassLoader) {
        SecurityManager sm = System.getSecurityManager();
        Thread thread = Thread.currentThread();
        if (sm == null) {
            try {
                ClassLoader classLoader = thread.getContextClassLoader();
                return classLoader;
            }
            finally {
                thread.setContextClassLoader(newClassLoader);
            }
        }
        if (sm instanceof WildFlySecurityManager) {
            Context ctx = CTX.get();
            if (!ctx.checking) {
                try {
                    ClassLoader classLoader = thread.getContextClassLoader();
                    return classLoader;
                }
                finally {
                    thread.setContextClassLoader(newClassLoader);
                }
            }
            ctx.checking = false;
            try {
                WildFlySecurityManager.checkPDPermission(WildFlySecurityManager.getCallerClass(2), SET_CLASS_LOADER_PERMISSION);
                try {
                    ClassLoader classLoader = thread.getContextClassLoader();
                    thread.setContextClassLoader(newClassLoader);
                    return classLoader;
                }
                catch (Throwable throwable) {
                    thread.setContextClassLoader(newClassLoader);
                    throw throwable;
                }
            }
            finally {
                ctx.checking = true;
            }
        }
        WildFlySecurityManager.checkPDPermission(WildFlySecurityManager.getCallerClass(2), SET_CLASS_LOADER_PERMISSION);
        return AccessController.doPrivileged(new SetContextClassLoaderAction(newClassLoader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassLoader setCurrentContextClassLoaderPrivileged(Class<?> clazz) {
        SecurityManager sm = System.getSecurityManager();
        Thread thread = Thread.currentThread();
        if (sm == null) {
            try {
                ClassLoader classLoader = thread.getContextClassLoader();
                return classLoader;
            }
            finally {
                thread.setContextClassLoader(clazz.getClassLoader());
            }
        }
        if (sm instanceof WildFlySecurityManager) {
            Context ctx = CTX.get();
            if (!ctx.checking) {
                try {
                    ClassLoader classLoader = thread.getContextClassLoader();
                    return classLoader;
                }
                finally {
                    thread.setContextClassLoader(clazz.getClassLoader());
                }
            }
            ctx.checking = false;
            try {
                Class<?> caller = WildFlySecurityManager.getCallerClass(2);
                WildFlySecurityManager.checkPDPermission(caller, SET_CLASS_LOADER_PERMISSION);
                WildFlySecurityManager.checkPDPermission(caller, GET_CLASS_LOADER_PERMISSION);
                try {
                    ClassLoader classLoader = thread.getContextClassLoader();
                    thread.setContextClassLoader(clazz.getClassLoader());
                    return classLoader;
                }
                catch (Throwable throwable) {
                    thread.setContextClassLoader(clazz.getClassLoader());
                    throw throwable;
                }
            }
            finally {
                ctx.checking = true;
            }
        }
        Class<?> caller = WildFlySecurityManager.getCallerClass(2);
        WildFlySecurityManager.checkPDPermission(caller, SET_CLASS_LOADER_PERMISSION);
        WildFlySecurityManager.checkPDPermission(caller, GET_CLASS_LOADER_PERMISSION);
        return AccessController.doPrivileged(new SetContextClassLoaderAction(clazz.getClassLoader()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getSystemPropertiesPrivileged() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return System.getProperties();
        }
        if (sm instanceof WildFlySecurityManager) {
            Context ctx = CTX.get();
            if (!ctx.checking) {
                return System.getProperties();
            }
            ctx.checking = false;
            try {
                WildFlySecurityManager.checkPDPermission(WildFlySecurityManager.getCallerClass(2), PROPERTIES_PERMISSION);
                Properties properties = System.getProperties();
                return properties;
            }
            finally {
                ctx.checking = true;
            }
        }
        WildFlySecurityManager.checkPDPermission(WildFlySecurityManager.getCallerClass(2), PROPERTIES_PERMISSION);
        return AccessController.doPrivileged(GetSystemPropertiesAction.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getSystemEnvironmentPrivileged() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return System.getenv();
        }
        if (sm instanceof WildFlySecurityManager) {
            Context ctx = CTX.get();
            if (!ctx.checking) {
                return System.getenv();
            }
            ctx.checking = false;
            try {
                WildFlySecurityManager.checkPDPermission(WildFlySecurityManager.getCallerClass(2), ENVIRONMENT_PERMISSION);
                Map<String, String> map = System.getenv();
                return map;
            }
            finally {
                ctx.checking = true;
            }
        }
        WildFlySecurityManager.checkPDPermission(WildFlySecurityManager.getCallerClass(2), ENVIRONMENT_PERMISSION);
        return AccessController.doPrivileged(GetEnvironmentAction.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassLoader getClassLoaderPrivileged(Class<?> clazz) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return clazz.getClassLoader();
        }
        if (sm instanceof WildFlySecurityManager) {
            Context ctx = CTX.get();
            if (!ctx.checking) {
                return clazz.getClassLoader();
            }
            ctx.checking = false;
            try {
                WildFlySecurityManager.checkPDPermission(WildFlySecurityManager.getCallerClass(2), GET_CLASS_LOADER_PERMISSION);
                ClassLoader classLoader = clazz.getClassLoader();
                return classLoader;
            }
            finally {
                ctx.checking = true;
            }
        }
        WildFlySecurityManager.checkPDPermission(WildFlySecurityManager.getCallerClass(2), GET_CLASS_LOADER_PERMISSION);
        return AccessController.doPrivileged(new GetClassLoaderAction(clazz));
    }

    public static <T, P> T doPrivilegedWithParameter(P parameter, ParametricPrivilegedAction<T, P> action) {
        Context ctx = CTX.get();
        ctx.action1 = action;
        ctx.parameter = parameter;
        return (T)AccessController.doPrivileged(PA_TRAMPOLINE1, ACC_CACHE.get(WildFlySecurityManager.getCallerClass(2)));
    }

    public static <T, P> T doPrivilegedWithParameter(P parameter, ParametricPrivilegedExceptionAction<T, P> action) throws PrivilegedActionException {
        Context ctx = CTX.get();
        ctx.action2 = action;
        ctx.parameter = parameter;
        return (T)AccessController.doPrivileged(PA_TRAMPOLINE2, ACC_CACHE.get(WildFlySecurityManager.getCallerClass(2)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, P> T doPrivilegedWithParameter(P parameter, ParametricPrivilegedAction<T, P> action, AccessControlContext accessControlContext) {
        AccessControlContext combined;
        Context ctx = CTX.get();
        ctx.action1 = action;
        ctx.parameter = parameter;
        ctx.entered = true;
        try {
            ProtectionDomain[] protectionDomainStack = WildFlySecurityManager.getProtectionDomainStack(accessControlContext);
            if (protectionDomainStack == null || protectionDomainStack.length == 0) {
                combined = ACC_CACHE.get(WildFlySecurityManager.getCallerClass(2));
            } else {
                ProtectionDomain[] finalDomains = Arrays.copyOf(protectionDomainStack, protectionDomainStack.length + 1);
                finalDomains[protectionDomainStack.length] = WildFlySecurityManager.getCallerClass(2).getProtectionDomain();
                combined = new AccessControlContext(finalDomains);
            }
        }
        finally {
            ctx.entered = false;
        }
        return (T)AccessController.doPrivileged(PA_TRAMPOLINE1, combined);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, P> T doPrivilegedWithParameter(P parameter, ParametricPrivilegedExceptionAction<T, P> action, AccessControlContext accessControlContext) throws PrivilegedActionException {
        AccessControlContext combined;
        Context ctx = CTX.get();
        ctx.action2 = action;
        ctx.parameter = parameter;
        ctx.entered = true;
        try {
            ProtectionDomain[] protectionDomainStack = WildFlySecurityManager.getProtectionDomainStack(accessControlContext);
            if (protectionDomainStack == null || protectionDomainStack.length == 0) {
                combined = ACC_CACHE.get(WildFlySecurityManager.getCallerClass(2));
            } else {
                ProtectionDomain[] finalDomains = Arrays.copyOf(protectionDomainStack, protectionDomainStack.length + 1);
                finalDomains[protectionDomainStack.length] = WildFlySecurityManager.getCallerClass(2).getProtectionDomain();
                combined = new AccessControlContext(finalDomains);
            }
        }
        finally {
            ctx.entered = false;
        }
        return (T)AccessController.doPrivileged(PA_TRAMPOLINE1, combined);
    }

    static {
        boolean result = false;
        int offset = 0;
        try {
            result = Reflection.getCallerClass((int)1) == WildFlySecurityManager.class || Reflection.getCallerClass((int)2) == WildFlySecurityManager.class;
            offset = Reflection.getCallerClass((int)1) == Reflection.class ? 2 : 1;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        hasGetCallerClass = result;
        callerOffset = offset;
        ACCESS_DECLARED_MEMBERS_PERMISSION = new RuntimePermission("accessDeclaredMembers");
        ATOMIC_FIELD_UPDATER_TYPES = new Class[]{AtomicReferenceFieldUpdater.class, AtomicLongFieldUpdater.class, AtomicIntegerFieldUpdater.class};
        ACC_CACHE = new ClassValue<AccessControlContext>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected AccessControlContext computeValue(Class<?> type) {
                Context ctx = (Context)CTX.get();
                assert (!ctx.entered);
                ctx.entered = true;
                try {
                    AccessControlContext accessControlContext = new AccessControlContext(new ProtectionDomain[]{type.getProtectionDomain()});
                    return accessControlContext;
                }
                finally {
                    ctx.entered = false;
                }
            }
        };
        PA_TRAMPOLINE1 = new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Context ctx = (Context)CTX.get();
                ParametricPrivilegedAction<Object, Object> a = ctx.action1;
                Object p = ctx.parameter;
                ctx.action1 = null;
                ctx.parameter = null;
                return a.run(p);
            }
        };
        PA_TRAMPOLINE2 = new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                Context ctx = (Context)CTX.get();
                ParametricPrivilegedExceptionAction<Object, Object> a = ctx.action2;
                Object p = ctx.parameter;
                ctx.action2 = null;
                ctx.parameter = null;
                return a.run(p);
            }
        };
    }

    static class Context {
        boolean checking = true;
        boolean entered = false;
        ParametricPrivilegedAction<Object, Object> action1;
        ParametricPrivilegedExceptionAction<Object, Object> action2;
        Object parameter;

        Context() {
        }
    }
}

