/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.webhooks;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.tomakehurst.wiremock.http.Body;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.List;

public class WebhookDefinition {
    private RequestMethod method;
    private URI url;
    private List<HttpHeader> headers;
    private Body body = Body.none();

    @JsonCreator
    public WebhookDefinition(@JsonProperty(value="method") RequestMethod method, @JsonProperty(value="url") URI url, @JsonProperty(value="headers") HttpHeaders headers, @JsonProperty(value="body") String body, @JsonProperty(value="base64Body") String base64Body) {
        this.method = method;
        this.url = url;
        this.headers = Lists.newArrayList((Iterable)headers.all());
        this.body = Body.fromOneOf(null, (String)body, null, (String)base64Body);
    }

    public WebhookDefinition() {
    }

    public RequestMethod getMethod() {
        return this.method;
    }

    public URI getUrl() {
        return this.url;
    }

    public HttpHeaders getHeaders() {
        return new HttpHeaders(this.headers);
    }

    public String getBase64Body() {
        return this.body.isBinary() ? this.body.asBase64() : null;
    }

    public String getBody() {
        return this.body.isBinary() ? null : this.body.asString();
    }

    @JsonIgnore
    public byte[] getBinaryBody() {
        return this.body.asBytes();
    }

    public WebhookDefinition withMethod(RequestMethod method) {
        this.method = method;
        return this;
    }

    public WebhookDefinition withUrl(URI url) {
        this.url = url;
        return this;
    }

    public WebhookDefinition withUrl(String url) {
        this.withUrl(URI.create(url));
        return this;
    }

    public WebhookDefinition withHeaders(List<HttpHeader> headers) {
        this.headers = headers;
        return this;
    }

    public WebhookDefinition withHeader(String key, String ... values) {
        if (this.headers == null) {
            this.headers = Lists.newArrayList();
        }
        this.headers.add(new HttpHeader(key, values));
        return this;
    }

    public WebhookDefinition withBody(String body) {
        this.body = new Body(body);
        return this;
    }

    public WebhookDefinition withBinaryBody(byte[] body) {
        this.body = new Body(body);
        return this;
    }
}

