/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.webhooks;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.extension.PostServeAction;
import com.github.tomakehurst.wiremock.http.HttpClientFactory;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.wiremock.webhooks.WebhookDefinition;
import org.wiremock.webhooks.interceptors.WebhookTransformer;

public class Webhooks
extends PostServeAction {
    private final ScheduledExecutorService scheduler;
    private final HttpClient httpClient;
    private final List<WebhookTransformer> transformers;

    private Webhooks(ScheduledExecutorService scheduler, HttpClient httpClient, List<WebhookTransformer> transformers) {
        this.scheduler = scheduler;
        this.httpClient = httpClient;
        this.transformers = transformers;
    }

    public Webhooks() {
        this(Executors.newScheduledThreadPool(10), (HttpClient)HttpClientFactory.createClient(), new ArrayList<WebhookTransformer>());
    }

    public Webhooks(WebhookTransformer ... transformers) {
        this(Executors.newScheduledThreadPool(10), (HttpClient)HttpClientFactory.createClient(), Arrays.asList(transformers));
    }

    public String getName() {
        return "webhook";
    }

    public void doAction(final ServeEvent serveEvent, Admin admin, final Parameters parameters) {
        final Notifier notifier = LocalNotifier.notifier();
        this.scheduler.schedule(new Runnable(){

            @Override
            public void run() {
                WebhookDefinition definition = (WebhookDefinition)parameters.as(WebhookDefinition.class);
                for (WebhookTransformer transformer : Webhooks.this.transformers) {
                    definition = transformer.transform(serveEvent, definition);
                }
                HttpUriRequest request = Webhooks.buildRequest(definition);
                try {
                    HttpResponse response = Webhooks.this.httpClient.execute(request);
                    notifier.info(String.format("Webhook %s request to %s returned status %s\n\n%s", definition.getMethod(), definition.getUrl(), response.getStatusLine(), EntityUtils.toString((HttpEntity)response.getEntity())));
                }
                catch (IOException e) {
                    Exceptions.throwUnchecked((Throwable)e);
                }
            }
        }, 0L, TimeUnit.SECONDS);
    }

    private static HttpUriRequest buildRequest(WebhookDefinition definition) {
        HttpUriRequest request = HttpClientFactory.getHttpRequestFor((RequestMethod)definition.getMethod(), (String)definition.getUrl().toString());
        for (HttpHeader header : definition.getHeaders().all()) {
            request.addHeader(header.key(), header.firstValue());
        }
        if (definition.getMethod().hasEntity()) {
            HttpEntityEnclosingRequestBase entityRequest = (HttpEntityEnclosingRequestBase)request;
            entityRequest.setEntity((HttpEntity)new ByteArrayEntity(definition.getBinaryBody()));
        }
        return request;
    }

    public static WebhookDefinition webhook() {
        return new WebhookDefinition();
    }
}

