/*
 *  Copyright (c) 2020, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 *  WSO2 Inc. licenses this file to you under the Apache License,
 *  Version 2.0 (the "License"); you may not use this file except
 *  in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.wso2.micro.gateway.core.globalthrottle.databridge.agent.client;

/**
 * This abstract class needs to be implemented to handling secure communication with the endpoint.
 */
public abstract class AbstractSecureClientPoolFactory extends AbstractClientPoolFactory {

    private String trustStorePassword;

    private String trustStore;

    public AbstractSecureClientPoolFactory(String trustStore, String trustStorePassword) {
        this.trustStore = trustStore;
        this.trustStorePassword = trustStorePassword;
    }

    public String getTrustStorePassword() {
        return trustStorePassword;
    }

    public String getTrustStore() {
        return trustStore;
    }
}
