/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.cal10n.verifier;

import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cal10nError {
    final ErrorType errorType;
    final String key;
    final Locale locale;
    final Class<?> enumClass;
    final String enumClassName;
    final String baseName;

    Cal10nError(ErrorType errorType, String key, Class<?> enumClass, Locale locale, String baseName) {
        this.errorType = errorType;
        this.key = key;
        this.enumClass = enumClass;
        this.enumClassName = enumClass.getName();
        this.locale = locale;
        this.baseName = baseName;
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public String getKey() {
        return this.key;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Class<?> getEnumClass() {
        return this.enumClass;
    }

    public String toString() {
        switch (this.errorType) {
            case MISSING_BN_ANNOTATION: {
                return "Missing @BaseName annotation in enum type [" + this.enumClassName + "]";
            }
            case FAILED_TO_FIND_RB: {
                return "Failed to locate resource bundle [" + this.baseName + "] for locale [" + this.locale + "] for enum type [" + this.enumClassName + "]";
            }
            case EMPTY_RB: {
                return "Empty resource bundle named [" + this.baseName + "] for locale [" + this.locale + "]";
            }
            case EMPTY_ENUM: {
                return "Empty enum type [" + this.enumClassName + "]";
            }
            case ABSENT_IN_ENUM: {
                return "Key [" + this.key + "] present in resource bundle named [" + this.baseName + "] for locale [" + this.locale + "] but absent in enum type [" + this.enumClassName + "]";
            }
            case ABSENT_IN_RB: {
                return "Key [" + this.key + "] present in enum type [" + this.enumClassName + "] but absent in resource bundle named [" + this.baseName + "] for locale [" + this.locale + "]";
            }
        }
        throw new IllegalStateException("Impossible to reach here");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ErrorType {
        MISSING_BN_ANNOTATION,
        FAILED_TO_FIND_RB,
        EMPTY_RB,
        EMPTY_ENUM,
        ABSENT_IN_RB,
        ABSENT_IN_ENUM;

    }
}

