/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.exception;

import com.azure.core.amqp.exception.AmqpErrorCondition;
import com.azure.core.amqp.exception.AmqpErrorContext;
import com.azure.core.exception.AzureException;
import com.azure.core.util.CoreUtils;
import java.util.Locale;

public class AmqpException
extends AzureException {
    private static final long serialVersionUID = -3654294093967132325L;
    private final AmqpErrorContext errorContext;
    private final boolean isTransient;
    private final AmqpErrorCondition errorCondition;

    public AmqpException(boolean isTransient, String message, AmqpErrorContext errorContext) {
        this(isTransient, null, message, errorContext);
    }

    public AmqpException(boolean isTransient, AmqpErrorCondition errorCondition, String message, AmqpErrorContext errorContext) {
        super(message);
        this.errorCondition = errorCondition;
        this.isTransient = isTransient;
        this.errorContext = errorContext;
    }

    public AmqpException(boolean isTransient, AmqpErrorCondition errorCondition, String message, Throwable cause, AmqpErrorContext errorContext) {
        super(message, cause);
        this.errorCondition = errorCondition;
        this.isTransient = isTransient;
        this.errorContext = errorContext;
    }

    public AmqpException(boolean isTransient, AmqpErrorCondition errorCondition, Throwable cause, AmqpErrorContext errorContext) {
        super(cause.getMessage(), cause);
        this.errorCondition = errorCondition;
        this.isTransient = isTransient;
        this.errorContext = errorContext;
    }

    public AmqpException(boolean isTransient, String message, Throwable cause, AmqpErrorContext errorContext) {
        super(message, cause);
        this.errorCondition = null;
        this.isTransient = isTransient;
        this.errorContext = errorContext;
    }

    @Override
    public String getMessage() {
        String baseMessage = super.getMessage();
        if (this.errorContext == null) {
            return super.getMessage();
        }
        return !CoreUtils.isNullOrEmpty(baseMessage) ? String.format(Locale.US, "%s, %s[%s]", baseMessage, "errorContext", this.errorContext.toString()) : String.format(Locale.US, "%s[%s]", "errorContext", this.errorContext.toString());
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public AmqpErrorCondition getErrorCondition() {
        return this.errorCondition;
    }

    public AmqpErrorContext getContext() {
        return this.errorContext;
    }
}

