/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation;

import com.azure.core.amqp.exception.AmqpErrorCondition;
import com.azure.core.amqp.exception.AmqpErrorContext;
import com.azure.core.amqp.exception.AmqpException;
import com.azure.core.amqp.exception.AmqpResponseCode;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ExceptionUtil {
    private static final String AMQP_REQUEST_FAILED_ERROR = "status-code: %s, status-description: %s";
    private static final Pattern ENTITY_NOT_FOUND_PATTERN = Pattern.compile("The messaging entity .* could not be found");

    public static Exception toException(String errorCondition, String description, AmqpErrorContext errorContext) {
        boolean isTransient;
        if (errorCondition == null) {
            throw new IllegalArgumentException("'null' errorCondition cannot be translated to EventHubException");
        }
        AmqpErrorCondition condition = AmqpErrorCondition.fromString(errorCondition);
        if (condition == null) {
            return new AmqpException(false, String.format("errorCondition[%s]. description[%s]", errorCondition, description), errorContext);
        }
        switch (condition) {
            case TIMEOUT_ERROR: 
            case SERVER_BUSY_ERROR: 
            case INTERNAL_ERROR: 
            case LINK_DETACH_FORCED: 
            case CONNECTION_FORCED: 
            case CONNECTION_FRAMING_ERROR: 
            case PROTON_IO: {
                isTransient = true;
                break;
            }
            case ENTITY_DISABLED_ERROR: 
            case LINK_STOLEN: 
            case UNAUTHORIZED_ACCESS: 
            case LINK_PAYLOAD_SIZE_EXCEEDED: 
            case ARGUMENT_ERROR: 
            case ARGUMENT_OUT_OF_RANGE_ERROR: 
            case PARTITION_NOT_OWNED_ERROR: 
            case STORE_LOCK_LOST_ERROR: 
            case RESOURCE_LIMIT_EXCEEDED: 
            case OPERATION_CANCELLED: 
            case MESSAGE_LOCK_LOST: 
            case SESSION_LOCK_LOST: 
            case SESSION_CANNOT_BE_LOCKED: 
            case ENTITY_ALREADY_EXISTS: 
            case MESSAGE_NOT_FOUND: 
            case SESSION_NOT_FOUND: {
                isTransient = false;
                break;
            }
            case NOT_IMPLEMENTED: 
            case NOT_ALLOWED: {
                return new UnsupportedOperationException(description);
            }
            case NOT_FOUND: {
                return ExceptionUtil.distinguishNotFound(description, errorContext);
            }
            default: {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "This condition '%s' is not known.", new Object[]{condition}));
            }
        }
        return new AmqpException(isTransient, condition, description, errorContext);
    }

    public static Exception amqpResponseCodeToException(int statusCode, String statusDescription, AmqpErrorContext errorContext) {
        AmqpResponseCode amqpResponseCode = AmqpResponseCode.fromValue(statusCode);
        String message = String.format(AMQP_REQUEST_FAILED_ERROR, statusCode, statusDescription);
        if (amqpResponseCode == null) {
            return new AmqpException(true, message, errorContext);
        }
        switch (amqpResponseCode) {
            case BAD_REQUEST: {
                return new IllegalArgumentException(message);
            }
            case NOT_FOUND: {
                return ExceptionUtil.distinguishNotFound(statusDescription, errorContext);
            }
            case FORBIDDEN: {
                return new AmqpException(false, AmqpErrorCondition.RESOURCE_LIMIT_EXCEEDED, message, errorContext);
            }
            case UNAUTHORIZED: {
                return new AmqpException(false, AmqpErrorCondition.UNAUTHORIZED_ACCESS, message, errorContext);
            }
        }
        return new AmqpException(true, message, errorContext);
    }

    private static AmqpException distinguishNotFound(String message, AmqpErrorContext errorContext) {
        Matcher m3 = ENTITY_NOT_FOUND_PATTERN.matcher(message);
        if (m3.find()) {
            return new AmqpException(false, AmqpErrorCondition.NOT_FOUND, message, errorContext);
        }
        return new AmqpException(true, AmqpErrorCondition.NOT_FOUND, String.format(AMQP_REQUEST_FAILED_ERROR, new Object[]{AmqpResponseCode.NOT_FOUND, message}), errorContext);
    }
}

