/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation.handler;

import com.azure.core.amqp.exception.AmqpErrorContext;
import com.azure.core.amqp.exception.LinkErrorContext;
import com.azure.core.amqp.implementation.AmqpErrorCode;
import com.azure.core.amqp.implementation.ExceptionUtil;
import com.azure.core.amqp.implementation.handler.Handler;
import com.azure.core.util.logging.ClientLogger;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Link;

abstract class LinkHandler
extends Handler {
    private final String entityPath;
    final ClientLogger logger;

    LinkHandler(String connectionId, String hostname, String entityPath, ClientLogger logger) {
        super(connectionId, hostname);
        this.entityPath = entityPath;
        this.logger = logger;
    }

    @Override
    public void onLinkLocalClose(Event event) {
        Link link = event.getLink();
        ErrorCondition condition = link.getCondition();
        this.logger.info("onLinkLocalClose connectionId[{}], linkName[{}], errorCondition[{}], errorDescription[{}]", this.getConnectionId(), link.getName(), condition != null ? condition.getCondition() : "n/a", condition != null ? condition.getDescription() : "n/a");
    }

    @Override
    public void onLinkRemoteClose(Event event) {
        Link link = event.getLink();
        ErrorCondition condition = link.getRemoteCondition();
        this.logger.info("onLinkRemoteClose connectionId[{}], linkName[{}], errorCondition[{}], errorDescription[{}]", this.getConnectionId(), link.getName(), condition != null ? condition.getCondition() : "n/a", condition != null ? condition.getDescription() : "n/a");
        this.handleRemoteLinkClosed(event);
    }

    @Override
    public void onLinkRemoteDetach(Event event) {
        Link link = event.getLink();
        ErrorCondition condition = link.getCondition();
        this.logger.info("onLinkRemoteClose connectionId[{}], linkName[{}], errorCondition[{}], errorDescription[{}]", this.getConnectionId(), link.getName(), condition != null ? condition.getCondition() : "n/a", condition != null ? condition.getDescription() : "n/a");
        this.handleRemoteLinkClosed(event);
    }

    @Override
    public void onLinkFinal(Event event) {
        String linkName = event != null && event.getLink() != null ? event.getLink().getName() : "n/a";
        this.logger.info("onLinkFinal connectionId[{}], linkName[{}]", this.getConnectionId(), linkName);
        this.close();
    }

    public AmqpErrorContext getErrorContext(Link link) {
        String referenceId = link.getRemoteProperties() != null && link.getRemoteProperties().containsKey(AmqpErrorCode.TRACKING_ID_PROPERTY) ? link.getRemoteProperties().get(AmqpErrorCode.TRACKING_ID_PROPERTY).toString() : link.getName();
        return new LinkErrorContext(this.getHostname(), this.entityPath, referenceId, link.getCredit());
    }

    private void handleRemoteLinkClosed(Event event) {
        Link link = event.getLink();
        ErrorCondition condition = link.getRemoteCondition();
        if (link.getLocalState() != EndpointState.CLOSED) {
            link.setCondition(condition);
            link.close();
        }
        this.logger.info("processOnClose connectionId[{}], linkName[{}], errorCondition[{}], errorDescription[{}]", this.getConnectionId(), link.getName(), condition != null ? condition.getCondition() : "n/a", condition != null ? condition.getDescription() : "n/a");
        if (condition != null && condition.getCondition() != null) {
            Exception exception = ExceptionUtil.toException(condition.getCondition().toString(), condition.getDescription(), this.getErrorContext(link));
            this.onError(exception);
        } else {
            this.close();
        }
    }
}

