/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation.handler;

import com.azure.core.amqp.implementation.handler.LinkHandler;
import com.azure.core.util.logging.ClientLogger;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.qpid.proton.amqp.messaging.Modified;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Receiver;
import reactor.core.publisher.DirectProcessor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;

public class ReceiveLinkHandler
extends LinkHandler {
    private final String linkName;
    private final AtomicBoolean isFirstResponse = new AtomicBoolean(true);
    private final DirectProcessor<Delivery> deliveries;
    private final FluxSink<Delivery> deliverySink;
    private final Set<Delivery> queuedDeliveries = Collections.newSetFromMap(new ConcurrentHashMap());
    private final String entityPath;

    public ReceiveLinkHandler(String connectionId, String hostname, String linkName, String entityPath) {
        super(connectionId, hostname, entityPath, new ClientLogger(ReceiveLinkHandler.class));
        this.deliveries = DirectProcessor.create();
        this.deliverySink = this.deliveries.sink(FluxSink.OverflowStrategy.BUFFER);
        this.linkName = linkName;
        this.entityPath = entityPath;
    }

    public String getLinkName() {
        return this.linkName;
    }

    public Flux<Delivery> getDeliveredMessages() {
        return this.deliveries.doOnNext(delivery -> this.queuedDeliveries.remove(delivery));
    }

    @Override
    public void close() {
        this.deliverySink.complete();
        super.close();
        this.queuedDeliveries.forEach(delivery -> {
            delivery.disposition(new Modified());
            delivery.settle();
        });
        this.queuedDeliveries.clear();
    }

    @Override
    public void onLinkLocalOpen(Event event) {
        Link link = event.getLink();
        if (link instanceof Receiver) {
            this.logger.info("onLinkLocalOpen connectionId[{}], entityPath[{}], linkName[{}], localSource[{}]", this.getConnectionId(), this.entityPath, link.getName(), link.getSource());
        }
    }

    @Override
    public void onLinkRemoteOpen(Event event) {
        Link link = event.getLink();
        if (!(link instanceof Receiver)) {
            return;
        }
        if (link.getRemoteSource() != null) {
            this.logger.info("onLinkRemoteOpen connectionId[{}], entityPath[{}], linkName[{}], remoteSource[{}]", this.getConnectionId(), this.entityPath, link.getName(), link.getRemoteSource());
            if (this.isFirstResponse.getAndSet(false)) {
                this.onNext(EndpointState.ACTIVE);
            }
        } else {
            this.logger.info("onLinkRemoteOpen connectionId[{}], entityPath[{}], linkName[{}], action[waitingForError]", this.getConnectionId(), this.entityPath, link.getName());
        }
    }

    @Override
    public void onDelivery(Event event) {
        if (this.isFirstResponse.getAndSet(false)) {
            this.onNext(EndpointState.ACTIVE);
        }
        Delivery delivery = event.getDelivery();
        Receiver link = (Receiver)delivery.getLink();
        if (!delivery.isPartial()) {
            if (delivery.isSettled()) {
                if (link != null) {
                    this.logger.verbose("onDelivery connectionId[{}], entityPath[{}], linkName[{}], updatedLinkCredit[{}], remoteCredit[{}], remoteCondition[{}], delivery.isSettled[{}]", this.getConnectionId(), this.entityPath, link.getName(), link.getCredit(), link.getRemoteCredit(), link.getRemoteCondition(), delivery.isSettled());
                } else {
                    this.logger.warning("connectionId[{}], delivery.isSettled[{}]", this.getConnectionId(), delivery.isSettled());
                }
            } else if (link.getLocalState() == EndpointState.CLOSED) {
                delivery.disposition(new Modified());
                delivery.settle();
            } else {
                this.queuedDeliveries.add(delivery);
                this.deliverySink.next(delivery);
            }
        }
        if (link != null) {
            this.logger.verbose("onDelivery connectionId[{}], entityPath[{}], linkName[{}], updatedLinkCredit[{}],remoteCredit[{}], remoteCondition[{}], delivery.isPartial[{}]", this.getConnectionId(), this.entityPath, link.getName(), link.getCredit(), link.getRemoteCredit(), link.getRemoteCondition(), delivery.isPartial());
        }
    }

    @Override
    public void onLinkRemoteClose(Event event) {
        this.deliverySink.complete();
        super.onLinkRemoteClose(event);
    }
}

