/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.serializer;

import com.azure.core.annotation.HeaderCollection;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaders;
import com.azure.core.implementation.AccessibleByteArrayOutputStream;
import com.azure.core.implementation.TypeUtil;
import com.azure.core.implementation.serializer.MalformedValueException;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.AdditionalPropertiesDeserializer;
import com.azure.core.util.serializer.AdditionalPropertiesSerializer;
import com.azure.core.util.serializer.Base64UrlSerializer;
import com.azure.core.util.serializer.ByteArraySerializer;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.DateTimeDeserializer;
import com.azure.core.util.serializer.DateTimeRfc1123Serializer;
import com.azure.core.util.serializer.DateTimeSerializer;
import com.azure.core.util.serializer.DurationSerializer;
import com.azure.core.util.serializer.FlatteningDeserializer;
import com.azure.core.util.serializer.FlatteningSerializer;
import com.azure.core.util.serializer.HttpHeadersSerializer;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.core.util.serializer.UnixTimeSerializer;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;

public class JacksonAdapter
implements SerializerAdapter {
    private static final Pattern PATTERN = Pattern.compile("^\"*|\"*$");
    private final ClientLogger logger = new ClientLogger(JacksonAdapter.class);
    private final ObjectMapper mapper;
    private final ObjectMapper simpleMapper = JacksonAdapter.initializeObjectMapper(new ObjectMapper());
    private final ObjectMapper xmlMapper = JacksonAdapter.initializeObjectMapper(new XmlMapper()).setDefaultUseWrapper(false).configure(ToXmlGenerator.Feature.WRITE_XML_DECLARATION, true);
    private final ObjectMapper headerMapper;
    private static SerializerAdapter serializerAdapter;

    public JacksonAdapter() {
        ObjectMapper flatteningMapper = JacksonAdapter.initializeObjectMapper(new ObjectMapper()).registerModule(FlatteningSerializer.getModule(this.simpleMapper())).registerModule(FlatteningDeserializer.getModule(this.simpleMapper()));
        this.mapper = JacksonAdapter.initializeObjectMapper(new ObjectMapper()).registerModule(AdditionalPropertiesSerializer.getModule(flatteningMapper)).registerModule(AdditionalPropertiesDeserializer.getModule(flatteningMapper)).registerModule(FlatteningSerializer.getModule(this.simpleMapper())).registerModule(FlatteningDeserializer.getModule(this.simpleMapper()));
        this.headerMapper = this.simpleMapper.copy().configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
    }

    protected ObjectMapper simpleMapper() {
        return this.simpleMapper;
    }

    public static synchronized SerializerAdapter createDefaultSerializerAdapter() {
        if (serializerAdapter == null) {
            serializerAdapter = new JacksonAdapter();
        }
        return serializerAdapter;
    }

    public ObjectMapper serializer() {
        return this.mapper;
    }

    @Override
    public String serialize(Object object, SerializerEncoding encoding) throws IOException {
        if (object == null) {
            return null;
        }
        AccessibleByteArrayOutputStream stream = new AccessibleByteArrayOutputStream();
        this.serialize(object, encoding, stream);
        return new String(((ByteArrayOutputStream)stream).toByteArray(), 0, stream.size(), StandardCharsets.UTF_8);
    }

    @Override
    public void serialize(Object object, SerializerEncoding encoding, OutputStream outputStream) throws IOException {
        if (object == null) {
            return;
        }
        if (encoding == SerializerEncoding.XML) {
            this.xmlMapper.writeValue(outputStream, object);
        } else {
            this.serializer().writeValue(outputStream, object);
        }
    }

    @Override
    public String serializeRaw(Object object) {
        if (object == null) {
            return null;
        }
        try {
            return PATTERN.matcher(this.serialize(object, SerializerEncoding.JSON)).replaceAll("");
        }
        catch (IOException ex) {
            this.logger.warning("Failed to serialize {} to JSON.", object.getClass(), ex);
            return null;
        }
    }

    @Override
    public String serializeList(List<?> list, CollectionFormat format) {
        if (list == null) {
            return null;
        }
        ArrayList<String> serialized = new ArrayList<String>();
        for (Object element : list) {
            String raw = this.serializeRaw(element);
            serialized.add(raw != null ? raw : "");
        }
        return String.join((CharSequence)format.getDelimiter(), serialized);
    }

    @Override
    public <T> T deserialize(String value, Type type, SerializerEncoding encoding) throws IOException {
        if (CoreUtils.isNullOrEmpty(value)) {
            return null;
        }
        JavaType javaType = this.createJavaType(type);
        try {
            if (encoding == SerializerEncoding.XML) {
                return this.xmlMapper.readValue(value, javaType);
            }
            return this.serializer().readValue(value, javaType);
        }
        catch (JsonParseException jpe) {
            throw this.logger.logExceptionAsError(new MalformedValueException(jpe.getMessage(), jpe));
        }
    }

    @Override
    public <T> T deserialize(InputStream inputStream, Type type, SerializerEncoding encoding) throws IOException {
        if (inputStream == null) {
            return null;
        }
        JavaType javaType = this.createJavaType(type);
        try {
            if (encoding == SerializerEncoding.XML) {
                return this.xmlMapper.readValue(inputStream, javaType);
            }
            return this.serializer().readValue(inputStream, javaType);
        }
        catch (JsonParseException jpe) {
            throw this.logger.logExceptionAsError(new MalformedValueException(jpe.getMessage(), jpe));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T deserialize(HttpHeaders headers, Type deserializedHeadersType) throws IOException {
        Field[] declaredFields;
        if (deserializedHeadersType == null) {
            return null;
        }
        String headersJsonString = this.headerMapper.writeValueAsString(headers);
        Object deserializedHeaders = this.headerMapper.readValue(headersJsonString, this.createJavaType(deserializedHeadersType));
        Class<?> deserializedHeadersClass = TypeUtil.getRawClass(deserializedHeadersType);
        for (Field declaredField : declaredFields = deserializedHeadersClass.getDeclaredFields()) {
            HeaderCollection headerCollectionAnnotation;
            String headerCollectionPrefix;
            int headerCollectionPrefixLength;
            Type[] mapTypeArguments;
            if (!declaredField.isAnnotationPresent(HeaderCollection.class)) continue;
            Type declaredFieldType = declaredField.getGenericType();
            if (!TypeUtil.isTypeOrSubTypeOf(declaredField.getType(), Map.class) || (mapTypeArguments = TypeUtil.getTypeArguments(declaredFieldType)).length != 2 || mapTypeArguments[0] != String.class || mapTypeArguments[1] != String.class || (headerCollectionPrefixLength = (headerCollectionPrefix = (headerCollectionAnnotation = declaredField.getAnnotation(HeaderCollection.class)).value().toLowerCase(Locale.ROOT)).length()) <= 0) continue;
            HashMap<String, String> headerCollection = new HashMap<String, String>();
            for (HttpHeader header : headers) {
                String headerName = header.getName();
                if (!headerName.toLowerCase(Locale.ROOT).startsWith(headerCollectionPrefix)) continue;
                headerCollection.put(headerName.substring(headerCollectionPrefixLength), header.getValue());
            }
            boolean declaredFieldAccessibleBackup = declaredField.isAccessible();
            try {
                if (!declaredFieldAccessibleBackup) {
                    AccessController.doPrivileged(() -> {
                        declaredField.setAccessible(true);
                        return null;
                    });
                }
                declaredField.set(deserializedHeaders, headerCollection);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            finally {
                if (!declaredFieldAccessibleBackup) {
                    AccessController.doPrivileged(() -> {
                        declaredField.setAccessible(false);
                        return null;
                    });
                }
            }
        }
        return deserializedHeaders;
    }

    private static <T extends ObjectMapper> T initializeObjectMapper(T mapper) {
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).configure(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS, true).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true).setSerializationInclusion(JsonInclude.Include.NON_NULL).registerModule(new JavaTimeModule()).registerModule(ByteArraySerializer.getModule()).registerModule(Base64UrlSerializer.getModule()).registerModule(DateTimeSerializer.getModule()).registerModule(DateTimeDeserializer.getModule()).registerModule(DateTimeRfc1123Serializer.getModule()).registerModule(DurationSerializer.getModule()).registerModule(HttpHeadersSerializer.getModule()).registerModule(UnixTimeSerializer.getModule());
        mapper.setVisibility((VisibilityChecker<?>)mapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withIsGetterVisibility(JsonAutoDetect.Visibility.NONE));
        return mapper;
    }

    private JavaType createJavaType(Type type) {
        JavaType result;
        if (type == null) {
            result = null;
        } else if (type instanceof JavaType) {
            result = (JavaType)type;
        } else if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            JavaType[] javaTypeArguments = new JavaType[actualTypeArguments.length];
            for (int i = 0; i != actualTypeArguments.length; ++i) {
                javaTypeArguments[i] = this.createJavaType(actualTypeArguments[i]);
            }
            result = this.mapper.getTypeFactory().constructParametricType((Class)parameterizedType.getRawType(), javaTypeArguments);
        } else {
            result = this.mapper.getTypeFactory().constructType(type);
        }
        return result;
    }
}

