/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.dtd;

import com.ctc.wstx.dtd.DTDAttribute;
import com.ctc.wstx.dtd.DTDValidatorBase;
import com.ctc.wstx.dtd.DefaultAttrValue;
import com.ctc.wstx.dtd.ElementId;
import com.ctc.wstx.dtd.ElementIdMap;
import com.ctc.wstx.dtd.NameKey;
import com.ctc.wstx.io.WstxInputData;
import com.ctc.wstx.sr.InputProblemReporter;
import javax.xml.stream.Location;
import org.codehaus.stax2.validation.XMLValidationException;

public final class DTDIdRefsAttr
extends DTDAttribute {
    public DTDIdRefsAttr(NameKey name, DefaultAttrValue defValue, int specIndex, boolean nsAware, boolean xml11) {
        super(name, defValue, specIndex, nsAware, xml11);
    }

    public DTDAttribute cloneWith(int specIndex) {
        return new DTDIdRefsAttr(this.mName, this.mDefValue, specIndex, this.mCfgNsAware, this.mCfgXml11);
    }

    public int getValueType() {
        return 4;
    }

    public String validate(DTDValidatorBase v, char[] cbuf, int start, int end, boolean normalize) throws XMLValidationException {
        while (start < end && WstxInputData.isSpaceChar(cbuf[start])) {
            ++start;
        }
        if (start >= end) {
            return this.reportValidationProblem(v, "Empty IDREFS value");
        }
        --end;
        while (end > start && WstxInputData.isSpaceChar(cbuf[end])) {
            --end;
        }
        ElementIdMap m3 = v.getIdMap();
        Location loc = v.getLocation();
        String idStr = null;
        StringBuffer sb = null;
        while (start <= end) {
            int i;
            int c = cbuf[start];
            if (!WstxInputData.isNameStartChar((char)c, this.mCfgNsAware, this.mCfgXml11)) {
                return this.reportInvalidChar(v, (char)c, "not valid as the first IDREFS character");
            }
            int hash = c;
            for (i = start + 1; i <= end && !WstxInputData.isSpaceChar((char)(c = cbuf[i])); ++i) {
                if (!WstxInputData.isNameChar((char)c, this.mCfgNsAware, this.mCfgXml11)) {
                    return this.reportInvalidChar(v, (char)c, "not valid as an IDREFS character");
                }
                hash = hash * 31 + c;
            }
            ElementId id = m3.addReferenced(cbuf, start, i - start, hash, loc, v.getElemName(), this.mName);
            start = i + 1;
            if (normalize) {
                if (idStr == null) {
                    idStr = id.getId();
                } else {
                    if (sb == null) {
                        sb = new StringBuffer(idStr);
                    }
                    idStr = id.getId();
                    sb.append(' ');
                    sb.append(idStr);
                }
            }
            while (start <= end && WstxInputData.isSpaceChar(cbuf[start])) {
                ++start;
            }
        }
        if (normalize) {
            if (sb != null) {
                idStr = sb.toString();
            }
            return idStr;
        }
        return null;
    }

    public void validateDefault(InputProblemReporter rep, boolean normalize) throws XMLValidationException {
        String def = this.validateDefaultNames(rep, normalize);
        if (normalize) {
            this.mDefValue.setValue(def);
        }
    }
}

