/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser.util;

import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.XML;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InlineModelResolver {
    private OpenAPI openAPI;
    private boolean skipMatches;
    static Logger LOGGER = LoggerFactory.getLogger(InlineModelResolver.class);
    Map<String, Schema> addedModels = new HashMap<String, Schema>();
    Map<String, String> generatedSignature = new HashMap<String, String>();

    public void flatten(OpenAPI openAPI) {
        this.openAPI = openAPI;
        if (openAPI.getComponents() != null && openAPI.getComponents().getSchemas() == null) {
            openAPI.getComponents().setSchemas(new HashMap<String, Schema>());
        }
        Paths paths = openAPI.getPaths();
        if (openAPI.getComponents() == null) {
            openAPI.setComponents(new Components());
        }
        Map<String, Schema> models = openAPI.getComponents().getSchemas();
        if (paths != null) {
            for (String pathname : paths.keySet()) {
                PathItem path = (PathItem)paths.get(pathname);
                for (Operation operation : path.readOperations()) {
                    ApiResponses responses;
                    List<Parameter> parameters;
                    RequestBody body = operation.getRequestBody();
                    if (body != null && body.getContent() != null) {
                        Content content = body.getContent();
                        for (String string : content.keySet()) {
                            ObjectSchema op;
                            ArraySchema am;
                            Schema<?> inner;
                            MediaType mediaType;
                            if (content.get(string) == null || (mediaType = (MediaType)content.get(string)).getSchema() == null) continue;
                            Schema model = mediaType.getSchema();
                            if (model.getProperties() != null && model.getProperties().size() > 0) {
                                this.flattenProperties(model.getProperties(), pathname);
                                String modelName = this.resolveModelName(model.getTitle(), "body");
                                mediaType.setSchema(new Schema().$ref(modelName));
                                this.addGenerated(modelName, model);
                                openAPI.getComponents().addSchemas(modelName, model);
                                continue;
                            }
                            if (!(model instanceof ArraySchema) || !((inner = (am = (ArraySchema)model).getItems()) instanceof ObjectSchema) || (op = (ObjectSchema)inner).getProperties() == null || op.getProperties().size() <= 0) continue;
                            this.flattenProperties(op.getProperties(), pathname);
                            String modelName = this.resolveModelName(op.getTitle(), "body");
                            Schema innerModel = this.modelFromProperty(op, modelName);
                            String existing = this.matchGenerated(innerModel);
                            if (existing != null) {
                                am.setItems(new Schema().$ref(existing));
                                continue;
                            }
                            am.setItems(new Schema().$ref(modelName));
                            this.addGenerated(modelName, innerModel);
                            openAPI.getComponents().addSchemas(modelName, innerModel);
                        }
                    }
                    if ((parameters = operation.getParameters()) != null) {
                        for (Parameter parameter : parameters) {
                            ObjectSchema op;
                            ArraySchema am;
                            Schema<?> inner;
                            if (parameter.getSchema() == null) continue;
                            Schema model = parameter.getSchema();
                            if (model.getProperties() != null) {
                                if (model.getType() != null && !"object".equals(model.getType()) || model.getProperties() == null || model.getProperties().size() <= 0) continue;
                                this.flattenProperties(model.getProperties(), pathname);
                                String modelName = this.resolveModelName(model.getTitle(), parameter.getName());
                                parameter.setSchema(new Schema().$ref(modelName));
                                this.addGenerated(modelName, model);
                                openAPI.getComponents().addSchemas(modelName, model);
                                continue;
                            }
                            if (!(model instanceof ArraySchema) || !((inner = (am = (ArraySchema)model).getItems()) instanceof ObjectSchema) || (op = (ObjectSchema)inner).getProperties() == null || op.getProperties().size() <= 0) continue;
                            this.flattenProperties(op.getProperties(), pathname);
                            String modelName = this.resolveModelName(op.getTitle(), parameter.getName());
                            Schema innerModel = this.modelFromProperty(op, modelName);
                            String existing = this.matchGenerated(innerModel);
                            if (existing != null) {
                                am.setItems(new Schema().$ref(existing));
                                continue;
                            }
                            am.setItems(new Schema().$ref(modelName));
                            this.addGenerated(modelName, innerModel);
                            openAPI.getComponents().addSchemas(modelName, innerModel);
                        }
                    }
                    if ((responses = operation.getResponses()) == null) continue;
                    for (String key : responses.keySet()) {
                        ApiResponse response = (ApiResponse)responses.get(key);
                        if (response.getContent() == null) continue;
                        Content content = response.getContent();
                        for (String name : content.keySet()) {
                            ObjectSchema op;
                            Schema innerProperty;
                            MediaType media;
                            if (content.get(name) == null || (media = (MediaType)content.get(name)).getSchema() == null) continue;
                            Schema property = media.getSchema();
                            if (property instanceof ObjectSchema) {
                                ObjectSchema op2 = (ObjectSchema)property;
                                if (op2.getProperties() == null || op2.getProperties().size() <= 0) continue;
                                String modelName = this.resolveModelName(op2.getTitle(), "inline_response_" + key);
                                Schema model = this.modelFromProperty(op2, modelName);
                                String existing = this.matchGenerated(model);
                                if (existing != null) {
                                    media.setSchema(this.makeRefProperty(existing, property));
                                    continue;
                                }
                                media.setSchema(this.makeRefProperty(modelName, property));
                                this.addGenerated(modelName, model);
                                openAPI.getComponents().addSchemas(modelName, model);
                                continue;
                            }
                            if (property instanceof ArraySchema) {
                                ObjectSchema op3;
                                ArraySchema ap = (ArraySchema)property;
                                Schema<?> inner = ap.getItems();
                                if (!(inner instanceof ObjectSchema) || (op3 = (ObjectSchema)inner).getProperties() == null || op3.getProperties().size() <= 0) continue;
                                this.flattenProperties(op3.getProperties(), pathname);
                                String modelName = this.resolveModelName(op3.getTitle(), "inline_response_" + key);
                                Schema innerModel = this.modelFromProperty(op3, modelName);
                                String existing = this.matchGenerated(innerModel);
                                if (existing != null) {
                                    ap.setItems(this.makeRefProperty(existing, op3));
                                    continue;
                                }
                                ap.setItems(this.makeRefProperty(modelName, op3));
                                this.addGenerated(modelName, innerModel);
                                openAPI.getComponents().addSchemas(modelName, innerModel);
                                continue;
                            }
                            if (property.getAdditionalProperties() == null || !(property.getAdditionalProperties() instanceof Schema) || !((innerProperty = (Schema)property.getAdditionalProperties()) instanceof ObjectSchema) || (op = (ObjectSchema)innerProperty).getProperties() == null || op.getProperties().size() <= 0) continue;
                            this.flattenProperties(op.getProperties(), pathname);
                            String modelName = this.resolveModelName(op.getTitle(), "inline_response_" + key);
                            Schema innerModel = this.modelFromProperty(op, modelName);
                            String existing = this.matchGenerated(innerModel);
                            if (existing != null) {
                                property.setAdditionalProperties(new Schema().$ref(existing));
                                continue;
                            }
                            property.setAdditionalProperties(new Schema().$ref(modelName));
                            this.addGenerated(modelName, innerModel);
                            openAPI.getComponents().addSchemas(modelName, innerModel);
                        }
                    }
                }
            }
        }
        if (models != null) {
            ArrayList<String> modelNames = new ArrayList<String>(models.keySet());
            for (String modelName : modelNames) {
                Schema model = models.get(modelName);
                if (model.getProperties() != null) {
                    Map<String, Schema> properties = model.getProperties();
                    this.flattenProperties(properties, modelName);
                    this.fixStringModel(model);
                    continue;
                }
                if (model instanceof ArraySchema) {
                    ObjectSchema op;
                    ArraySchema m3 = (ArraySchema)model;
                    Schema<?> inner = m3.getItems();
                    if (!(inner instanceof ObjectSchema) || (op = (ObjectSchema)inner).getProperties() == null || op.getProperties().size() <= 0) continue;
                    String innerModelName = this.resolveModelName(op.getTitle(), modelName + "_inner");
                    Schema schema = this.modelFromProperty(op, innerModelName);
                    String existing = this.matchGenerated(schema);
                    if (existing == null) {
                        openAPI.getComponents().addSchemas(innerModelName, schema);
                        this.addGenerated(innerModelName, schema);
                        m3.setItems(new Schema().$ref(innerModelName));
                        continue;
                    }
                    m3.setItems(new Schema().$ref(existing));
                    continue;
                }
                if (!(model instanceof ComposedSchema)) continue;
                ComposedSchema composedSchema = (ComposedSchema)model;
                List<Schema> list = null;
                if (composedSchema.getAllOf() != null) {
                    list = composedSchema.getAllOf();
                } else if (composedSchema.getAnyOf() != null) {
                    list = composedSchema.getAnyOf();
                } else if (composedSchema.getOneOf() != null) {
                    list = composedSchema.getOneOf();
                }
                for (int i = 0; i < list.size(); ++i) {
                    if (list.get(i).getProperties() == null) continue;
                    this.flattenProperties(list.get(i).getProperties(), modelName);
                }
            }
        }
    }

    private void fixStringModel(Schema m3) {
        String example;
        if (m3.getType() != null && m3.getType().equals("string") && m3.getExample() != null && (example = m3.getExample().toString()).substring(0, 1).equals("\"") && example.substring(example.length() - 1).equals("\"")) {
            m3.setExample(example.substring(1, example.length() - 1));
        }
    }

    private String resolveModelName(String title, String key) {
        if (title == null) {
            return this.uniqueName(key);
        }
        return this.uniqueName(title);
    }

    public String matchGenerated(Schema model) {
        if (this.skipMatches) {
            return null;
        }
        String json = Json.pretty(model);
        if (this.generatedSignature.containsKey(json)) {
            return this.generatedSignature.get(json);
        }
        return null;
    }

    public void addGenerated(String name, Schema model) {
        this.generatedSignature.put(Json.pretty(model), name);
    }

    public String uniqueName(String key) {
        int count = 0;
        boolean done = false;
        key = key.replaceAll("[^a-z_\\.A-Z0-9 ]", "");
        while (!done) {
            String name = key;
            if (count > 0) {
                name = key + "_" + count;
            }
            if (this.openAPI.getComponents().getSchemas() == null) {
                return name;
            }
            if (!this.openAPI.getComponents().getSchemas().containsKey(name)) {
                return name;
            }
            ++count;
        }
        return key;
    }

    public void flattenProperties(Map<String, Schema> properties, String path) {
        if (properties == null) {
            return;
        }
        HashMap<String, Schema> propsToUpdate = new HashMap<String, Schema>();
        HashMap<String, Schema> modelsToAdd = new HashMap<String, Schema>();
        for (String key : properties.keySet()) {
            ObjectSchema op;
            Schema inner;
            Schema property = properties.get(key);
            if (property instanceof ObjectSchema && ((ObjectSchema)property).getProperties() != null && ((ObjectSchema)property).getProperties().size() > 0) {
                ObjectSchema op2 = (ObjectSchema)property;
                String modelName = this.resolveModelName(op2.getTitle(), path + "_" + key);
                Schema model = this.modelFromProperty(op2, modelName);
                String existing = this.matchGenerated(model);
                if (existing != null) {
                    propsToUpdate.put(key, new Schema().$ref(existing));
                    continue;
                }
                propsToUpdate.put(key, new Schema().$ref(modelName));
                modelsToAdd.put(modelName, model);
                this.addGenerated(modelName, model);
                this.openAPI.getComponents().addSchemas(modelName, model);
                continue;
            }
            if (property instanceof ArraySchema) {
                ObjectSchema op3;
                ArraySchema ap = (ArraySchema)property;
                Schema<?> inner2 = ap.getItems();
                if (!(inner2 instanceof ObjectSchema) || (op3 = (ObjectSchema)inner2).getProperties() == null || op3.getProperties().size() <= 0) continue;
                this.flattenProperties(op3.getProperties(), path);
                String modelName = this.resolveModelName(op3.getTitle(), path + "_" + key);
                Schema innerModel = this.modelFromProperty(op3, modelName);
                String existing = this.matchGenerated(innerModel);
                if (existing != null) {
                    ap.setItems(new Schema().$ref(existing));
                    continue;
                }
                ap.setItems(new Schema().$ref(modelName));
                this.addGenerated(modelName, innerModel);
                this.openAPI.getComponents().addSchemas(modelName, innerModel);
                continue;
            }
            if (property.getAdditionalProperties() == null || !(property.getAdditionalProperties() instanceof Schema) || !((inner = (Schema)property.getAdditionalProperties()) instanceof ObjectSchema) || (op = (ObjectSchema)inner).getProperties() == null || op.getProperties().size() <= 0) continue;
            this.flattenProperties(op.getProperties(), path);
            String modelName = this.resolveModelName(op.getTitle(), path + "_" + key);
            Schema innerModel = this.modelFromProperty(op, modelName);
            String existing = this.matchGenerated(innerModel);
            if (existing != null) {
                property.setAdditionalProperties(new Schema().$ref(existing));
                continue;
            }
            property.setAdditionalProperties(new Schema().$ref(modelName));
            this.addGenerated(modelName, innerModel);
            this.openAPI.getComponents().addSchemas(modelName, innerModel);
        }
        if (propsToUpdate.size() > 0) {
            for (String key : propsToUpdate.keySet()) {
                properties.put(key, (Schema)propsToUpdate.get(key));
            }
        }
        for (String key : modelsToAdd.keySet()) {
            this.openAPI.getComponents().addSchemas(key, (Schema)modelsToAdd.get(key));
            this.addedModels.put(key, (Schema)modelsToAdd.get(key));
        }
    }

    public Schema modelFromProperty(ArraySchema object, String path) {
        Schema<?> inner;
        String description = object.getDescription();
        String example = null;
        Object obj = object.getExample();
        if (obj != null) {
            example = obj.toString();
        }
        if ((inner = object.getItems()) instanceof ObjectSchema) {
            ArraySchema model = new ArraySchema();
            model.setDescription(description);
            model.setExample(example);
            model.setItems(object.getItems());
            return model;
        }
        return null;
    }

    public Schema modelFromProperty(ObjectSchema object, String path) {
        String description = object.getDescription();
        String example = null;
        List<String> requiredList = object.getRequired();
        Object obj = object.getExample();
        if (obj != null) {
            example = obj.toString();
        }
        String name = object.getName();
        XML xml = object.getXml();
        Map<String, Schema> properties = object.getProperties();
        Schema model = new Schema();
        model.setDescription(description);
        model.setExample(example);
        model.setName(name);
        model.setXml(xml);
        model.setType(object.getType());
        model.setRequired(requiredList);
        if (properties != null) {
            this.flattenProperties(properties, path);
            model.setProperties(properties);
        }
        return model;
    }

    public Schema modelFromProperty(Schema object, String path) {
        String description = object.getDescription();
        String example = null;
        Object obj = object.getExample();
        if (obj != null) {
            example = obj.toString();
        }
        ArraySchema model = new ArraySchema();
        model.setDescription(description);
        model.setExample(example);
        if (object.getAdditionalProperties() != null && object.getAdditionalProperties() instanceof Schema) {
            model.setItems((Schema)object.getAdditionalProperties());
        }
        return model;
    }

    public Schema makeRefProperty(String ref, Schema property) {
        Schema newProperty = new Schema().$ref(ref);
        this.copyVendorExtensions(property, newProperty);
        return newProperty;
    }

    public void copyVendorExtensions(Schema source, Schema target) {
        if (source.getExtensions() != null) {
            Map<String, Object> vendorExtensions = source.getExtensions();
            for (String extName : vendorExtensions.keySet()) {
                target.addExtension(extName, vendorExtensions.get(extName));
            }
        }
    }

    public boolean isSkipMatches() {
        return this.skipMatches;
    }

    public void setSkipMatches(boolean skipMatches) {
        this.skipMatches = skipMatches;
    }
}

