/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.analytics.publisher.auth;

import feign.Feign;
import feign.FeignException;
import feign.RetryableException;
import feign.gson.GsonDecoder;
import feign.gson.GsonEncoder;
import feign.slf4j.Slf4jLogger;
import org.wso2.am.analytics.publisher.auth.DefaultApi;
import org.wso2.am.analytics.publisher.auth.TokenDetailsDTO;
import org.wso2.am.analytics.publisher.exception.ConnectionRecoverableException;
import org.wso2.am.analytics.publisher.exception.ConnectionUnrecoverableException;

public class AuthClient {
    public static final String AUTH_HEADER = "Authorization";

    public static String getSASToken(String authEndpoint, String token) throws ConnectionRecoverableException, ConnectionUnrecoverableException {
        DefaultApi defaultApi = Feign.builder().encoder(new GsonEncoder()).decoder(new GsonDecoder()).logger(new Slf4jLogger()).requestInterceptor(requestTemplate -> requestTemplate.header(AUTH_HEADER, "Bearer " + token)).target(DefaultApi.class, authEndpoint);
        try {
            TokenDetailsDTO dto = defaultApi.tokenGet();
            return dto.getToken();
        }
        catch (FeignException.Unauthorized e) {
            throw new ConnectionUnrecoverableException("Invalid/expired user token. Please update apim.analytics.auth_token in configuration and restart the instance", e);
        }
        catch (RetryableException e) {
            throw new ConnectionRecoverableException("Provided authentication endpoint " + authEndpoint + " is not reachable.");
        }
        catch (IllegalArgumentException e) {
            throw new ConnectionUnrecoverableException("Invalid apim.analytics configurations provided. Please update configurations and restart the instance.");
        }
        catch (FeignException.Forbidden e) {
            throw new ConnectionRecoverableException("Publisher has been temporarily revoked.");
        }
        catch (Exception e) {
            throw new ConnectionRecoverableException("Exception " + e.getClass() + " occurred.");
        }
    }
}

