/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.analytics.publisher.client;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.wso2.am.analytics.publisher.auth.AuthClient;
import org.wso2.am.analytics.publisher.exception.ConnectionRecoverableException;
import org.wso2.am.analytics.publisher.exception.ConnectionUnrecoverableException;
import org.wso2.am.analytics.publisher.util.BackoffRetryCounter;
import reactor.core.publisher.Mono;

class WSO2TokenCredential
implements TokenCredential {
    private static final Logger log = Logger.getLogger(WSO2TokenCredential.class);
    private final String authEndpoint;
    private final String authToken;
    private BackoffRetryCounter backoffRetryCounter;

    public WSO2TokenCredential(String authEndpoint, String authToken) {
        this.authEndpoint = authEndpoint;
        this.authToken = authToken;
        this.backoffRetryCounter = new BackoffRetryCounter();
    }

    @Override
    public Mono<AccessToken> getToken(TokenRequestContext tokenRequestContext) {
        log.debug("Trying to retrieving a new SAS token.");
        try {
            String sasToken = AuthClient.getSASToken(this.authEndpoint, this.authToken);
            this.backoffRetryCounter.reset();
            log.debug("New SAS token retrieved.");
            OffsetDateTime time = this.getExpirationTime(sasToken);
            return Mono.fromCallable(() -> new AccessToken(sasToken, time));
        }
        catch (ConnectionRecoverableException e) {
            log.error("Error occurred when retrieving SAS token. Connection will be retried in " + this.backoffRetryCounter.getTimeInterval().replaceAll("[\r\n]", ""), e);
            try {
                Thread.sleep(this.backoffRetryCounter.getTimeIntervalMillis());
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            this.backoffRetryCounter.increment();
            return this.getToken(tokenRequestContext);
        }
        catch (ConnectionUnrecoverableException e) {
            log.error("Error occurred when retrieving SAS token.", e);
            this.backoffRetryCounter.reset();
            return null;
        }
    }

    private OffsetDateTime getExpirationTime(String sharedAccessSignature) {
        String[] parts = sharedAccessSignature.split("&");
        return Arrays.stream(parts).map(part -> part.split("=")).filter(pair -> ((String[])pair).length == 2 && pair[0].equalsIgnoreCase("se")).findFirst().map(pair -> pair[1]).map(expirationTimeStr -> {
            try {
                long epochSeconds = Long.parseLong(expirationTimeStr);
                return Instant.ofEpochSecond(epochSeconds).atOffset(ZoneOffset.UTC);
            }
            catch (NumberFormatException e) {
                log.error("Invalid expiration time format in the SAS token.", e);
                return OffsetDateTime.MAX;
            }
        }).orElse(OffsetDateTime.MAX);
    }
}

