/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.analytics.publisher.reporter;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.wso2.am.analytics.publisher.exception.MetricCreationException;
import org.wso2.am.analytics.publisher.reporter.MetricReporter;
import org.wso2.am.analytics.publisher.reporter.cloud.DefaultAnalyticsMetricReporter;

public class MetricReporterFactory {
    private static final Logger log = Logger.getLogger(MetricReporterFactory.class);
    private static final MetricReporterFactory instance = new MetricReporterFactory();
    private static Map<String, MetricReporter> reporterRegistry = new HashMap<String, MetricReporter>();

    private MetricReporterFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetricReporter createMetricReporter(Map<String, String> properties) throws MetricCreationException {
        if (reporterRegistry.get("default") == null) {
            MetricReporterFactory metricReporterFactory = this;
            synchronized (metricReporterFactory) {
                if (reporterRegistry.get("default") == null) {
                    DefaultAnalyticsMetricReporter reporterInstance = new DefaultAnalyticsMetricReporter(properties);
                    reporterRegistry.put("default", reporterInstance);
                    return reporterInstance;
                }
            }
        }
        MetricReporter reporterInstance = reporterRegistry.get("default");
        log.info("Metric Reporter of type " + reporterInstance.getClass().toString().replaceAll("[\r\n]", "") + " is already created. Hence returning same instance");
        return reporterInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetricReporter createMetricReporter(String fullyQualifiedClassName, Map<String, String> properties) throws MetricCreationException {
        if (reporterRegistry.get(fullyQualifiedClassName) == null) {
            MetricReporterFactory metricReporterFactory = this;
            synchronized (metricReporterFactory) {
                if (reporterRegistry.get(fullyQualifiedClassName) == null) {
                    if (fullyQualifiedClassName != null && !fullyQualifiedClassName.isEmpty()) {
                        try {
                            Class<?> clazz = Class.forName(fullyQualifiedClassName);
                            Constructor<?> constructor = clazz.getConstructor(Map.class);
                            MetricReporter reporterInstance = (MetricReporter)constructor.newInstance(properties);
                            reporterRegistry.put(fullyQualifiedClassName, reporterInstance);
                            return reporterInstance;
                        }
                        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                            throw new MetricCreationException("Error occurred while creating a Metric Reporter of type " + fullyQualifiedClassName, e);
                        }
                    }
                    throw new MetricCreationException("Provided class name is either empty or null. Hence cannot create the Reporter.");
                }
            }
        }
        MetricReporter reporterInstance = reporterRegistry.get(fullyQualifiedClassName);
        log.info("Metric Reporter of type " + reporterInstance.getClass().toString().replaceAll("[\r\n]", "") + " is already created. Hence returning same instance");
        return reporterInstance;
    }

    public void reset() {
        reporterRegistry.clear();
    }

    public static MetricReporterFactory getInstance() {
        return instance;
    }
}

