/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.analytics.publisher.reporter.cloud;

import org.wso2.am.analytics.publisher.client.ClientStatus;
import org.wso2.am.analytics.publisher.exception.MetricCreationException;
import org.wso2.am.analytics.publisher.exception.MetricReportingException;
import org.wso2.am.analytics.publisher.reporter.CounterMetric;
import org.wso2.am.analytics.publisher.reporter.MetricEventBuilder;
import org.wso2.am.analytics.publisher.reporter.MetricSchema;
import org.wso2.am.analytics.publisher.reporter.cloud.DefaultFaultMetricEventBuilder;
import org.wso2.am.analytics.publisher.reporter.cloud.DefaultResponseMetricEventBuilder;
import org.wso2.am.analytics.publisher.reporter.cloud.EventQueue;

public class DefaultCounterMetric
implements CounterMetric {
    private String name;
    private EventQueue queue;
    private MetricSchema schema;
    private ClientStatus status;

    public DefaultCounterMetric(String name, EventQueue queue, MetricSchema schema) throws MetricCreationException {
        this.name = name;
        this.queue = queue;
        if (schema != MetricSchema.ERROR && schema != MetricSchema.RESPONSE) {
            throw new MetricCreationException("Default Counter Metric only supports " + (Object)((Object)MetricSchema.RESPONSE) + " and " + (Object)((Object)MetricSchema.ERROR) + " types.");
        }
        this.schema = schema;
        this.status = queue.getClient().getStatus();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public MetricSchema getSchema() {
        return this.schema;
    }

    @Override
    public int incrementCount(MetricEventBuilder builder) throws MetricReportingException {
        if (this.status != ClientStatus.NOT_CONNECTED) {
            if (builder != null) {
                this.queue.put(builder);
                return 0;
            }
            throw new MetricReportingException("MetricEventBuilder cannot be null");
        }
        throw new MetricReportingException("Eventhub Client is not connected.");
    }

    @Override
    public MetricEventBuilder getEventBuilder() {
        if (this.schema == MetricSchema.RESPONSE) {
            return new DefaultResponseMetricEventBuilder();
        }
        if (this.schema == MetricSchema.ERROR) {
            return new DefaultFaultMetricEventBuilder();
        }
        return null;
    }
}

