/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.analytics.publisher.reporter.cloud;

import java.util.HashMap;
import java.util.Map;
import org.wso2.am.analytics.publisher.exception.MetricReportingException;
import org.wso2.am.analytics.publisher.reporter.AbstractMetricEventBuilder;
import org.wso2.am.analytics.publisher.reporter.MetricEventBuilder;
import org.wso2.am.analytics.publisher.reporter.MetricSchema;
import org.wso2.am.analytics.publisher.reporter.cloud.DefaultInputValidator;

public class DefaultFaultMetricEventBuilder
extends AbstractMetricEventBuilder {
    private final Map<String, Class> requiredAttributes = DefaultInputValidator.getInstance().getEventProperties(MetricSchema.ERROR);
    private Map<String, Object> eventMap = new HashMap<String, Object>();

    protected DefaultFaultMetricEventBuilder() {
    }

    @Override
    public boolean validate() throws MetricReportingException {
        for (Map.Entry<String, Class> entry : this.requiredAttributes.entrySet()) {
            Object attribute = this.eventMap.get(entry.getKey());
            if (attribute == null) {
                throw new MetricReportingException(entry.getKey() + " is missing in metric data. This metric event will not be processed further.");
            }
            if (attribute.getClass().equals(entry.getValue())) continue;
            throw new MetricReportingException(entry.getKey() + " is expecting a " + entry.getValue() + " type attribute while attribute of type " + attribute.getClass() + " is present");
        }
        return true;
    }

    @Override
    public MetricEventBuilder addAttribute(String key, Object value) throws MetricReportingException {
        this.eventMap.put(key, value);
        return this;
    }

    @Override
    protected Map<String, Object> buildEvent() {
        this.eventMap.put("eventType", "fault");
        return this.eventMap;
    }
}

