/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.analytics.publisher.reporter.cloud;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.wso2.am.analytics.publisher.exception.MetricReportingException;
import org.wso2.am.analytics.publisher.reporter.AbstractMetricEventBuilder;
import org.wso2.am.analytics.publisher.reporter.MetricEventBuilder;
import org.wso2.am.analytics.publisher.reporter.MetricSchema;
import org.wso2.am.analytics.publisher.reporter.cloud.DefaultInputValidator;
import ua_parser.Client;
import ua_parser.Parser;

public class DefaultResponseMetricEventBuilder
extends AbstractMetricEventBuilder {
    private static final Logger log = Logger.getLogger(DefaultResponseMetricEventBuilder.class);
    private final Map<String, Class> requiredAttributes = DefaultInputValidator.getInstance().getEventProperties(MetricSchema.RESPONSE);
    private Map<String, Object> eventMap = new HashMap<String, Object>();
    private Parser uaParser;

    protected DefaultResponseMetricEventBuilder() {
        try {
            this.uaParser = new Parser();
        }
        catch (IOException e) {
            log.error("Error occurred when initializing uaParser", e);
        }
    }

    @Override
    public boolean validate() throws MetricReportingException {
        for (Map.Entry<String, Class> entry : this.requiredAttributes.entrySet()) {
            Object attribute = this.eventMap.get(entry.getKey());
            if (attribute == null) {
                throw new MetricReportingException(entry.getKey() + " is missing in metric data. This metric event will not be processed further.");
            }
            if (attribute.getClass().equals(entry.getValue())) continue;
            throw new MetricReportingException(entry.getKey() + " is expecting a " + entry.getValue() + " type attribute while attribute of type " + attribute.getClass() + " is present.");
        }
        return true;
    }

    @Override
    public MetricEventBuilder addAttribute(String key, Object value) throws MetricReportingException {
        this.eventMap.put(key, value);
        return this;
    }

    @Override
    protected Map<String, Object> buildEvent() {
        this.eventMap.put("eventType", "response");
        String userAgentHeader = (String)this.eventMap.remove("userAgentHeader");
        this.setUserAgentProperties(userAgentHeader);
        return this.eventMap;
    }

    private void setUserAgentProperties(String userAgentHeader) {
        String browser = null;
        String platform = null;
        if (this.uaParser != null) {
            Client client = this.uaParser.parse(userAgentHeader);
            browser = client.userAgent.family;
            platform = client.os.family;
        }
        if (browser == null || browser.isEmpty()) {
            browser = "UNKNOWN";
        }
        if (platform == null || platform.isEmpty()) {
            platform = "UNKNOWN";
        }
        this.eventMap.put("userAgent", browser);
        this.eventMap.put("platform", platform);
    }
}

