/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.analytics.publisher.reporter.cloud;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import org.apache.log4j.Logger;
import org.wso2.am.analytics.publisher.client.EventHubClient;
import org.wso2.am.analytics.publisher.reporter.MetricEventBuilder;
import org.wso2.am.analytics.publisher.reporter.cloud.DefaultAnalyticsThreadFactory;
import org.wso2.am.analytics.publisher.reporter.cloud.QueueWorker;

public class EventQueue {
    private static final Logger log = Logger.getLogger(EventQueue.class);
    private BlockingQueue<MetricEventBuilder> eventQueue;
    private ExecutorService executorService;
    private EventHubClient client;

    public EventQueue(int queueSize, int workerThreadCount, EventHubClient client) {
        this.client = client;
        this.executorService = Executors.newFixedThreadPool(workerThreadCount, new DefaultAnalyticsThreadFactory("Queue-Worker"));
        this.eventQueue = new ArrayBlockingQueue<MetricEventBuilder>(queueSize);
    }

    public void put(MetricEventBuilder builder) {
        try {
            this.eventQueue.put(builder);
            this.executorService.submit(new QueueWorker(this.eventQueue, this.client, this.executorService));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (RejectedExecutionException e) {
            log.warn("Task submission failed. Task queue might be full", e);
        }
    }

    public boolean isQueueEmpty() {
        return this.eventQueue.peek() == null;
    }

    protected void finalize() throws Throwable {
        this.executorService.shutdown();
        super.finalize();
    }

    protected EventHubClient getClient() {
        return this.client;
    }
}

