/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.analytics.publisher.reporter.cloud;

import com.google.gson.Gson;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.log4j.Logger;
import org.wso2.am.analytics.publisher.client.EventHubClient;
import org.wso2.am.analytics.publisher.exception.MetricReportingException;
import org.wso2.am.analytics.publisher.reporter.MetricEventBuilder;

public class QueueWorker
implements Runnable {
    private static final Logger log = Logger.getLogger(QueueWorker.class);
    private BlockingQueue<MetricEventBuilder> eventQueue;
    private ExecutorService executorService;
    private EventHubClient client;

    public QueueWorker(BlockingQueue<MetricEventBuilder> queue, EventHubClient client, ExecutorService executorService) {
        this.client = client;
        this.eventQueue = queue;
        this.executorService = executorService;
    }

    @Override
    public void run() {
        try {
            MetricEventBuilder eventBuilder;
            if (log.isDebugEnabled()) {
                log.debug(this.eventQueue.size() + " messages in queue before " + Thread.currentThread().getName().replaceAll("[\r\n]", "") + " worker has polled queue");
            }
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)this.executorService;
            while ((eventBuilder = (MetricEventBuilder)this.eventQueue.poll()) != null) {
                block8: {
                    String event = null;
                    try {
                        Map<String, Object> eventMap = eventBuilder.build();
                        event = new Gson().toJson(eventMap);
                    }
                    catch (MetricReportingException e) {
                        log.error("Builder instance is not duly filled. Event building failed", e);
                        break block8;
                    }
                    this.client.sendEvent(event);
                    if (this.eventQueue.size() == 0 && threadPoolExecutor.getActiveCount() == 1) {
                        this.client.flushEvents();
                        break;
                    }
                }
                if (threadPoolExecutor.getActiveCount() == 1 && this.eventQueue.size() != 0) continue;
            }
            if (log.isDebugEnabled()) {
                log.debug(this.eventQueue.size() + " messages in queue after " + Thread.currentThread().getName().replaceAll("[\r\n]", "") + " worker has finished work");
            }
        }
        catch (Throwable e) {
            log.error("Error in passing events to Event Hub client. Events dropped", e);
        }
    }
}

