/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.client;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.andes.client.AMQQueue;
import org.wso2.andes.client.AMQSession;
import org.wso2.andes.client.BasicMessageConsumer;

public class AMQQueueBrowser
implements QueueBrowser {
    private static final Logger _logger = LoggerFactory.getLogger(AMQQueueBrowser.class);
    private AtomicBoolean _isClosed = new AtomicBoolean();
    private final AMQSession _session;
    private final AMQQueue _queue;
    private final ArrayList<BasicMessageConsumer> _consumers = new ArrayList();
    private final String _messageSelector;

    AMQQueueBrowser(AMQSession session, AMQQueue queue, String messageSelector) throws JMSException {
        this._session = session;
        this._queue = queue;
        this._messageSelector = messageSelector == null || messageSelector.trim().length() == 0 ? null : messageSelector;
        BasicMessageConsumer consumer = (BasicMessageConsumer)this._session.createBrowserConsumer(this._queue, this._messageSelector, false);
        consumer.close();
    }

    @Override
    public Queue getQueue() throws JMSException {
        this.checkState();
        return this._queue;
    }

    private void checkState() throws JMSException {
        if (this._isClosed.get()) {
            throw new IllegalStateException("Queue Browser");
        }
        if (this._session.isClosed()) {
            throw new IllegalStateException("Session is closed");
        }
    }

    @Override
    public String getMessageSelector() throws JMSException {
        this.checkState();
        return this._messageSelector;
    }

    @Override
    public Enumeration getEnumeration() throws JMSException {
        this.checkState();
        BasicMessageConsumer consumer = (BasicMessageConsumer)this._session.createBrowserConsumer(this._queue, this._messageSelector, false);
        this._consumers.add(consumer);
        return new QueueBrowserEnumeration(consumer);
    }

    @Override
    public void close() throws JMSException {
        for (BasicMessageConsumer consumer : this._consumers) {
            consumer.close();
        }
        this._consumers.clear();
    }

    private class QueueBrowserEnumeration
    implements Enumeration {
        Message _nextMessage;
        private BasicMessageConsumer _consumer;

        public QueueBrowserEnumeration(BasicMessageConsumer consumer) throws JMSException {
            Message message = this._nextMessage = consumer == null ? null : consumer.receiveBrowse();
            if (_logger.isDebugEnabled()) {
                _logger.debug("QB:created with first element:" + this._nextMessage);
            }
            this._consumer = consumer;
        }

        @Override
        public boolean hasMoreElements() {
            if (_logger.isDebugEnabled()) {
                _logger.debug("QB:hasMoreElements:" + (this._nextMessage != null));
            }
            return this._nextMessage != null;
        }

        public Object nextElement() {
            Message msg = this._nextMessage;
            try {
                _logger.debug("QB:nextElement about to receive");
                this._nextMessage = this._consumer.receiveBrowse();
                _logger.debug("QB:nextElement received:" + this._nextMessage);
            }
            catch (JMSException e) {
                _logger.warn("Exception caught while queue browsing", e);
                this._nextMessage = null;
            }
            return msg;
        }
    }
}

