/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.client;

import java.util.Hashtable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XATopicConnection;
import javax.jms.XATopicConnectionFactory;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.wso2.andes.client.AMQConnectionFactory;
import org.wso2.andes.client.AMQConnectionURL;
import org.wso2.andes.client.AMQQueue;
import org.wso2.andes.client.AMQTopic;
import org.wso2.andes.client.XAConnectionImpl;
import org.wso2.andes.url.AMQBindingURL;
import org.wso2.andes.url.URLSyntaxException;

public class AMQXAConnectionFactory
extends AMQConnectionFactory
implements XATopicConnectionFactory,
XAQueueConnectionFactory,
XAConnectionFactory {
    private ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor();

    public AMQXAConnectionFactory(String url) throws URLSyntaxException {
        super(url);
    }

    public AMQXAConnectionFactory() {
    }

    @Override
    public XAConnection createXAConnection() throws JMSException {
        try {
            return new XAConnectionImpl(this._connectionDetails, this._sslConfig, this.scheduledExecutor);
        }
        catch (Exception e) {
            JMSException jmse = new JMSException("Error creating connection: " + e.getMessage());
            jmse.setLinkedException(e);
            jmse.initCause(e);
            throw jmse;
        }
    }

    @Override
    public XAConnection createXAConnection(String username, String password) throws JMSException {
        if (this._connectionDetails == null) {
            throw new JMSException("A URL must be specified to access XA connections");
        }
        this._connectionDetails.setUsername(username);
        this._connectionDetails.setPassword(password);
        return this.createXAConnection();
    }

    @Override
    public XATopicConnection createXATopicConnection() throws JMSException {
        return (XATopicConnection)this.createXAConnection();
    }

    @Override
    public XATopicConnection createXATopicConnection(String username, String password) throws JMSException {
        return (XATopicConnection)this.createXAConnection(username, password);
    }

    @Override
    public XAQueueConnection createXAQueueConnection() throws JMSException {
        return (XAQueueConnection)this.createXAConnection();
    }

    @Override
    public XAQueueConnection createXAQueueConnection(String username, String password) throws JMSException {
        return (XAQueueConnection)this.createXAConnection(username, password);
    }

    @Override
    public Reference getReference() throws NamingException {
        return new Reference(AMQXAConnectionFactory.class.getName(), new StringRefAddr(AMQXAConnectionFactory.class.getName(), this._connectionDetails.getURL()), AMQXAConnectionFactory.class.getName(), null);
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context ctx, Hashtable env) throws Exception {
        if (obj instanceof Reference) {
            RefAddr addr;
            Reference ref = (Reference)obj;
            if (ref.getClassName().equals(XAConnectionImpl.class.getName()) && (addr = ref.get(XAConnectionImpl.class.getName())) != null) {
                XAConnectionImpl xaConnection = new XAConnectionImpl(new AMQConnectionURL((String)addr.getContent()), null, Executors.newSingleThreadScheduledExecutor());
                xaConnection.setConnectionListener(this.getConnectionListener());
                return xaConnection;
            }
            if (ref.getClassName().equals(AMQQueue.class.getName()) && (addr = ref.get(AMQQueue.class.getName())) != null) {
                return new AMQQueue(new AMQBindingURL((String)addr.getContent()));
            }
            if (ref.getClassName().equals(AMQTopic.class.getName()) && (addr = ref.get(AMQTopic.class.getName())) != null) {
                return new AMQTopic(new AMQBindingURL((String)addr.getContent()));
            }
            if (ref.getClassName().equals(AMQXAConnectionFactory.class.getName()) && (addr = ref.get(AMQXAConnectionFactory.class.getName())) != null) {
                return new AMQXAConnectionFactory((String)addr.getContent());
            }
        }
        return null;
    }
}

