/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.client;

import java.util.Enumeration;
import javax.jms.ConnectionMetaData;
import javax.jms.JMSException;
import org.wso2.andes.client.AMQConnection;
import org.wso2.andes.client.CustomJMSXProperty;
import org.wso2.andes.common.QpidProperties;

public class QpidConnectionMetaData
implements ConnectionMetaData {
    private AMQConnection con;

    QpidConnectionMetaData(AMQConnection conn) {
        this.con = conn;
    }

    @Override
    public int getJMSMajorVersion() throws JMSException {
        return 1;
    }

    @Override
    public int getJMSMinorVersion() throws JMSException {
        return 1;
    }

    @Override
    public String getJMSProviderName() throws JMSException {
        return "Apache " + QpidProperties.getProductName();
    }

    @Override
    public String getJMSVersion() throws JMSException {
        return "1.1";
    }

    @Override
    public Enumeration getJMSXPropertyNames() throws JMSException {
        return CustomJMSXProperty.asEnumeration();
    }

    @Override
    public int getProviderMajorVersion() throws JMSException {
        return this.con.getProtocolVersion().getMajorVersion();
    }

    @Override
    public int getProviderMinorVersion() throws JMSException {
        return this.con.getProtocolVersion().getMinorVersion();
    }

    @Override
    public String getProviderVersion() throws JMSException {
        return QpidProperties.getProductName() + " (Client: [" + this.getClientVersion() + "] ; Broker [" + this.getBrokerVersion() + "] ; Protocol: [ " + this.getProtocolVersion() + "] )";
    }

    private String getProtocolVersion() {
        return this.con.getProtocolVersion().toString();
    }

    public String getBrokerVersion() {
        return "<unkown>";
    }

    public String getClientVersion() {
        return QpidProperties.getBuildVersion();
    }
}

