/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.client;

import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import org.wso2.andes.client.AMQDestination;
import org.wso2.andes.client.AMQSession;
import org.wso2.andes.client.BasicMessageProducer;

public class TopicPublisherAdapter
implements TopicPublisher {
    private BasicMessageProducer _delegate;
    private Topic _topic;

    public TopicPublisherAdapter(BasicMessageProducer msgProducer, Topic topic) {
        this._delegate = msgProducer;
        this._topic = topic;
    }

    @Override
    public Topic getTopic() throws JMSException {
        this.checkPreConditions();
        return this._topic;
    }

    @Override
    public void publish(Message msg) throws JMSException {
        this.checkPreConditions();
        this.checkTopic(this._topic);
        this._delegate.send(msg);
    }

    @Override
    public void publish(Topic topic, Message msg) throws JMSException {
        this.checkPreConditions();
        this.checkTopic(topic);
        this._delegate.send(topic, msg);
    }

    @Override
    public void publish(Message msg, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkPreConditions();
        this.checkTopic(this._topic);
        this._delegate.send(msg, deliveryMode, priority, timeToLive);
    }

    @Override
    public int getDeliveryMode() throws JMSException {
        this.checkPreConditions();
        return this._delegate.getDeliveryMode();
    }

    @Override
    public void publish(Topic topic, Message msg, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkPreConditions();
        this.checkTopic(topic);
        this._delegate.send(topic, msg, deliveryMode, priority, timeToLive);
    }

    @Override
    public void close() throws JMSException {
        this._delegate.close();
    }

    @Override
    public boolean getDisableMessageID() throws JMSException {
        this.checkPreConditions();
        return this._delegate.getDisableMessageID();
    }

    @Override
    public boolean getDisableMessageTimestamp() throws JMSException {
        this.checkPreConditions();
        return this._delegate.getDisableMessageTimestamp();
    }

    @Override
    public Destination getDestination() throws JMSException {
        this.checkPreConditions();
        return this._delegate.getDestination();
    }

    @Override
    public int getPriority() throws JMSException {
        this.checkPreConditions();
        return this._delegate.getPriority();
    }

    @Override
    public long getTimeToLive() throws JMSException {
        this.checkPreConditions();
        return this._delegate.getTimeToLive();
    }

    @Override
    public void send(Message msg) throws JMSException {
        this.checkPreConditions();
        this.checkTopic(this._topic);
        this._delegate.send(msg);
    }

    @Override
    public void send(Destination dest, Message msg) throws JMSException {
        this.checkPreConditions();
        this.checkTopic(dest);
        this._delegate.send(dest, msg);
    }

    @Override
    public void send(Message msg, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkPreConditions();
        this.checkTopic(this._topic);
        this._delegate.send(msg, deliveryMode, priority, timeToLive);
    }

    @Override
    public void send(Destination dest, Message msg, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkPreConditions();
        this.checkTopic(dest);
        this._delegate.send(dest, msg, deliveryMode, priority, timeToLive);
    }

    @Override
    public void setDeliveryMode(int deliveryMode) throws JMSException {
        this.checkPreConditions();
        this._delegate.setDeliveryMode(deliveryMode);
    }

    @Override
    public void setDisableMessageID(boolean disableMessageID) throws JMSException {
        this.checkPreConditions();
        this._delegate.setDisableMessageID(disableMessageID);
    }

    @Override
    public void setDisableMessageTimestamp(boolean disableMessageTimestamp) throws JMSException {
        this.checkPreConditions();
        this._delegate.setDisableMessageTimestamp(disableMessageTimestamp);
    }

    @Override
    public void setPriority(int priority) throws JMSException {
        this.checkPreConditions();
        this._delegate.setPriority(priority);
    }

    @Override
    public void setTimeToLive(long timeToLive) throws JMSException {
        this.checkPreConditions();
        this._delegate.setTimeToLive(timeToLive);
    }

    private void checkPreConditions() throws IllegalStateException {
        if (this._delegate.isClosed()) {
            throw new IllegalStateException("Publisher is _closed");
        }
        AMQSession session = this._delegate.getSession();
        if (session == null || session.isClosed()) {
            throw new IllegalStateException("Invalid Session");
        }
    }

    private void checkTopic(Destination topic) throws InvalidDestinationException {
        if (topic == null) {
            throw new UnsupportedOperationException("Topic is null");
        }
        if (!(topic instanceof Topic)) {
            throw new InvalidDestinationException("Destination " + topic + " is not a topic");
        }
        if (!(topic instanceof AMQDestination)) {
            throw new InvalidDestinationException("Destination " + topic + " is not a Qpid topic");
        }
    }
}

