/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.client;

import java.util.ArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import javax.jms.XATopicConnection;
import javax.jms.XATopicSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.andes.AMQException;
import org.wso2.andes.client.AMQConnection;
import org.wso2.andes.client.SSLConfiguration;
import org.wso2.andes.client.XASession_9_1;
import org.wso2.andes.jms.ConnectionURL;

public class XAConnectionImpl
extends AMQConnection
implements XAConnection,
XAQueueConnection,
XATopicConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(XAConnectionImpl.class);
    private int connectionCloseTimeout = 60;
    private final ArrayList<XASession_9_1> xaSessions = new ArrayList();
    private final ScheduledExecutorService scheduledExecutor;
    private boolean connectionCloseSignaled = false;
    private ScheduledFuture<?> connectionCloseFuture;

    XAConnectionImpl(ConnectionURL connectionURL, SSLConfiguration sslConfig, ScheduledExecutorService scheduledExecutor) throws AMQException {
        super(connectionURL, sslConfig);
        this.connectionCloseTimeout = Integer.parseInt(System.getProperty("XaConnectionCloseWaitTimeOut", "60"));
        this.scheduledExecutor = scheduledExecutor;
    }

    @Override
    public synchronized XASession createXASession() throws JMSException {
        this.checkNotClosed();
        if (this.connectionCloseSignaled) {
            throw new IllegalStateException("Object " + this.toString() + " has been closed");
        }
        XASession xaSession = this._delegate.createXASession();
        if (xaSession instanceof XASession_9_1) {
            this.xaSessions.add((XASession_9_1)xaSession);
        }
        return xaSession;
    }

    @Override
    public XAQueueSession createXAQueueSession() throws JMSException {
        return (XAQueueSession)this.createXASession();
    }

    @Override
    public XATopicSession createXATopicSession() throws JMSException {
        return (XATopicSession)this.createXASession();
    }

    @Override
    public synchronized void close() throws JMSException {
        if (!this.connectionCloseSignaled) {
            boolean canClosePhysicalConnection = true;
            for (XASession_9_1 xaSession : this.xaSessions) {
                boolean isTransactionActive = xaSession.indicateConnectionClose();
                if (!isTransactionActive) continue;
                canClosePhysicalConnection = false;
            }
            if (canClosePhysicalConnection) {
                super.close();
            } else {
                LOGGER.error("XAConnection.close() was called before committing or rolling back");
                this.connectionCloseFuture = this.scheduledExecutor.schedule(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            LOGGER.error("Closing XAConnection after waiting " + XAConnectionImpl.this.connectionCloseTimeout + " seconds for a commit or rollback");
                            XAConnectionImpl.this.closePhysicalConnection();
                        }
                        catch (JMSException e) {
                            LOGGER.error("Error occurred while closing the XAConnection after close timeout");
                        }
                    }
                }, (long)this.connectionCloseTimeout, TimeUnit.SECONDS);
            }
            this.connectionCloseSignaled = true;
        }
    }

    private void closePhysicalConnection() throws JMSException {
        super.close();
    }

    synchronized void deregisterSession(XASession_9_1 xaSession) {
        this.xaSessions.remove(xaSession);
    }

    void internalClose() throws JMSException {
        boolean closeSuccessful = this.closeIfNoActiveSessions();
        if (closeSuccessful) {
            this.removeScheduledClose();
        }
    }

    private synchronized boolean closeIfNoActiveSessions() throws JMSException {
        if (this.xaSessions.isEmpty()) {
            this.closePhysicalConnection();
            return true;
        }
        return false;
    }

    private synchronized void removeScheduledClose() {
        if (this.connectionCloseFuture != null) {
            this.connectionCloseFuture.cancel(true);
            this.connectionCloseFuture = null;
        }
    }
}

