/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.client.message;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.UUID;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MessageNotWriteableException;
import org.wso2.andes.client.AMQDestination;
import org.wso2.andes.client.AMQQueue;
import org.wso2.andes.client.AMQSession;
import org.wso2.andes.client.AMQTopic;
import org.wso2.andes.client.CustomJMSXProperty;
import org.wso2.andes.client.JMSAMQException;
import org.wso2.andes.client.message.AbstractAMQMessageDelegate;
import org.wso2.andes.client.message.JMSHeaderAdapter;
import org.wso2.andes.collections.ReferenceMap;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.BasicContentHeaderProperties;
import org.wso2.andes.framing.ContentHeaderProperties;
import org.wso2.andes.url.AMQBindingURL;

public class AMQMessageDelegate_0_8
extends AbstractAMQMessageDelegate {
    private static final Map _destinationCache = Collections.synchronizedMap(new ReferenceMap());
    public static final String JMS_TYPE = "x-jms-type";
    private boolean _readableProperties = false;
    private Destination _destination;
    private JMSHeaderAdapter _headerAdapter;
    private static final boolean STRICT_AMQP_COMPLIANCE = Boolean.parseBoolean(System.getProperty("STRICT_AMQP", "false"));
    private ContentHeaderProperties _contentHeaderProperties;
    private AMQSession _session;
    private final long _deliveryTag;

    private AMQMessageDelegate_0_8(BasicContentHeaderProperties properties, long deliveryTag) {
        this._contentHeaderProperties = properties;
        this._deliveryTag = deliveryTag;
        this._readableProperties = this._contentHeaderProperties != null;
        this._headerAdapter = new JMSHeaderAdapter(this._readableProperties ? ((BasicContentHeaderProperties)this._contentHeaderProperties).getHeaders() : new BasicContentHeaderProperties().getHeaders());
    }

    protected AMQMessageDelegate_0_8() {
        this(new BasicContentHeaderProperties(), -1L);
        this._readableProperties = false;
        this._headerAdapter = new JMSHeaderAdapter(((BasicContentHeaderProperties)this._contentHeaderProperties).getHeaders());
    }

    protected AMQMessageDelegate_0_8(long deliveryTag, BasicContentHeaderProperties contentHeader, AMQShortString exchange, AMQShortString routingKey) {
        this(contentHeader, deliveryTag);
        Integer type = contentHeader.getHeaders().getInteger(CustomJMSXProperty.JMS_QPID_DESTTYPE.getShortStringName());
        AMQDestination dest = null;
        if (type != null) {
            switch (type) {
                case 1: {
                    dest = new AMQQueue(exchange, routingKey, routingKey);
                    break;
                }
                case 2: {
                    dest = new AMQTopic(exchange, routingKey, null);
                    break;
                }
                default: {
                    dest = null;
                }
            }
        }
        if (dest == null) {
            dest = this.generateDestination(exchange, routingKey);
        }
        this.setJMSDestination(dest);
    }

    @Override
    public String getJMSMessageID() throws JMSException {
        return this.getContentHeaderProperties().getMessageIdAsString();
    }

    @Override
    public void setJMSMessageID(String messageId) throws JMSException {
        if (messageId != null) {
            this.getContentHeaderProperties().setMessageId(messageId);
        }
    }

    @Override
    public void setJMSMessageID(UUID messageId) throws JMSException {
        if (messageId != null) {
            this.getContentHeaderProperties().setMessageId("ID:" + messageId);
        }
    }

    @Override
    public long getJMSTimestamp() throws JMSException {
        return this.getContentHeaderProperties().getTimestamp();
    }

    @Override
    public void setJMSTimestamp(long timestamp) throws JMSException {
        this.getContentHeaderProperties().setTimestamp(timestamp);
    }

    @Override
    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        return this.getContentHeaderProperties().getCorrelationIdAsString().getBytes();
    }

    @Override
    public void setJMSCorrelationIDAsBytes(byte[] bytes) throws JMSException {
        this.getContentHeaderProperties().setCorrelationId(new String(bytes));
    }

    @Override
    public void setJMSCorrelationID(String correlationId) throws JMSException {
        this.getContentHeaderProperties().setCorrelationId(correlationId);
    }

    @Override
    public String getJMSCorrelationID() throws JMSException {
        return this.getContentHeaderProperties().getCorrelationIdAsString();
    }

    @Override
    public Destination getJMSReplyTo() throws JMSException {
        String replyToEncoding = this.getContentHeaderProperties().getReplyToAsString();
        if (replyToEncoding == null) {
            return null;
        }
        Destination dest = (Destination)_destinationCache.get(replyToEncoding);
        if (dest == null) {
            try {
                AMQBindingURL binding = new AMQBindingURL(replyToEncoding);
                dest = AMQDestination.createDestination(binding);
            }
            catch (URISyntaxException e) {
                throw new JMSAMQException("Illegal value in JMS_ReplyTo property: " + replyToEncoding, e);
            }
            _destinationCache.put(replyToEncoding, dest);
        }
        return dest;
    }

    @Override
    public void setJMSReplyTo(Destination destination) throws JMSException {
        if (destination == null) {
            this.getContentHeaderProperties().setReplyTo((String)null);
            return;
        }
        if (!(destination instanceof AMQDestination)) {
            throw new IllegalArgumentException("ReplyTo destination may only be an AMQDestination - passed argument was type " + destination.getClass());
        }
        AMQDestination amqd = (AMQDestination)destination;
        AMQShortString encodedDestination = amqd.getEncodedName();
        _destinationCache.put(encodedDestination, destination);
        this.getContentHeaderProperties().setReplyTo(encodedDestination);
    }

    @Override
    public Destination getJMSDestination() throws JMSException {
        return this._destination;
    }

    @Override
    public void setJMSDestination(Destination destination) {
        this._destination = destination;
    }

    @Override
    public void setContentType(String contentType) {
        this.getContentHeaderProperties().setContentType(contentType);
    }

    @Override
    public String getContentType() {
        return this.getContentHeaderProperties().getContentTypeAsString();
    }

    @Override
    public void setEncoding(String encoding) {
        this.getContentHeaderProperties().setEncoding(encoding);
    }

    @Override
    public String getEncoding() {
        return this.getContentHeaderProperties().getEncodingAsString();
    }

    @Override
    public String getReplyToString() {
        return this.getContentHeaderProperties().getReplyToAsString();
    }

    @Override
    public int getJMSDeliveryMode() throws JMSException {
        return this.getContentHeaderProperties().getDeliveryMode();
    }

    @Override
    public void setJMSDeliveryMode(int i) throws JMSException {
        this.getContentHeaderProperties().setDeliveryMode((byte)i);
    }

    public BasicContentHeaderProperties getContentHeaderProperties() {
        return (BasicContentHeaderProperties)this._contentHeaderProperties;
    }

    @Override
    public String getJMSType() throws JMSException {
        return this.getContentHeaderProperties().getTypeAsString();
    }

    @Override
    public void setJMSType(String string) throws JMSException {
        this.getContentHeaderProperties().setType(string);
    }

    @Override
    public long getJMSExpiration() throws JMSException {
        return this.getContentHeaderProperties().getExpiration();
    }

    @Override
    public void setJMSExpiration(long l) throws JMSException {
        this.getContentHeaderProperties().setExpiration(l);
    }

    @Override
    public boolean propertyExists(String propertyName) throws JMSException {
        return this.getJmsHeaders().propertyExists(propertyName);
    }

    @Override
    public boolean getBooleanProperty(String propertyName) throws JMSException {
        return this.getJmsHeaders().getBoolean(propertyName);
    }

    @Override
    public byte getByteProperty(String propertyName) throws JMSException {
        return this.getJmsHeaders().getByte(propertyName);
    }

    @Override
    public short getShortProperty(String propertyName) throws JMSException {
        return this.getJmsHeaders().getShort(propertyName);
    }

    @Override
    public int getIntProperty(String propertyName) throws JMSException {
        return this.getJmsHeaders().getInteger(propertyName);
    }

    @Override
    public long getLongProperty(String propertyName) throws JMSException {
        return this.getJmsHeaders().getLong(propertyName);
    }

    @Override
    public float getFloatProperty(String propertyName) throws JMSException {
        return this.getJmsHeaders().getFloat(propertyName);
    }

    @Override
    public double getDoubleProperty(String propertyName) throws JMSException {
        return this.getJmsHeaders().getDouble(propertyName);
    }

    @Override
    public String getStringProperty(String propertyName) throws JMSException {
        if (propertyName.equals(CustomJMSXProperty.JMSXUserID.toString())) {
            return ((BasicContentHeaderProperties)this._contentHeaderProperties).getUserIdAsString();
        }
        return this.getJmsHeaders().getString(propertyName);
    }

    @Override
    public Object getObjectProperty(String propertyName) throws JMSException {
        return this.getJmsHeaders().getObject(propertyName);
    }

    @Override
    public Enumeration getPropertyNames() throws JMSException {
        return this.getJmsHeaders().getPropertyNames();
    }

    @Override
    public void setBooleanProperty(String propertyName, boolean b) throws JMSException {
        this.checkWritableProperties();
        this.getJmsHeaders().setBoolean(propertyName, b);
    }

    @Override
    public void setByteProperty(String propertyName, byte b) throws JMSException {
        this.checkWritableProperties();
        this.getJmsHeaders().setByte(propertyName, (byte)new Byte(b));
    }

    @Override
    public void setShortProperty(String propertyName, short i) throws JMSException {
        this.checkWritableProperties();
        this.getJmsHeaders().setShort(propertyName, new Short(i));
    }

    @Override
    public void setIntProperty(String propertyName, int i) throws JMSException {
        this.checkWritableProperties();
        this.getJmsHeaders().setInteger(propertyName, (int)new Integer(i));
    }

    @Override
    public void setLongProperty(String propertyName, long l) throws JMSException {
        this.checkWritableProperties();
        this.getJmsHeaders().setLong(propertyName, new Long(l));
    }

    @Override
    public void setFloatProperty(String propertyName, float f) throws JMSException {
        this.checkWritableProperties();
        this.getJmsHeaders().setFloat(propertyName, new Float(f).floatValue());
    }

    @Override
    public void setDoubleProperty(String propertyName, double v) throws JMSException {
        this.checkWritableProperties();
        this.getJmsHeaders().setDouble(propertyName, new Double(v));
    }

    @Override
    public void setStringProperty(String propertyName, String value) throws JMSException {
        this.checkWritableProperties();
        this.getJmsHeaders().setString(propertyName, value);
    }

    @Override
    public void setObjectProperty(String propertyName, Object object) throws JMSException {
        this.checkWritableProperties();
        this.getJmsHeaders().setObject(propertyName, object);
    }

    @Override
    public void removeProperty(String propertyName) throws JMSException {
        this.getJmsHeaders().remove(propertyName);
    }

    private JMSHeaderAdapter getJmsHeaders() {
        return this._headerAdapter;
    }

    protected void checkWritableProperties() throws MessageNotWriteableException {
        if (this._readableProperties) {
            throw new MessageNotWriteableException("You need to call clearProperties() to make the message writable");
        }
        this._contentHeaderProperties.updated();
    }

    @Override
    public int getJMSPriority() throws JMSException {
        return this.getContentHeaderProperties().getPriority();
    }

    @Override
    public void setJMSPriority(int i) throws JMSException {
        this.getContentHeaderProperties().setPriority((byte)i);
    }

    @Override
    public void clearProperties() throws JMSException {
        this.getJmsHeaders().clear();
        this._readableProperties = false;
    }

    @Override
    public void acknowledgeThis() throws JMSException {
        if (this._session != null && this._session.getAcknowledgeMode() == 2) {
            if (this._session.getAMQConnection().isClosed()) {
                throw new IllegalStateException("Connection is already closed");
            }
            this._session.acknowledgeMessage(this._deliveryTag, true);
        }
    }

    @Override
    public void acknowledge() throws JMSException {
        if (this._session != null) {
            if (this._session.getAcknowledgeMode() == 2) {
                this._session.acknowledge();
            } else if (259 == this._session.getAcknowledgeMode()) {
                this._session.acknowledgeMessage(this._deliveryTag, false);
            }
        }
    }

    @Override
    public void setAMQSession(AMQSession s2) {
        this._session = s2;
    }

    @Override
    public AMQSession getAMQSession() {
        return this._session;
    }

    @Override
    public long getDeliveryTag() {
        return this._deliveryTag;
    }
}

