/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.client.message;

import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import org.wso2.andes.AMQException;
import org.wso2.andes.client.message.AMQMessageDelegate;
import org.wso2.andes.client.message.AMQMessageDelegateFactory;
import org.wso2.andes.client.message.AbstractJMSMessage;
import org.wso2.andes.transport.util.Functions;
import org.wso2.org.apache.mina.common.ByteBuffer;

public abstract class AbstractBytesMessage
extends AbstractJMSMessage {
    private static final int DEFAULT_BUFFER_INITIAL_SIZE = 1024;

    AbstractBytesMessage(AMQMessageDelegateFactory delegateFactory) {
        this(delegateFactory, null);
    }

    AbstractBytesMessage(AMQMessageDelegateFactory delegateFactory, ByteBuffer data) {
        super(delegateFactory, data);
        this.setContentType(this.getMimeType());
        if (this._data == null) {
            this.allocateInitialBuffer();
        }
    }

    protected void allocateInitialBuffer() {
        this._data = ByteBuffer.allocate(1024);
        this._data.setAutoExpand(true);
    }

    AbstractBytesMessage(AMQMessageDelegate delegate, ByteBuffer data) throws AMQException {
        super(delegate, data);
        this.setContentType(this.getMimeType());
    }

    @Override
    public void clearBodyImpl() throws JMSException {
        this.allocateInitialBuffer();
    }

    @Override
    public String toBodyString() throws JMSException {
        try {
            if (this._data != null) {
                return Functions.str(this._data.buf(), 100, 0);
            }
            return "";
        }
        catch (Exception e) {
            JMSException jmse = new JMSException(e.toString());
            jmse.setLinkedException(e);
            jmse.initCause(e);
            throw jmse;
        }
    }

    protected void checkAvailable(int len) throws MessageEOFException {
        if (this._data.remaining() < len) {
            throw new MessageEOFException("Unable to read " + len + " bytes");
        }
    }
}

