/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.client.message;

import java.io.UnsupportedEncodingException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import javax.jms.JMSException;
import javax.jms.TextMessage;
import org.wso2.andes.AMQException;
import org.wso2.andes.client.CustomJMSXProperty;
import org.wso2.andes.client.message.AMQMessageDelegate;
import org.wso2.andes.client.message.AMQMessageDelegateFactory;
import org.wso2.andes.client.message.AbstractJMSMessage;
import org.wso2.andes.util.Strings;
import org.wso2.org.apache.mina.common.ByteBuffer;

public class JMSTextMessage
extends AbstractJMSMessage
implements TextMessage {
    private static final String MIME_TYPE = "text/plain";
    private String _decodedValue;
    private static final String PAYLOAD_NULL_PROPERTY = CustomJMSXProperty.JMS_AMQP_NULL.toString();
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");

    public JMSTextMessage(AMQMessageDelegateFactory delegateFactory) throws JMSException {
        this(delegateFactory, null, null);
    }

    JMSTextMessage(AMQMessageDelegateFactory delegateFactory, ByteBuffer data, String encoding) throws JMSException {
        super(delegateFactory, data);
        this.setContentType(this.getMimeType());
        this.setEncoding(encoding);
    }

    JMSTextMessage(AMQMessageDelegate delegate, ByteBuffer data) throws AMQException {
        super(delegate, data);
        this.setContentType(this.getMimeType());
        this._data = data;
    }

    @Override
    public void clearBodyImpl() throws JMSException {
        if (this._data != null) {
            this._data.release();
            this._data = null;
        }
        this._decodedValue = null;
    }

    @Override
    public String toBodyString() throws JMSException {
        return this.getText();
    }

    @Override
    protected String getMimeType() {
        return MIME_TYPE;
    }

    @Override
    public void setText(String text) throws JMSException {
        this.checkWritable();
        this.clearBody();
        try {
            if (text != null) {
                String encoding = this.getEncoding();
                if (encoding == null || encoding.equalsIgnoreCase("UTF-8")) {
                    this._data = ByteBuffer.wrap(Strings.toUTF8(text));
                    this.setEncoding("UTF-8");
                } else {
                    this._data = ByteBuffer.wrap(text.getBytes(encoding));
                }
                this._data.position(this._data.limit());
                this._changedData = true;
            }
            this._decodedValue = text;
        }
        catch (UnsupportedEncodingException e) {
            JMSException jmse = new JMSException("Unable to decode text data");
            jmse.setLinkedException(e);
            jmse.initCause(e);
            throw jmse;
        }
    }

    @Override
    public String getText() throws JMSException {
        if (this._data == null && this._decodedValue == null) {
            return null;
        }
        if (this._decodedValue != null) {
            return this._decodedValue;
        }
        this._data.rewind();
        if (this.propertyExists(PAYLOAD_NULL_PROPERTY) && this.getBooleanProperty(PAYLOAD_NULL_PROPERTY)) {
            return null;
        }
        if (this.getEncoding() != null) {
            try {
                this._decodedValue = this._data.getString(Charset.forName(this.getEncoding()).newDecoder());
            }
            catch (CharacterCodingException e) {
                JMSException jmse = new JMSException("Could not decode string data: " + e);
                jmse.setLinkedException(e);
                jmse.initCause(e);
                throw jmse;
            }
        }
        try {
            this._decodedValue = this._data.getString(DEFAULT_CHARSET.newDecoder());
        }
        catch (CharacterCodingException e) {
            JMSException jmse = new JMSException("Could not decode string data: " + e);
            jmse.setLinkedException(e);
            jmse.initCause(e);
            throw jmse;
        }
        return this._decodedValue;
    }

    @Override
    public void prepareForSending() throws JMSException {
        super.prepareForSending();
        if (this._data == null) {
            this.setBooleanProperty(PAYLOAD_NULL_PROPERTY, true);
        } else {
            this.removeProperty(PAYLOAD_NULL_PROPERTY);
        }
    }
}

