/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.client.protocol;

import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.jms.JMSException;
import javax.security.sasl.SaslClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.andes.AMQException;
import org.wso2.andes.client.AMQConnection;
import org.wso2.andes.client.AMQSession;
import org.wso2.andes.client.ConnectionTuneParameters;
import org.wso2.andes.client.handler.ClientMethodDispatcherImpl;
import org.wso2.andes.client.message.UnprocessedMessage;
import org.wso2.andes.client.message.UnprocessedMessage_0_8;
import org.wso2.andes.client.protocol.AMQProtocolHandler;
import org.wso2.andes.client.state.AMQStateManager;
import org.wso2.andes.framing.AMQDataBlock;
import org.wso2.andes.framing.AMQMethodBody;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.ContentBody;
import org.wso2.andes.framing.ContentHeaderBody;
import org.wso2.andes.framing.HeartbeatBody;
import org.wso2.andes.framing.MethodDispatcher;
import org.wso2.andes.framing.MethodRegistry;
import org.wso2.andes.framing.ProtocolInitiation;
import org.wso2.andes.framing.ProtocolVersion;
import org.wso2.andes.protocol.AMQConstant;
import org.wso2.andes.protocol.AMQVersionAwareProtocolSession;
import org.wso2.andes.transport.Sender;

public class AMQProtocolSession
implements AMQVersionAwareProtocolSession {
    protected static final int LAST_WRITE_FUTURE_JOIN_TIMEOUT = 120000;
    protected static final Logger _logger = LoggerFactory.getLogger(AMQProtocolSession.class);
    public static final String PROTOCOL_INITIATION_RECEIVED = "ProtocolInitiatiionReceived";
    public static final int MAX_CHANNEL_MAX = 65535;
    public static final int MIN_USABLE_CHANNEL_NUM = 1;
    protected static final String CONNECTION_TUNE_PARAMETERS = "ConnectionTuneParameters";
    protected static final String AMQ_CONNECTION = "AMQConnection";
    protected static final String SASL_CLIENT = "SASLClient";
    protected final AMQProtocolHandler _protocolHandler;
    protected ConcurrentMap<Integer, AMQSession> _channelId2SessionMap = new ConcurrentHashMap<Integer, AMQSession>();
    protected ConcurrentMap _closingChannels = new ConcurrentHashMap();
    private final ConcurrentMap<Integer, UnprocessedMessage> _channelId2UnprocessedMsgMap = new ConcurrentHashMap<Integer, UnprocessedMessage>();
    private final UnprocessedMessage[] _channelId2UnprocessedMsgArray = new UnprocessedMessage[16];
    protected int _queueId = 1;
    protected final Object _queueIdLock = new Object();
    private ProtocolVersion _protocolVersion;
    private MethodRegistry _methodRegistry = MethodRegistry.getMethodRegistry(ProtocolVersion.getLatestSupportedVersion());
    private MethodDispatcher _methodDispatcher;
    protected final AMQConnection _connection;
    private ConnectionTuneParameters _connectionTuneParameters;
    private SaslClient _saslClient;
    private static final int FAST_CHANNEL_ACCESS_MASK = -16;

    public AMQProtocolSession(AMQProtocolHandler protocolHandler, AMQConnection connection) {
        this._protocolHandler = protocolHandler;
        this._protocolVersion = connection.getProtocolVersion();
        _logger.debug("Using ProtocolVersion for Session:" + this._protocolVersion);
        this._methodDispatcher = ClientMethodDispatcherImpl.newMethodDispatcher(ProtocolVersion.getLatestSupportedVersion(), this);
        this._connection = connection;
    }

    @Override
    public void init() {
        this._protocolHandler.writeFrame(new ProtocolInitiation(this._connection.getProtocolVersion()));
    }

    @Override
    public boolean isBlocked() {
        return false;
    }

    public String getClientID() {
        try {
            return this.getAMQConnection().getClientID();
        }
        catch (JMSException e) {
            return null;
        }
    }

    public void setClientID(String clientID) throws JMSException {
        this.getAMQConnection().setClientID(clientID);
    }

    public AMQStateManager getStateManager() {
        return this._protocolHandler.getStateManager();
    }

    public String getVirtualHost() {
        return this.getAMQConnection().getVirtualHost();
    }

    public SaslClient getSaslClient() {
        return this._saslClient;
    }

    public void setSaslClient(SaslClient client) {
        this._saslClient = client;
    }

    public ConnectionTuneParameters getConnectionTuneParameters() {
        return this._connectionTuneParameters;
    }

    public void setConnectionTuneParameters(ConnectionTuneParameters params) {
        this._connectionTuneParameters = params;
        AMQConnection con = this.getAMQConnection();
        con.setMaximumChannelCount(params.getChannelMax());
        con.setMaximumFrameSize(params.getFrameMax());
        this._protocolHandler.initHeartbeats(params.getHeartbeat());
    }

    public void unprocessedMessageReceived(int channelId, UnprocessedMessage message) throws AMQException {
        if ((channelId & 0xFFFFFFF0) == 0) {
            this._channelId2UnprocessedMsgArray[channelId] = message;
        } else {
            this._channelId2UnprocessedMsgMap.put(channelId, message);
        }
    }

    @Override
    public void contentHeaderReceived(int channelId, ContentHeaderBody contentHeader) throws AMQException {
        UnprocessedMessage_0_8 msg = (UnprocessedMessage_0_8)((channelId & 0xFFFFFFF0) == 0 ? this._channelId2UnprocessedMsgArray[channelId] : (UnprocessedMessage)this._channelId2UnprocessedMsgMap.get(channelId));
        if (msg == null) {
            throw new AMQException(null, "Error: received content header without having received a BasicDeliver frame first on session:" + this, null);
        }
        if (msg.getContentHeader() != null) {
            throw new AMQException(null, "Error: received duplicate content header or did not receive correct number of content body frames on session:" + this, null);
        }
        msg.setContentHeader(contentHeader);
        if (contentHeader.bodySize == 0L) {
            this.deliverMessageToAMQSession(channelId, msg);
        }
    }

    @Override
    public void contentBodyReceived(int channelId, ContentBody contentBody) throws AMQException {
        boolean fastAccess = (channelId & 0xFFFFFFF0) == 0;
        UnprocessedMessage_0_8 msg = fastAccess ? (UnprocessedMessage_0_8)this._channelId2UnprocessedMsgArray[channelId] : (UnprocessedMessage_0_8)this._channelId2UnprocessedMsgMap.get(channelId);
        if (msg == null) {
            throw new AMQException(null, "Error: received content body without having received a JMSDeliver frame first", null);
        }
        if (msg.getContentHeader() == null) {
            if (fastAccess) {
                this._channelId2UnprocessedMsgArray[channelId] = null;
            } else {
                this._channelId2UnprocessedMsgMap.remove(channelId);
            }
            throw new AMQException(null, "Error: received content body without having received a ContentHeader frame first", null);
        }
        msg.receiveBody(contentBody);
        if (msg.isAllBodyDataReceived()) {
            this.deliverMessageToAMQSession(channelId, msg);
        }
    }

    @Override
    public void heartbeatBodyReceived(int channelId, HeartbeatBody body) throws AMQException {
    }

    private void deliverMessageToAMQSession(int channelId, UnprocessedMessage msg) {
        AMQSession session = this.getSession(channelId);
        if (session == null) {
            _logger.warn("receive a message for non-existing channel " + channelId);
        } else {
            session.messageReceived(msg);
            if ((channelId & 0xFFFFFFF0) == 0) {
                this._channelId2UnprocessedMsgArray[channelId] = null;
            } else {
                this._channelId2UnprocessedMsgMap.remove(channelId);
            }
        }
    }

    protected AMQSession getSession(int channelId) {
        return this._connection.getSession(channelId);
    }

    @Override
    public void writeFrame(AMQDataBlock frame) {
        this._protocolHandler.writeFrame(frame);
    }

    public void writeFrame(AMQDataBlock frame, boolean wait) {
        this._protocolHandler.writeFrame(frame, wait);
    }

    public void closeSession(AMQSession session) {
        _logger.debug("closeSession called on protocol session for session " + session.getChannelId());
        int channelId = session.getChannelId();
        if (channelId <= 0) {
            throw new IllegalArgumentException("Attempt to close a channel with id < 0");
        }
        this._closingChannels.putIfAbsent(channelId, session);
    }

    public boolean channelClosed(int channelId, AMQConstant code, String text) throws AMQException {
        if (this._closingChannels.remove(channelId) == null) {
            AMQSession session = this.getSession(channelId);
            try {
                session.closed(new AMQException(code, text, null));
            }
            catch (JMSException e) {
                throw new AMQException(null, "JMSException received while closing session", e);
            }
            return true;
        }
        return false;
    }

    public AMQConnection getAMQConnection() {
        return this._connection;
    }

    public void closeProtocolSession() throws AMQException {
        this._protocolHandler.closeConnection(0L);
    }

    public void failover(String host, int port) {
        this._protocolHandler.failover(host, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AMQShortString generateQueueName() {
        int id;
        Object object = this._queueIdLock;
        synchronized (object) {
            id = this._queueId++;
        }
        String localAddress = this._protocolHandler.getLocalAddress().toString().replaceAll("[./:;]", "_");
        String queueName = "tmp_" + localAddress + "_" + id;
        return new AMQShortString(queueName.replaceAll("_+", "_"));
    }

    public void confirmConsumerCancelled(int channelId, AMQShortString consumerTag) {
        AMQSession session = this.getSession(channelId);
        session.confirmConsumerCancelled(consumerTag.toIntValue());
    }

    public void setProtocolVersion(ProtocolVersion pv) {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Setting ProtocolVersion to :" + pv);
        }
        this._protocolVersion = pv;
        this._methodRegistry = MethodRegistry.getMethodRegistry(pv);
        this._methodDispatcher = ClientMethodDispatcherImpl.newMethodDispatcher(pv, this);
    }

    @Override
    public byte getProtocolMinorVersion() {
        return this._protocolVersion.getMinorVersion();
    }

    @Override
    public byte getProtocolMajorVersion() {
        return this._protocolVersion.getMajorVersion();
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this._protocolVersion;
    }

    @Override
    public MethodRegistry getMethodRegistry() {
        return this._methodRegistry;
    }

    public MethodDispatcher getMethodDispatcher() {
        return this._methodDispatcher;
    }

    public void setTicket(int ticket, int channelId) {
        AMQSession session = this.getSession(channelId);
        session.setTicket(ticket);
    }

    public void setMethodDispatcher(MethodDispatcher methodDispatcher) {
        this._methodDispatcher = methodDispatcher;
    }

    public void setFlowControl(int channelId, boolean active) {
        AMQSession session = this.getSession(channelId);
        if (null == session) {
            _logger.warn("Unable to find the session (channelID : " + channelId + " ) to set flow control. ");
            return;
        }
        session.setFlowControl(active);
    }

    @Override
    public void methodFrameReceived(int channel, AMQMethodBody amqMethodBody) throws AMQException {
        this._protocolHandler.methodBodyReceived(channel, amqMethodBody);
    }

    public void notifyError(Exception error) {
        this._protocolHandler.propagateExceptionToAllWaiters(error);
    }

    @Override
    public void setSender(Sender<ByteBuffer> sender) {
    }

    public String toString() {
        return "AMQProtocolSession[" + this._connection + ']';
    }
}

