/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.filter;

import java.util.HashMap;
import javax.jms.JMSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.andes.AMQInternalException;
import org.wso2.andes.client.message.AbstractJMSMessage;
import org.wso2.andes.filter.Expression;

public class PropertyExpression
implements Expression {
    private static final int DEFAULT_PRIORITY = 4;
    private static final Logger _logger = LoggerFactory.getLogger(PropertyExpression.class);
    private static final HashMap<String, Expression> JMS_PROPERTY_EXPRESSIONS = new HashMap();
    private final String name;
    private final Expression jmsPropertyExpression;

    public PropertyExpression(String name) {
        this.name = name;
        this.jmsPropertyExpression = JMS_PROPERTY_EXPRESSIONS.get(name);
    }

    @Override
    public Object evaluate(AbstractJMSMessage message) throws AMQInternalException {
        if (this.jmsPropertyExpression != null) {
            return this.jmsPropertyExpression.evaluate(message);
        }
        try {
            if (_logger.isDebugEnabled()) {
                _logger.debug("Looking up property:" + this.name);
                _logger.debug("Properties are:" + message.getPropertyNames());
            }
            return message.getObjectProperty(this.name);
        }
        catch (JMSException e) {
            throw new AMQInternalException("Exception evaluating properties for filter", e);
        }
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        return this.name.equals(((PropertyExpression)o).name);
    }

    static {
        JMS_PROPERTY_EXPRESSIONS.put("JMSDestination", new Expression(){

            @Override
            public Object evaluate(AbstractJMSMessage message) {
                return null;
            }
        });
        JMS_PROPERTY_EXPRESSIONS.put("JMSReplyTo", new Expression(){

            @Override
            public Object evaluate(AbstractJMSMessage message) {
                return message.getReplyToString();
            }
        });
        JMS_PROPERTY_EXPRESSIONS.put("JMSType", new Expression(){

            @Override
            public Object evaluate(AbstractJMSMessage message) {
                try {
                    return message.getJMSType();
                }
                catch (JMSException e) {
                    _logger.warn("Error evaluating property", e);
                    return null;
                }
            }
        });
        JMS_PROPERTY_EXPRESSIONS.put("JMSDeliveryMode", new Expression(){

            @Override
            public Object evaluate(AbstractJMSMessage message) {
                JMSDeliveryMode mode = JMSDeliveryMode.NON_PERSISTENT;
                try {
                    JMSDeliveryMode jMSDeliveryMode = mode = message.getJMSDeliveryMode() == 2 ? JMSDeliveryMode.PERSISTENT : JMSDeliveryMode.NON_PERSISTENT;
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("JMSDeliveryMode is :" + (Object)((Object)mode));
                    }
                }
                catch (JMSException e) {
                    _logger.warn("Error evaluating property", e);
                }
                return mode.toString();
            }
        });
        JMS_PROPERTY_EXPRESSIONS.put("JMSPriority", new Expression(){

            @Override
            public Object evaluate(AbstractJMSMessage message) {
                try {
                    return message.getJMSPriority();
                }
                catch (Exception e) {
                    _logger.warn("Error evaluating property", e);
                    return 4;
                }
            }
        });
        JMS_PROPERTY_EXPRESSIONS.put("AMQMessageID", new Expression(){

            @Override
            public Object evaluate(AbstractJMSMessage message) {
                try {
                    return message.getJMSMessageID();
                }
                catch (JMSException e) {
                    _logger.warn("Error evaluating property", e);
                    return null;
                }
            }
        });
        JMS_PROPERTY_EXPRESSIONS.put("JMSTimestamp", new Expression(){

            @Override
            public Object evaluate(AbstractJMSMessage message) {
                try {
                    return message.getJMSTimestamp();
                }
                catch (Exception e) {
                    _logger.warn("Error evaluating property", e);
                    return null;
                }
            }
        });
        JMS_PROPERTY_EXPRESSIONS.put("JMSCorrelationID", new Expression(){

            @Override
            public Object evaluate(AbstractJMSMessage message) {
                try {
                    return message.getJMSCorrelationID();
                }
                catch (JMSException e) {
                    _logger.warn("Error evaluating property", e);
                    return null;
                }
            }
        });
        JMS_PROPERTY_EXPRESSIONS.put("JMSExpiration", new Expression(){

            @Override
            public Object evaluate(AbstractJMSMessage message) {
                try {
                    return message.getJMSExpiration();
                }
                catch (JMSException e) {
                    _logger.warn("Error evaluating property", e);
                    return null;
                }
            }
        });
        JMS_PROPERTY_EXPRESSIONS.put("JMSRedelivered", new Expression(){

            @Override
            public Object evaluate(AbstractJMSMessage message) {
                try {
                    return message.getJMSRedelivered();
                }
                catch (JMSException e) {
                    _logger.warn("Error evaluating property", e);
                    return null;
                }
            }
        });
        JMS_PROPERTY_EXPRESSIONS.put("JMSMessageID", new Expression(){

            @Override
            public Object evaluate(AbstractJMSMessage message) {
                try {
                    return message.getJMSMessageID();
                }
                catch (Exception e) {
                    _logger.warn("Error evaluating property", e);
                    return null;
                }
            }
        });
    }

    private static enum JMSDeliveryMode {
        NON_PERSISTENT,
        PERSISTENT;

    }
}

