/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.framing;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.andes.framing.AMQShortStringTokenizer;
import org.wso2.org.apache.mina.common.ByteBuffer;

public final class AMQShortString
implements CharSequence,
Comparable<AMQShortString> {
    public static final int MAX_LENGTH = 255;
    private static final byte MINUS = 45;
    private static final byte ZERO = 48;
    private static final ThreadLocal<Map<AMQShortString, WeakReference<AMQShortString>>> _localInternMap = new ThreadLocal<Map<AMQShortString, WeakReference<AMQShortString>>>(){

        @Override
        protected Map<AMQShortString, WeakReference<AMQShortString>> initialValue() {
            return new WeakHashMap<AMQShortString, WeakReference<AMQShortString>>();
        }
    };
    private static final Map<AMQShortString, WeakReference<AMQShortString>> _globalInternMap = new WeakHashMap<AMQShortString, WeakReference<AMQShortString>>();
    private static final Logger _logger = LoggerFactory.getLogger(AMQShortString.class);
    private final byte[] _data;
    private final int _offset;
    private int _hashCode;
    private String _asString = null;
    private final int _length;
    private static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final AMQShortString EMPTY_STRING = new AMQShortString((String)null);

    private AMQShortString substring(int from, int to) {
        return new AMQShortString(this._data, from + this._offset, to + this._offset);
    }

    public AMQShortString(byte[] data) {
        if (data == null) {
            throw new NullPointerException("Cannot create AMQShortString with null data[]");
        }
        if (data.length > 255) {
            throw new IllegalArgumentException("Cannot create AMQShortString with number of octets over 255!");
        }
        this._data = (byte[])data.clone();
        this._length = data.length;
        this._offset = 0;
    }

    public AMQShortString(String data) {
        this(data == null ? EMPTY_CHAR_ARRAY : data.toCharArray());
        this._asString = data;
    }

    public AMQShortString(char[] data) {
        if (data == null) {
            throw new NullPointerException("Cannot create AMQShortString with null char[]");
        }
        if (data.length > 255) {
            throw new IllegalArgumentException("Cannot create AMQShortString with number of octets over 255!");
        }
        int length = data.length;
        byte[] stringBytes = new byte[length];
        int hash = 0;
        for (int i = 0; i < length; ++i) {
            stringBytes[i] = (byte)(0xFF & data[i]);
            hash = 31 * hash + stringBytes[i];
        }
        this._hashCode = hash;
        this._data = stringBytes;
        this._length = length;
        this._offset = 0;
    }

    public AMQShortString(CharSequence charSequence) {
        if (charSequence == null) {
            charSequence = "";
        }
        if (charSequence.length() > 255) {
            throw new IllegalArgumentException("Cannot create AMQShortString with number of octets over 255!");
        }
        int length = charSequence.length();
        byte[] stringBytes = new byte[length];
        int hash = 0;
        for (int i = 0; i < length; ++i) {
            stringBytes[i] = (byte)(0xFF & charSequence.charAt(i));
            hash = 31 * hash + stringBytes[i];
        }
        this._data = stringBytes;
        this._hashCode = hash;
        this._length = length;
        this._offset = 0;
    }

    private AMQShortString(ByteBuffer data, int length) {
        if (length > 255) {
            throw new IllegalArgumentException("Cannot create AMQShortString with number of octets over 255!");
        }
        if (data.isDirect() || data.isReadOnly()) {
            byte[] dataBytes = new byte[length];
            data.get(dataBytes);
            this._data = dataBytes;
            this._offset = 0;
        } else {
            this._data = data.array();
            this._offset = data.arrayOffset() + data.position();
            data.skip(length);
        }
        this._length = length;
    }

    private AMQShortString(byte[] data, int from, int to) {
        if (data == null) {
            throw new NullPointerException("Cannot create AMQShortString with null data[]");
        }
        int length = to - from;
        if (length > 255) {
            throw new IllegalArgumentException("Cannot create AMQShortString with number of octets over 255!");
        }
        this._offset = from;
        this._length = length;
        this._data = data;
    }

    public AMQShortString shrink() {
        if (this._data.length != this._length) {
            byte[] dataBytes = new byte[this._length];
            System.arraycopy(this._data, this._offset, dataBytes, 0, this._length);
            return new AMQShortString(dataBytes, 0, this._length);
        }
        return this;
    }

    @Override
    public int length() {
        return this._length;
    }

    @Override
    public char charAt(int index) {
        return (char)this._data[this._offset + index];
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new CharSubSequence(start, end);
    }

    public static AMQShortString readFromBuffer(ByteBuffer buffer) {
        short length = buffer.getUnsigned();
        if (length == 0) {
            return null;
        }
        return new AMQShortString(buffer, length);
    }

    public byte[] getBytes() {
        if (this._offset == 0 && this._length == this._data.length) {
            return (byte[])this._data.clone();
        }
        byte[] data = new byte[this._length];
        System.arraycopy(this._data, this._offset, data, 0, this._length);
        return data;
    }

    public void writeToBuffer(ByteBuffer buffer) {
        int size = this.length();
        buffer.put((byte)size);
        buffer.put(this._data, this._offset, size);
    }

    public boolean endsWith(String s2) {
        return this.endsWith(new AMQShortString(s2));
    }

    public boolean endsWith(AMQShortString otherString) {
        if (otherString.length() > this.length()) {
            return false;
        }
        int thisLength = this.length();
        int otherLength = otherString.length();
        for (int i = 1; i <= otherLength; ++i) {
            if (this.charAt(thisLength - i) == otherString.charAt(otherLength - i)) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(String s2) {
        return this.startsWith(new AMQShortString(s2));
    }

    public boolean startsWith(AMQShortString otherString) {
        if (otherString.length() > this.length()) {
            return false;
        }
        for (int i = 0; i < otherString.length(); ++i) {
            if (this.charAt(i) == otherString.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(CharSequence otherString) {
        if (otherString.length() > this.length()) {
            return false;
        }
        for (int i = 0; i < otherString.length(); ++i) {
            if (this.charAt(i) == otherString.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public char[] asChars() {
        int size = this.length();
        char[] chars = new char[size];
        for (int i = 0; i < size; ++i) {
            chars[i] = (char)this._data[i + this._offset];
        }
        return chars;
    }

    public String asString() {
        if (this._asString == null) {
            this._asString = new String(this.asChars());
        }
        return this._asString;
    }

    public boolean equals(Object o) {
        if (o instanceof AMQShortString) {
            return this.equals((AMQShortString)o);
        }
        if (o instanceof CharSequence) {
            return this.equals((CharSequence)o);
        }
        if (o == null) {
            return false;
        }
        return o == this;
    }

    public boolean equals(AMQShortString otherString) {
        if (otherString == this) {
            return true;
        }
        if (otherString == null) {
            return false;
        }
        int hashCode = this._hashCode;
        int otherHashCode = otherString._hashCode;
        if (hashCode != 0 && otherHashCode != 0 && hashCode != otherHashCode) {
            return false;
        }
        int length = this._length;
        if (length != otherString._length) {
            return false;
        }
        byte[] data = this._data;
        byte[] otherData = otherString._data;
        int offset = this._offset;
        int otherOffset = otherString._offset;
        if (offset == 0 && otherOffset == 0 && length == data.length && length == otherData.length) {
            return Arrays.equals(data, otherData);
        }
        int thisIdx = offset;
        int otherIdx = otherOffset;
        int i = length;
        while (i-- != 0) {
            if (data[thisIdx++] == otherData[otherIdx++]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(CharSequence s2) {
        if (s2 instanceof AMQShortString) {
            return this.equals((AMQShortString)s2);
        }
        if (s2 == null) {
            return false;
        }
        if (s2.length() != this.length()) {
            return false;
        }
        for (int i = 0; i < this.length(); ++i) {
            if (this.charAt(i) == s2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = this._hashCode;
        if (hash == 0) {
            int size = this.length();
            for (int i = 0; i < size; ++i) {
                hash = 31 * hash + this._data[i + this._offset];
            }
            this._hashCode = hash;
        }
        return hash;
    }

    public void setDirty() {
        this._hashCode = 0;
    }

    @Override
    public String toString() {
        return this.asString();
    }

    @Override
    public int compareTo(AMQShortString name) {
        if (name == null) {
            return 1;
        }
        if (name.length() < this.length()) {
            return -name.compareTo(this);
        }
        for (int i = 0; i < this.length(); ++i) {
            byte d = this._data[i + this._offset];
            byte n = name._data[i + name._offset];
            if (d < n) {
                return -1;
            }
            if (d <= n) continue;
            return 1;
        }
        return this.length() == name.length() ? 0 : -1;
    }

    public AMQShortStringTokenizer tokenize(byte delim) {
        return new TokenizerImpl(delim);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AMQShortString intern() {
        AMQShortString internString;
        this.hashCode();
        Map<AMQShortString, WeakReference<AMQShortString>> localMap = _localInternMap.get();
        WeakReference<AMQShortString> ref = localMap.get(this);
        if (ref != null && (internString = (AMQShortString)ref.get()) != null) {
            return internString;
        }
        Map<AMQShortString, WeakReference<AMQShortString>> map = _globalInternMap;
        synchronized (map) {
            ref = _globalInternMap.get(this);
            if (ref == null || (internString = (AMQShortString)ref.get()) == null) {
                internString = this.shrink();
                ref = new WeakReference<AMQShortString>(internString);
                _globalInternMap.put(internString, ref);
            }
        }
        localMap.put(internString, ref);
        return internString;
    }

    private int occurences(byte delim) {
        int count = 0;
        int end = this._offset + this._length;
        for (int i = this._offset; i < end; ++i) {
            if (this._data[i] != delim) continue;
            ++count;
        }
        return count;
    }

    private int indexOf(byte val, int pos) {
        for (int i = pos; i < this.length(); ++i) {
            if (this._data[this._offset + i] != val) continue;
            return i;
        }
        return -1;
    }

    public static AMQShortString join(Collection<AMQShortString> terms, AMQShortString delim) {
        if (terms.size() == 0) {
            return EMPTY_STRING;
        }
        int size = delim.length() * (terms.size() - 1);
        for (AMQShortString term : terms) {
            size += term.length();
        }
        if (size > 255) {
            throw new IllegalArgumentException("Cannot create AMQShortString with number of octets over 255!");
        }
        byte[] data = new byte[size];
        int pos = 0;
        byte[] delimData = delim._data;
        int delimOffset = delim._offset;
        int delimLength = delim._length;
        for (AMQShortString term : terms) {
            if (pos != 0) {
                System.arraycopy(delimData, delimOffset, data, pos, delimLength);
                pos += delimLength;
            }
            System.arraycopy(term._data, term._offset, data, pos, term._length);
            pos += term._length;
        }
        return new AMQShortString(data, 0, size);
    }

    public int toIntValue() {
        boolean isNegative;
        int pos = this._offset;
        int val = 0;
        boolean bl = isNegative = this._data[pos] == 45;
        if (isNegative) {
            ++pos;
        }
        int end = this._length + this._offset;
        while (pos < end) {
            int digit;
            if ((digit = this._data[pos++] - 48) < 0 || digit > 9) {
                throw new NumberFormatException("\"" + this.toString() + "\" is not a valid number");
            }
            val *= 10;
            val += digit;
        }
        if (isNegative) {
            val *= -1;
        }
        return val;
    }

    public boolean contains(byte b) {
        int end = this._length + this._offset;
        for (int i = this._offset; i < end; ++i) {
            if (this._data[i] != b) continue;
            return true;
        }
        return false;
    }

    public static AMQShortString valueOf(Object obj) {
        return obj == null ? null : new AMQShortString(String.valueOf(obj));
    }

    public static void main(String[] args) {
        AMQShortString s2 = new AMQShortString("a.b.c.d.e.f.g.h.i.j.k");
        AMQShortString s22 = s2.substring(2, 7);
        AMQShortStringTokenizer t = s22.tokenize((byte)46);
        while (t.hasMoreTokens()) {
            System.err.println(t.nextToken());
        }
    }

    public static AMQShortString toLowerCase(AMQShortString stringToConvert) {
        if (null != stringToConvert) {
            return new AMQShortString(stringToConvert.asString().toLowerCase());
        }
        return null;
    }

    private final class CharSubSequence
    implements CharSequence {
        private final int _sequenceOffset;
        private final int _end;

        public CharSubSequence(int offset, int end) {
            this._sequenceOffset = offset;
            this._end = end;
        }

        @Override
        public int length() {
            return this._end - this._sequenceOffset;
        }

        @Override
        public char charAt(int index) {
            return AMQShortString.this.charAt(index + this._sequenceOffset);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return new CharSubSequence(start + this._sequenceOffset, end + this._sequenceOffset);
        }
    }

    private final class TokenizerImpl
    implements AMQShortStringTokenizer {
        private final byte _delim;
        private int _count = -1;
        private int _pos = 0;

        public TokenizerImpl(byte delim) {
            this._delim = delim;
        }

        @Override
        public int countTokens() {
            if (this._count == -1) {
                this._count = 1 + AMQShortString.this.occurences(this._delim);
            }
            return this._count;
        }

        @Override
        public AMQShortString nextToken() {
            if (this._pos <= AMQShortString.this.length()) {
                int nextDelim = AMQShortString.this.indexOf(this._delim, this._pos);
                if (nextDelim == -1) {
                    nextDelim = AMQShortString.this.length();
                }
                AMQShortString nextToken = AMQShortString.this.substring(this._pos, nextDelim++);
                this._pos = nextDelim;
                return nextToken;
            }
            return null;
        }

        @Override
        public boolean hasMoreTokens() {
            return this._pos <= AMQShortString.this.length();
        }
    }
}

