/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.framing;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import org.wso2.andes.framing.AMQType;
import org.wso2.andes.framing.AMQTypeMap;
import org.wso2.andes.framing.FieldTable;
import org.wso2.org.apache.mina.common.ByteBuffer;

public class AMQTypedValue {
    private final AMQType _type;
    private final Object _value;

    public AMQTypedValue(AMQType type, Object value) {
        if (type == null) {
            throw new NullPointerException("Cannot create a typed value with null type");
        }
        this._type = type;
        this._value = type.toNativeValue(value);
    }

    private AMQTypedValue(AMQType type, ByteBuffer buffer) {
        this._type = type;
        this._value = type.readValueFromBuffer(buffer);
    }

    public AMQType getType() {
        return this._type;
    }

    public Object getValue() {
        return this._value;
    }

    public void writeToBuffer(ByteBuffer buffer) {
        this._type.writeToBuffer(this._value, buffer);
    }

    public int getEncodingSize() {
        return this._type.getEncodingSize(this._value);
    }

    public static AMQTypedValue readFromBuffer(ByteBuffer buffer) {
        AMQType type = AMQTypeMap.getType(buffer.get());
        return new AMQTypedValue(type, buffer);
    }

    public String toString() {
        return "[" + (Object)((Object)this.getType()) + ": " + this.getValue() + "]";
    }

    public boolean equals(Object o) {
        if (o instanceof AMQTypedValue) {
            AMQTypedValue other = (AMQTypedValue)o;
            return this._type == other._type && (this._value == null ? other._value == null : this._value.equals(other._value));
        }
        return false;
    }

    public int hashCode() {
        return this._type.hashCode() ^ (this._value == null ? 0 : this._value.hashCode());
    }

    public static AMQTypedValue toTypedValue(Object val) {
        if (val == null) {
            return AMQType.VOID.asTypedValue(null);
        }
        Class<?> klass = val.getClass();
        if (klass == String.class) {
            return AMQType.ASCII_STRING.asTypedValue(val);
        }
        if (klass == Character.class) {
            return AMQType.ASCII_CHARACTER.asTypedValue(val);
        }
        if (klass == Integer.class) {
            return AMQType.INT.asTypedValue(val);
        }
        if (klass == Long.class) {
            return AMQType.LONG.asTypedValue(val);
        }
        if (klass == Float.class) {
            return AMQType.FLOAT.asTypedValue(val);
        }
        if (klass == Double.class) {
            return AMQType.DOUBLE.asTypedValue(val);
        }
        if (klass == Date.class) {
            return AMQType.TIMESTAMP.asTypedValue(val);
        }
        if (klass == Byte.class) {
            return AMQType.BYTE.asTypedValue(val);
        }
        if (klass == Boolean.class) {
            return AMQType.BOOLEAN.asTypedValue(val);
        }
        if (klass == byte[].class) {
            return AMQType.BINARY.asTypedValue(val);
        }
        if (klass == BigDecimal.class) {
            return AMQType.DECIMAL.asTypedValue(val);
        }
        if (val instanceof Map) {
            return AMQType.FIELD_TABLE.asTypedValue(FieldTable.convertToFieldTable((Map)val));
        }
        return null;
    }
}

