/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.framing.amqp_0_9;

import org.wso2.andes.AMQException;
import org.wso2.andes.framing.AMQFrameDecodingException;
import org.wso2.andes.framing.AMQMethodBody;
import org.wso2.andes.framing.AMQMethodBodyInstanceFactory;
import org.wso2.andes.framing.FileAckBody;
import org.wso2.andes.framing.MethodDispatcher;
import org.wso2.andes.framing.amqp_0_9.AMQMethodBody_0_9;
import org.wso2.andes.framing.amqp_0_9.MethodDispatcher_0_9;
import org.wso2.org.apache.mina.common.ByteBuffer;

public class FileAckBodyImpl
extends AMQMethodBody_0_9
implements FileAckBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        @Override
        public AMQMethodBody newInstance(ByteBuffer in, long size) throws AMQFrameDecodingException {
            return new FileAckBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 70;
    public static final int METHOD_ID = 90;
    private final long _deliveryTag;
    private final byte _bitfield0;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public FileAckBodyImpl(ByteBuffer buffer) throws AMQFrameDecodingException {
        this._deliveryTag = this.readLong(buffer);
        this._bitfield0 = this.readBitfield(buffer);
    }

    public FileAckBodyImpl(long deliveryTag, boolean multiple) {
        this._deliveryTag = deliveryTag;
        byte bitfield0 = 0;
        if (multiple) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        this._bitfield0 = bitfield0;
    }

    @Override
    public int getClazz() {
        return 70;
    }

    @Override
    public int getMethod() {
        return 90;
    }

    @Override
    public final long getDeliveryTag() {
        return this._deliveryTag;
    }

    @Override
    public final boolean getMultiple() {
        return (this._bitfield0 & 1) != 0;
    }

    @Override
    protected int getBodySize() {
        int size = 9;
        return size;
    }

    @Override
    public void writeMethodPayload(ByteBuffer buffer) {
        this.writeLong(buffer, this._deliveryTag);
        this.writeBitfield(buffer, this._bitfield0);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_0_9)dispatcher).dispatchFileAck(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[FileAckBodyImpl: ");
        buf.append("deliveryTag=");
        buf.append(this.getDeliveryTag());
        buf.append(", ");
        buf.append("multiple=");
        buf.append(this.getMultiple());
        buf.append("]");
        return buf.toString();
    }
}

