/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.framing.amqp_0_9;

import org.wso2.andes.AMQException;
import org.wso2.andes.framing.AMQFrameDecodingException;
import org.wso2.andes.framing.AMQMethodBody;
import org.wso2.andes.framing.AMQMethodBodyInstanceFactory;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.FieldTable;
import org.wso2.andes.framing.MethodDispatcher;
import org.wso2.andes.framing.StreamConsumeBody;
import org.wso2.andes.framing.amqp_0_9.AMQMethodBody_0_9;
import org.wso2.andes.framing.amqp_0_9.MethodDispatcher_0_9;
import org.wso2.org.apache.mina.common.ByteBuffer;

public class StreamConsumeBodyImpl
extends AMQMethodBody_0_9
implements StreamConsumeBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        @Override
        public AMQMethodBody newInstance(ByteBuffer in, long size) throws AMQFrameDecodingException {
            return new StreamConsumeBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 80;
    public static final int METHOD_ID = 20;
    private final int _ticket;
    private final AMQShortString _queue;
    private final AMQShortString _consumerTag;
    private final byte _bitfield0;
    private final FieldTable _filter;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public StreamConsumeBodyImpl(ByteBuffer buffer) throws AMQFrameDecodingException {
        this._ticket = this.readUnsignedShort(buffer);
        this._queue = this.readAMQShortString(buffer);
        this._consumerTag = this.readAMQShortString(buffer);
        this._bitfield0 = this.readBitfield(buffer);
        this._filter = this.readFieldTable(buffer);
    }

    public StreamConsumeBodyImpl(int ticket, AMQShortString queue, AMQShortString consumerTag, boolean noLocal, boolean exclusive, boolean nowait, FieldTable filter) {
        this._ticket = ticket;
        this._queue = queue;
        this._consumerTag = consumerTag;
        byte bitfield0 = 0;
        if (noLocal) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        if (exclusive) {
            bitfield0 = (byte)(bitfield0 | 2);
        }
        if (nowait) {
            bitfield0 = (byte)(bitfield0 | 4);
        }
        this._bitfield0 = bitfield0;
        this._filter = filter;
    }

    @Override
    public int getClazz() {
        return 80;
    }

    @Override
    public int getMethod() {
        return 20;
    }

    @Override
    public final int getTicket() {
        return this._ticket;
    }

    @Override
    public final AMQShortString getQueue() {
        return this._queue;
    }

    @Override
    public final AMQShortString getConsumerTag() {
        return this._consumerTag;
    }

    @Override
    public final boolean getNoLocal() {
        return (this._bitfield0 & 1) != 0;
    }

    @Override
    public final boolean getExclusive() {
        return (this._bitfield0 & 2) != 0;
    }

    @Override
    public final boolean getNowait() {
        return (this._bitfield0 & 4) != 0;
    }

    public final FieldTable getFilter() {
        return this._filter;
    }

    @Override
    protected int getBodySize() {
        int size = 3;
        size += this.getSizeOf(this._queue);
        size += this.getSizeOf(this._consumerTag);
        return size += this.getSizeOf(this._filter);
    }

    @Override
    public void writeMethodPayload(ByteBuffer buffer) {
        this.writeUnsignedShort(buffer, this._ticket);
        this.writeAMQShortString(buffer, this._queue);
        this.writeAMQShortString(buffer, this._consumerTag);
        this.writeBitfield(buffer, this._bitfield0);
        this.writeFieldTable(buffer, this._filter);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_0_9)dispatcher).dispatchStreamConsume(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[StreamConsumeBodyImpl: ");
        buf.append("ticket=");
        buf.append(this.getTicket());
        buf.append(", ");
        buf.append("queue=");
        buf.append(this.getQueue());
        buf.append(", ");
        buf.append("consumerTag=");
        buf.append(this.getConsumerTag());
        buf.append(", ");
        buf.append("noLocal=");
        buf.append(this.getNoLocal());
        buf.append(", ");
        buf.append("exclusive=");
        buf.append(this.getExclusive());
        buf.append(", ");
        buf.append("nowait=");
        buf.append(this.getNowait());
        buf.append(", ");
        buf.append("filter=");
        buf.append(this.getFilter());
        buf.append("]");
        return buf.toString();
    }
}

