/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.pool;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.andes.pool.ReadWriteRunnable;
import org.wso2.andes.pool.ReferenceCountingService;

public class Job
implements ReadWriteRunnable {
    public static final int MAX_JOB_EVENTS = Integer.getInteger("amqj.server.read_write_pool.max_events", 10);
    private final int _maxEvents;
    private final Queue<Runnable> _eventQueue = new ConcurrentLinkedQueue<Runnable>();
    private final AtomicBoolean _active = new AtomicBoolean();
    private final boolean _readJob;
    private ReferenceCountingService _poolReference;
    private static final Logger _logger = LoggerFactory.getLogger(Job.class);
    long totTime = 0L;
    int count = 0;

    public Job(ReferenceCountingService poolReference, int maxEvents, boolean readJob) {
        this._poolReference = poolReference;
        this._maxEvents = maxEvents;
        this._readJob = readJob;
    }

    public void add(Runnable evt) {
        this._eventQueue.add(evt);
    }

    boolean processAll() {
        int i = this._maxEvents;
        while (--i != 0) {
            try {
                Runnable e = this._eventQueue.poll();
                if (e == null) {
                    return true;
                }
                long start = System.nanoTime();
                e.run();
                this.totTime += (System.nanoTime() - start) / 1000000L;
                ++this.count;
                if (!_logger.isDebugEnabled() || this.count % 100 != 0) continue;
                _logger.debug("Runnable took " + this.totTime / (long)this.count + " ms " + this._eventQueue.size() + " jobs left");
            }
            catch (Throwable e) {
                _logger.error("Error occurred while processing job pool ", e);
            }
        }
        return false;
    }

    public boolean isComplete() {
        return this._eventQueue.peek() == null;
    }

    public boolean activate() {
        return this._active.compareAndSet(false, true);
    }

    public void deactivate() {
        this._active.set(false);
    }

    @Override
    public void run() {
        if (this.processAll()) {
            this.deactivate();
            this.completed();
        } else {
            this.notCompleted();
        }
    }

    @Override
    public boolean isRead() {
        return this._readJob;
    }

    public static void fireAsynchEvent(ExecutorService pool, Job job, Runnable event) {
        job.add(event);
        if (pool == null) {
            return;
        }
        if (job.activate()) {
            try {
                pool.execute(job);
            }
            catch (RejectedExecutionException e) {
                _logger.warn("Thread pool shutdown while tasks still outstanding:" + e.getMessage(), e);
            }
        }
    }

    public void completed() {
        if (!this.isComplete()) {
            ExecutorService pool = this._poolReference.getPool();
            if (pool == null) {
                return;
            }
            if (this.activate()) {
                try {
                    pool.execute(this);
                }
                catch (RejectedExecutionException e) {
                    _logger.warn("Thread pool shutdown while tasks still outstanding");
                }
            }
        }
    }

    public void notCompleted() {
        ExecutorService pool = this._poolReference.getPool();
        if (pool == null) {
            return;
        }
        try {
            pool.execute(this);
        }
        catch (RejectedExecutionException e) {
            _logger.warn("Thread pool shutdown while tasks still outstanding");
        }
    }
}

