/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.transport;

import java.util.LinkedHashMap;
import java.util.Map;
import org.wso2.andes.transport.Method;
import org.wso2.andes.transport.MethodDelegate;
import org.wso2.andes.transport.Option;
import org.wso2.andes.transport.codec.Decoder;
import org.wso2.andes.transport.codec.Encoder;

public final class ConnectionStartOk
extends Method {
    public static final int TYPE = 258;
    private short packing_flags = 0;
    private Map<String, Object> clientProperties;
    private String mechanism;
    private byte[] response;
    private String locale;

    @Override
    public final int getStructType() {
        return 258;
    }

    @Override
    public final int getSizeWidth() {
        return 0;
    }

    @Override
    public final int getPackWidth() {
        return 2;
    }

    @Override
    public final boolean hasPayload() {
        return false;
    }

    @Override
    public final byte getEncodedTrack() {
        return 0;
    }

    @Override
    public final boolean isConnectionControl() {
        return true;
    }

    public ConnectionStartOk() {
    }

    public ConnectionStartOk(Map<String, Object> clientProperties, String mechanism, byte[] response, String locale, Option ... _options) {
        if (clientProperties != null) {
            this.setClientProperties(clientProperties);
        }
        if (mechanism != null) {
            this.setMechanism(mechanism);
        }
        if (response != null) {
            this.setResponse(response);
        }
        if (locale != null) {
            this.setLocale(locale);
        }
        block6: for (int i = 0; i < _options.length; ++i) {
            switch (_options[i]) {
                case SYNC: {
                    this.setSync(true);
                    continue block6;
                }
                case BATCH: {
                    this.setBatch(true);
                    continue block6;
                }
                case UNRELIABLE: {
                    this.setUnreliable(true);
                    continue block6;
                }
                case NONE: {
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("invalid option: " + (Object)((Object)_options[i]));
                }
            }
        }
    }

    @Override
    public <C> void dispatch(C context, MethodDelegate<C> delegate) {
        delegate.connectionStartOk(context, this);
    }

    public final boolean hasClientProperties() {
        return (this.packing_flags & 0x100) != 0;
    }

    public final ConnectionStartOk clearClientProperties() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFEFF);
        this.clientProperties = null;
        this.dirty = true;
        return this;
    }

    public final Map<String, Object> getClientProperties() {
        return this.clientProperties;
    }

    public final ConnectionStartOk setClientProperties(Map<String, Object> value) {
        this.clientProperties = value;
        this.packing_flags = (short)(this.packing_flags | 0x100);
        this.dirty = true;
        return this;
    }

    public final ConnectionStartOk clientProperties(Map<String, Object> value) {
        return this.setClientProperties(value);
    }

    public final boolean hasMechanism() {
        return (this.packing_flags & 0x200) != 0;
    }

    public final ConnectionStartOk clearMechanism() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFDFF);
        this.mechanism = null;
        this.dirty = true;
        return this;
    }

    public final String getMechanism() {
        return this.mechanism;
    }

    public final ConnectionStartOk setMechanism(String value) {
        this.mechanism = value;
        this.packing_flags = (short)(this.packing_flags | 0x200);
        this.dirty = true;
        return this;
    }

    public final ConnectionStartOk mechanism(String value) {
        return this.setMechanism(value);
    }

    public final boolean hasResponse() {
        return (this.packing_flags & 0x400) != 0;
    }

    public final ConnectionStartOk clearResponse() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFBFF);
        this.response = null;
        this.dirty = true;
        return this;
    }

    public final byte[] getResponse() {
        return this.response;
    }

    public final ConnectionStartOk setResponse(byte[] value) {
        this.response = value;
        this.packing_flags = (short)(this.packing_flags | 0x400);
        this.dirty = true;
        return this;
    }

    public final ConnectionStartOk response(byte[] value) {
        return this.setResponse(value);
    }

    public final boolean hasLocale() {
        return (this.packing_flags & 0x800) != 0;
    }

    public final ConnectionStartOk clearLocale() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFF7FF);
        this.locale = null;
        this.dirty = true;
        return this;
    }

    public final String getLocale() {
        return this.locale;
    }

    public final ConnectionStartOk setLocale(String value) {
        this.locale = value;
        this.packing_flags = (short)(this.packing_flags | 0x800);
        this.dirty = true;
        return this;
    }

    public final ConnectionStartOk locale(String value) {
        return this.setLocale(value);
    }

    @Override
    public void write(Encoder enc) {
        enc.writeUint16(this.packing_flags);
        if ((this.packing_flags & 0x100) != 0) {
            enc.writeMap(this.clientProperties);
        }
        if ((this.packing_flags & 0x200) != 0) {
            enc.writeStr8(this.mechanism);
        }
        if ((this.packing_flags & 0x400) != 0) {
            enc.writeVbin32(this.response);
        }
        if ((this.packing_flags & 0x800) != 0) {
            enc.writeStr8(this.locale);
        }
    }

    @Override
    public void read(Decoder dec) {
        this.packing_flags = (short)dec.readUint16();
        if ((this.packing_flags & 0x100) != 0) {
            this.clientProperties = dec.readMap();
        }
        if ((this.packing_flags & 0x200) != 0) {
            this.mechanism = dec.readStr8();
        }
        if ((this.packing_flags & 0x400) != 0) {
            this.response = dec.readVbin32();
        }
        if ((this.packing_flags & 0x800) != 0) {
            this.locale = dec.readStr8();
        }
    }

    @Override
    public Map<String, Object> getFields() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if ((this.packing_flags & 0x100) != 0) {
            result.put("clientProperties", this.getClientProperties());
        }
        if ((this.packing_flags & 0x200) != 0) {
            result.put("mechanism", this.getMechanism());
        }
        if ((this.packing_flags & 0x400) != 0) {
            result.put("response", this.getResponse());
        }
        if ((this.packing_flags & 0x800) != 0) {
            result.put("locale", this.getLocale());
        }
        return result;
    }
}

